/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.dialect.function.json.JsonExistsFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.type.spi.TypeConfiguration;

public class MySQLJsonExistsFunction
extends JsonExistsFunction {
    public MySQLJsonExistsFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonExistsFunction.JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        JsonPathPassingClause passingClause = arguments.passingClause();
        sqlAppender.appendSql("json_contains_path(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(",'one',");
        if (passingClause == null) {
            arguments.jsonPath().accept(walker);
        } else {
            JsonPathHelper.appendJsonPathConcatPassingClause(sqlAppender, arguments.jsonPath(), passingClause, walker);
        }
        sqlAppender.appendSql(')');
    }
}

