/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmJsonTableFunction;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableNestedColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableValueColumnDefinition;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonTableSetReturningFunctionTypeResolver
implements SetReturningFunctionTypeResolver {
    @Override
    public AnonymousTupleType<?> resolveTupleType(List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        SqmJsonTableFunction.Columns columns = (SqmJsonTableFunction.Columns)arguments.get(arguments.size() - 1);
        return columns.createTupleType();
    }

    @Override
    public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
        JsonTableColumnsClause columnsClause = null;
        for (SqlAstNode sqlAstNode : arguments) {
            if (!(sqlAstNode instanceof JsonTableColumnsClause)) continue;
            columnsClause = (JsonTableColumnsClause)sqlAstNode;
            break;
        }
        assert (columnsClause != null);
        List<JsonTableColumnDefinition> columnDefinitions = columnsClause.getColumnDefinitions();
        ArrayList<SelectableMapping> arrayList = new ArrayList<SelectableMapping>(columnDefinitions.size());
        this.addSelectableMappings(arrayList, columnsClause, converter);
        return arrayList.toArray(new SelectableMapping[0]);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableNestedColumnDefinition columnDefinition, SqmToSqlAstConverter converter) {
        this.addSelectableMappings(selectableMappings, columnDefinition.columns(), converter);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableColumnsClause columnsClause, SqmToSqlAstConverter converter) {
        for (JsonTableColumnDefinition columnDefinition : columnsClause.getColumnDefinitions()) {
            if (columnDefinition instanceof JsonTableExistsColumnDefinition) {
                JsonTableExistsColumnDefinition definition = (JsonTableExistsColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
                continue;
            }
            if (columnDefinition instanceof JsonTableQueryColumnDefinition) {
                JsonTableQueryColumnDefinition definition = (JsonTableQueryColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
                continue;
            }
            if (columnDefinition instanceof JsonTableValueColumnDefinition) {
                JsonTableValueColumnDefinition definition = (JsonTableValueColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
                continue;
            }
            if (columnDefinition instanceof JsonTableOrdinalityColumnDefinition) {
                JsonTableOrdinalityColumnDefinition definition = (JsonTableOrdinalityColumnDefinition)columnDefinition;
                this.addSelectableMappings(selectableMappings, definition, converter);
                continue;
            }
            this.addSelectableMappings(selectableMappings, (JsonTableNestedColumnDefinition)columnDefinition, converter);
        }
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableOrdinalityColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class), converter);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableValueColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), definition.type().getJdbcMapping(), converter);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableQueryColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), converter.getCreationContext().getTypeConfiguration().getBasicTypeRegistry().resolve(String.class, 3001), converter);
    }

    protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableExistsColumnDefinition definition, SqmToSqlAstConverter converter) {
        this.addSelectableMapping(selectableMappings, definition.name(), converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Boolean.class), converter);
    }

    protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
        selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), null, null, null, null, null, null, null, false, false, false, false, false, false, type));
    }
}

