/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonTableFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonTableFunction;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.internal.ColumnQualifierCollectorSqlAstWalker;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAJsonTableFunction
extends JsonTableFunction {
    public HANAJsonTableFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, JsonTableFunction.JsonTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_table(");
        arguments.jsonDocument().accept(walker);
        Expression expression = arguments.jsonDocument();
        if (expression instanceof TableColumnReferenceExpression) {
            TableColumnReferenceExpression expression2 = (TableColumnReferenceExpression)expression;
            sqlAppender.appendSql(",'$' columns(");
            for (ColumnInfo columnInfo : expression2.getIdColumns()) {
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendSql(columnInfo.ddlType());
                sqlAppender.appendSql(" path '$.");
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql("',");
            }
            if (arguments.jsonPath() != null) {
                passingClause = arguments.passingClause();
                String rawJsonPath = passingClause != null ? JsonPathHelper.inlinedJsonPathIncludingPassingClause(arguments.jsonPath(), passingClause, walker) : (String)walker.getLiteralValue(arguments.jsonPath());
                assert (rawJsonPath.charAt(0) == '$');
                String jsonPath = "$.v" + rawJsonPath.substring(1);
                sqlAppender.appendSql("nested path '");
                sqlAppender.appendSql(jsonPath);
                sqlAppender.appendSql("' columns");
            } else {
                sqlAppender.appendSql("nested path '$.v' columns");
            }
        } else if (arguments.jsonPath() != null) {
            sqlAppender.appendSql(',');
            passingClause = arguments.passingClause();
            if (passingClause != null) {
                JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
            } else {
                arguments.jsonPath().accept(walker);
            }
            sqlAppender.appendSql(" columns");
        } else {
            sqlAppender.appendSql(",'$[*]' columns");
        }
        this.renderColumnDefinitions(sqlAppender, arguments.columnsClause(), '(', 0, walker);
        sqlAppender.appendSql(')');
        if (arguments.jsonDocument() instanceof TableColumnReferenceExpression) {
            sqlAppender.appendSql(')');
        }
        if (arguments.errorBehavior() == JsonTableErrorBehavior.ERROR) {
            sqlAppender.appendSql(" error on error");
        }
        sqlAppender.appendSql(')');
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        String columnType;
        switch (columnType = super.determineColumnType(castTarget, walker)) {
            case "boolean": {
                return "varchar(5)";
            }
            case "clob": {
                return "varchar(5000)";
            }
            case "nclob": {
                return "nvarchar(5000)";
            }
        }
        return columnType;
    }

    @Override
    protected void renderColumnPath(String name, @Nullable String jsonPath, SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
        if (jsonPath != null) {
            super.renderColumnPath(name, jsonPath, sqlAppender, walker);
        } else {
            sqlAppender.appendSql(" path '$.");
            sqlAppender.appendSql(name);
            sqlAppender.appendSql('\'');
        }
    }

    @Override
    protected void renderJsonExistsColumnDefinition(SqlAppender sqlAppender, JsonTableExistsColumnDefinition definition, int clauseLevel, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" varchar(5) ");
        this.renderColumnPath(definition.name(), definition.jsonPath(), sqlAppender, walker);
        sqlAppender.appendSql(" default 'false' on empty");
        JsonExistsErrorBehavior errorBehavior = definition.errorBehavior();
        if (errorBehavior == JsonExistsErrorBehavior.TRUE) {
            sqlAppender.appendSql(" default 'true' on error");
        } else if (errorBehavior == JsonExistsErrorBehavior.ERROR) {
            sqlAppender.appendSql(" error on error");
        } else {
            sqlAppender.appendSql(" default 'false' on error");
        }
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SqmJsonTableFunction<T>(this, this, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), (SqmExpression)arguments.get(0), arguments.size() > 1 ? (SqmExpression)arguments.get(1) : null){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                List<? extends SqlAstNode> sqlArguments = functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
                Expression argument = (Expression)sqlArguments.get(0);
                Set<String> qualifiers = ColumnQualifierCollectorSqlAstWalker.determineColumnQualifiers(argument);
                if (qualifiers.size() == 1) {
                    String tableQualifier = qualifiers.iterator().next();
                    FromClauseAccess fromClauseAccess = walker.getFromClauseAccess();
                    TableGroup sourceTableGroup = fromClauseAccess.findTableGroupByIdentificationVariable(tableQualifier);
                    if (sourceTableGroup != null) {
                        ArrayList<ColumnInfo> idColumns = new ArrayList<ColumnInfo>();
                        this.addIdColumns(sourceTableGroup.getModelPart(), idColumns);
                        walker.registerQueryTransformer((cteContainer, querySpec, converter) -> {
                            String cteName;
                            String baseName = "_data";
                            int index = 0;
                            while (cteContainer.getCteStatement(cteName = "_data" + index++) != null) {
                            }
                            TableGroup parentTableGroup = querySpec.getFromClause().queryTableGroups(tg -> tg.findTableGroupJoin(functionTableGroup) == null ? null : tg);
                            TableGroupJoin join = parentTableGroup.findTableGroupJoin(functionTableGroup);
                            Expression lhs = this.createExpression(tableQualifier, idColumns);
                            Expression rhs = this.createExpression(functionTableGroup.getPrimaryTableReference().getIdentificationVariable(), idColumns);
                            join.applyPredicate(new ComparisonPredicate(lhs, ComparisonOperator.EQUAL, rhs));
                            String tableName = cteName;
                            List<CteColumn> cteColumns = List.of(new CteColumn("v", argument.getExpressionType().getSingleJdbcMapping()));
                            QuerySpec cteQuery = new QuerySpec(false);
                            cteQuery.getFromClause().addRoot(new StandardTableGroup(true, sourceTableGroup.getNavigablePath(), (TableGroupProducer)sourceTableGroup.getModelPart(), false, null, sourceTableGroup.findTableReference(tableQualifier), false, null, joinTableName -> false, (joinTableName, tg) -> null, null));
                            JsonWrapperExpression wrapperExpression = new JsonWrapperExpression(idColumns, tableQualifier, argument);
                            cteQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(wrapperExpression));
                            cteContainer.addCteStatement(new CteStatement(new CteTable(tableName, cteColumns), new SelectStatement(cteQuery)));
                            sqlArguments.set(0, new TableColumnReferenceExpression(argument, tableName, idColumns));
                            return querySpec;
                        });
                    }
                }
                return functionTableGroup;
            }

            private Expression createExpression(String qualifier, List<ColumnInfo> idColumns) {
                if (idColumns.size() == 1) {
                    ColumnInfo columnInfo = idColumns.get(0);
                    return new ColumnReference(qualifier, columnInfo.name(), false, null, columnInfo.jdbcMapping());
                }
                ArrayList<ColumnReference> expressions = new ArrayList<ColumnReference>(idColumns.size());
                for (ColumnInfo columnInfo : idColumns) {
                    expressions.add(new ColumnReference(qualifier, columnInfo.name(), false, null, columnInfo.jdbcMapping()));
                }
                return new SqlTuple(expressions, null);
            }

            private void addIdColumns(ModelPartContainer modelPartContainer, List<ColumnInfo> idColumns) {
                if (modelPartContainer instanceof EntityValuedModelPart) {
                    EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPartContainer;
                    this.addIdColumns(entityValuedModelPart.getEntityMappingType(), idColumns);
                } else if (modelPartContainer instanceof PluralAttributeMapping) {
                    PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPartContainer;
                    this.addIdColumns(pluralAttributeMapping, idColumns);
                } else if (modelPartContainer instanceof EmbeddableValuedModelPart) {
                    EmbeddableValuedModelPart embeddableModelPart = (EmbeddableValuedModelPart)modelPartContainer;
                    this.addIdColumns(embeddableModelPart, idColumns);
                } else {
                    throw new QueryException("Unsupported model part container: " + modelPartContainer);
                }
            }

            private void addIdColumns(EmbeddableValuedModelPart embeddableModelPart, List<ColumnInfo> idColumns) {
                if (embeddableModelPart instanceof EmbeddedCollectionPart) {
                    EmbeddedCollectionPart collectionPart = (EmbeddedCollectionPart)embeddableModelPart;
                    this.addIdColumns(collectionPart.getCollectionAttribute(), idColumns);
                } else {
                    this.addIdColumns(embeddableModelPart.asAttributeMapping().getDeclaringType(), idColumns);
                }
            }

            private void addIdColumns(PluralAttributeMapping pluralAttributeMapping, List<ColumnInfo> idColumns) {
                DdlTypeRegistry ddlTypeRegistry = pluralAttributeMapping.getCollectionDescriptor().getFactory().getTypeConfiguration().getDdlTypeRegistry();
                this.addIdColumns(pluralAttributeMapping.getKeyDescriptor().getKeyPart(), ddlTypeRegistry, idColumns);
            }

            private void addIdColumns(EntityMappingType entityMappingType, List<ColumnInfo> idColumns) {
                DdlTypeRegistry ddlTypeRegistry = entityMappingType.getEntityPersister().getFactory().getTypeConfiguration().getDdlTypeRegistry();
                this.addIdColumns(entityMappingType.getIdentifierMapping(), ddlTypeRegistry, idColumns);
            }

            private void addIdColumns(ValuedModelPart modelPart, DdlTypeRegistry ddlTypeRegistry, List<ColumnInfo> idColumns) {
                modelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
                    JdbcMapping jdbcMapping = selectableMapping.getJdbcMapping().getSingleJdbcMapping();
                    idColumns.add(new ColumnInfo(selectableMapping.getSelectionExpression(), jdbcMapping, ddlTypeRegistry.getTypeName(jdbcMapping.getJdbcType().getDefaultSqlTypeCode(), selectableMapping.toSize(), (Type)((Object)jdbcMapping))));
                });
            }
        };
    }

    static class TableColumnReferenceExpression
    implements SelfRenderingExpression {
        private final Expression argument;
        private final String tableName;
        private final List<ColumnInfo> idColumns;

        public TableColumnReferenceExpression(Expression argument, String tableName, List<ColumnInfo> idColumns) {
            this.argument = argument;
            this.tableName = tableName;
            this.idColumns = idColumns;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql(this.tableName);
            sqlAppender.appendSql(".v");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }

        public List<ColumnInfo> getIdColumns() {
            return this.idColumns;
        }
    }

    record ColumnInfo(String name, JdbcMapping jdbcMapping, String ddlType) {
    }

    static class JsonWrapperExpression
    implements SelfRenderingExpression {
        private final List<ColumnInfo> idColumns;
        private final String tableQualifier;
        private final Expression argument;

        public JsonWrapperExpression(List<ColumnInfo> idColumns, String tableQualifier, Expression argument) {
            this.idColumns = idColumns;
            this.tableQualifier = tableQualifier;
            this.argument = argument;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql("'{'||trim('{}' from (select");
            int separator = 32;
            for (ColumnInfo columnInfo : this.idColumns) {
                sqlAppender.appendSql((char)separator);
                sqlAppender.appendSql(this.tableQualifier);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendDoubleQuoteEscapedString(columnInfo.name());
                separator = 44;
            }
            sqlAppender.appendSql(" from sys.dummy for json('arraywrap'='no')))||");
            sqlAppender.appendSql("',\"v\":'||");
            this.argument.accept(walker);
            sqlAppender.appendSql("||'}'");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }
    }
}

