/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.json.JsonObjectFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAJsonObjectFunction
extends JsonObjectFunction {
    public HANAJsonObjectFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        int argumentsCount;
        JsonNullBehavior nullBehavior;
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql("'{}'");
            return;
        }
        if ((sqlAstArguments.size() & 1) == 1) {
            nullBehavior = (JsonNullBehavior)sqlAstArguments.get(sqlAstArguments.size() - 1);
            argumentsCount = sqlAstArguments.size() - 1;
        } else {
            nullBehavior = JsonNullBehavior.NULL;
            argumentsCount = sqlAstArguments.size();
        }
        List<String> jsonArgumentFields = this.getJsonArgumentFields(sqlAstArguments, argumentsCount, walker);
        sqlAppender.appendSql('(');
        HANAJsonObjectFunction.replaceJsonArgumentsEscaping(sqlAppender, sqlAstArguments, walker, 0, jsonArgumentFields, argumentsCount, nullBehavior);
        sqlAppender.appendSql(')');
    }

    private static void replaceJsonArgumentsEscaping(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker, int jsonArg, List<String> jsonArgumentFields, int argumentsCount, JsonNullBehavior nullBehavior) {
        if (jsonArg < jsonArgumentFields.size()) {
            sqlAppender.appendSql("select substring(t.x, 1, locate_regexpr(r.x in t.x) - 2)");
            sqlAppender.appendSql("|| replace(replace(substr_regexpr(r.x in t.x),'\\\\','\\'),'\\\"','\"')");
            sqlAppender.appendSql("|| substring(t.x, locate_regexpr(r.x in t.x) + length(substr_regexpr(r.x in t.x)) + 1) x");
            sqlAppender.appendSql(" from (");
            HANAJsonObjectFunction.replaceJsonArgumentsEscaping(sqlAppender, sqlAstArguments, walker, jsonArg + 1, jsonArgumentFields, argumentsCount, nullBehavior);
            sqlAppender.appendSql(") t");
            sqlAppender.appendSql(",(select '");
            sqlAppender.appendSql(HANAJsonObjectFunction.valueExtractionPattern(jsonArgumentFields.get(jsonArg)));
            sqlAppender.appendSql("' x from sys.dummy) r");
        } else {
            sqlAppender.appendSql("select t.jsonresult x from (select");
            int separator = 32;
            for (int i = 0; i < argumentsCount; i += 2) {
                sqlAppender.appendSql((char)separator);
                SqlAstNode key = sqlAstArguments.get(i);
                SqlAstNode value = sqlAstArguments.get(i + 1);
                value.accept(walker);
                sqlAppender.appendSql(' ');
                String literalValue = (String)walker.getLiteralValue((Expression)key);
                sqlAppender.appendDoubleQuoteEscapedString(literalValue);
                separator = 44;
            }
            sqlAppender.appendSql(" from sys.dummy for json('arraywrap'='no'");
            if (nullBehavior == JsonNullBehavior.NULL) {
                sqlAppender.appendSql(",'omitnull'='no'");
            }
            sqlAppender.appendSql(")) t");
        }
    }

    private List<String> getJsonArgumentFields(List<? extends SqlAstNode> sqlAstArguments, int argumentsCount, SqlAstTranslator<?> walker) {
        ArrayList<String> jsonArgumentIndexes = new ArrayList<String>();
        for (int i = 0; i < argumentsCount; i += 2) {
            if (!ExpressionTypeHelper.isJson(sqlAstArguments.get(i + 1))) continue;
            jsonArgumentIndexes.add((String)walker.getLiteralValue((Expression)sqlAstArguments.get(i)));
        }
        return jsonArgumentIndexes;
    }

    private static String valueExtractionPattern(String attributeName) {
        return "(?<!\\\\)(?<=\"" + Pattern.quote(attributeName) + "\":\").*?(?<!\\\\)(?=\")";
    }
}

