/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.dialect.function.json.JsonExistsFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAJsonExistsFunction
extends JsonExistsFunction {
    public HANAJsonExistsFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonExistsFunction.JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_query(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(',');
        Expression jsonPath = arguments.jsonPath();
        JsonPathPassingClause passingClause = arguments.passingClause();
        if (passingClause == null) {
            jsonPath.accept(walker);
        } else {
            JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
        }
        JsonExistsErrorBehavior errorBehavior = arguments.errorBehavior();
        if (errorBehavior != null && errorBehavior != JsonExistsErrorBehavior.FALSE) {
            if (errorBehavior == JsonExistsErrorBehavior.TRUE) {
                sqlAppender.appendSql(" empty object on error");
            } else {
                sqlAppender.appendSql(" error on error");
            }
        }
        sqlAppender.appendSql(") is not null");
    }
}

