/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.array.UnnestFunction;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;

public class OracleUnnestFunction
extends UnnestFunction {
    public OracleUnnestFunction() {
        super("column_value", "i");
    }

    @Override
    protected void renderUnnest(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        boolean withOrdinality;
        ModelPart ordinalitySubPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        boolean bl = withOrdinality = ordinalitySubPart != null;
        if (withOrdinality) {
            sqlAppender.appendSql("lateral (select t.*, rownum ");
            sqlAppender.appendSql(ordinalitySubPart.asBasicValuedModelPart().getSelectionExpression());
            sqlAppender.appendSql(" from ");
        }
        sqlAppender.appendSql("table(");
        array.accept(walker);
        sqlAppender.appendSql(")");
        if (withOrdinality) {
            sqlAppender.appendSql(" t)");
        }
    }
}

