/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.XmlHelper;
import org.hibernate.dialect.function.array.UnnestFunction;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.json.HANAJsonValueFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.internal.ColumnQualifierCollectorSqlAstWalker;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class HANAUnnestFunction
extends UnnestFunction {
    public HANAUnnestFunction() {
        super("v", "i");
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                List<? extends SqlAstNode> sqlArguments = functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
                Expression argument = (Expression)sqlArguments.get(0);
                Set<String> qualifiers = ColumnQualifierCollectorSqlAstWalker.determineColumnQualifiers(argument);
                if (qualifiers.size() == 1) {
                    String tableQualifier = qualifiers.iterator().next();
                    FromClauseAccess fromClauseAccess = walker.getFromClauseAccess();
                    TableGroup sourceTableGroup = fromClauseAccess.findTableGroupByIdentificationVariable(tableQualifier);
                    if (sourceTableGroup != null) {
                        ArrayList<ColumnInfo> idColumns = new ArrayList<ColumnInfo>();
                        this.addIdColumns(sourceTableGroup.getModelPart(), idColumns);
                        walker.registerQueryTransformer((cteContainer, querySpec, converter) -> {
                            SelfRenderingExpression wrapperExpression;
                            String cteName;
                            String baseName = "_data";
                            int index = 0;
                            while (cteContainer.getCteStatement(cteName = "_data" + index++) != null) {
                            }
                            TableGroup parentTableGroup = querySpec.getFromClause().queryTableGroups(tg -> tg.findTableGroupJoin(functionTableGroup) == null ? null : tg);
                            TableGroupJoin join = parentTableGroup.findTableGroupJoin(functionTableGroup);
                            Expression lhs = this.createExpression(tableQualifier, idColumns);
                            Expression rhs = this.createExpression(functionTableGroup.getPrimaryTableReference().getIdentificationVariable(), idColumns);
                            join.applyPredicate(new ComparisonPredicate(lhs, ComparisonOperator.EQUAL, rhs));
                            String tableName = cteName;
                            List<CteColumn> cteColumns = List.of(new CteColumn("v", argument.getExpressionType().getSingleJdbcMapping()));
                            QuerySpec cteQuery = new QuerySpec(false);
                            cteQuery.getFromClause().addRoot(new StandardTableGroup(true, sourceTableGroup.getNavigablePath(), (TableGroupProducer)sourceTableGroup.getModelPart(), false, null, sourceTableGroup.findTableReference(tableQualifier), false, null, joinTableName -> false, (joinTableName, tg) -> null, null));
                            if (ExpressionTypeHelper.isXml(argument)) {
                                wrapperExpression = new XmlWrapperExpression(idColumns, tableQualifier, argument);
                                cteQuery.applyPredicate(new NullnessPredicate(argument, true));
                            } else {
                                wrapperExpression = new JsonWrapperExpression(idColumns, tableQualifier, argument);
                            }
                            cteQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(wrapperExpression));
                            cteContainer.addCteStatement(new CteStatement(new CteTable(tableName, cteColumns), new SelectStatement(cteQuery)));
                            sqlArguments.set(0, new TableColumnReferenceExpression(argument, tableName, idColumns));
                            return querySpec;
                        });
                    }
                }
                return functionTableGroup;
            }

            private Expression createExpression(String qualifier, List<ColumnInfo> idColumns) {
                if (idColumns.size() == 1) {
                    ColumnInfo columnInfo = idColumns.get(0);
                    return new ColumnReference(qualifier, columnInfo.name(), false, null, columnInfo.jdbcMapping());
                }
                ArrayList<ColumnReference> expressions = new ArrayList<ColumnReference>(idColumns.size());
                for (ColumnInfo columnInfo : idColumns) {
                    expressions.add(new ColumnReference(qualifier, columnInfo.name(), false, null, columnInfo.jdbcMapping()));
                }
                return new SqlTuple(expressions, null);
            }

            private void addIdColumns(ModelPartContainer modelPartContainer, List<ColumnInfo> idColumns) {
                if (modelPartContainer instanceof EntityValuedModelPart) {
                    EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPartContainer;
                    this.addIdColumns(entityValuedModelPart.getEntityMappingType(), idColumns);
                } else if (modelPartContainer instanceof PluralAttributeMapping) {
                    PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPartContainer;
                    this.addIdColumns(pluralAttributeMapping, idColumns);
                } else if (modelPartContainer instanceof EmbeddableValuedModelPart) {
                    EmbeddableValuedModelPart embeddableModelPart = (EmbeddableValuedModelPart)modelPartContainer;
                    this.addIdColumns(embeddableModelPart, idColumns);
                } else {
                    throw new QueryException("Unsupported model part container: " + modelPartContainer);
                }
            }

            private void addIdColumns(EmbeddableValuedModelPart embeddableModelPart, List<ColumnInfo> idColumns) {
                if (embeddableModelPart instanceof EmbeddedCollectionPart) {
                    EmbeddedCollectionPart collectionPart = (EmbeddedCollectionPart)embeddableModelPart;
                    this.addIdColumns(collectionPart.getCollectionAttribute(), idColumns);
                } else {
                    this.addIdColumns(embeddableModelPart.asAttributeMapping().getDeclaringType(), idColumns);
                }
            }

            private void addIdColumns(PluralAttributeMapping pluralAttributeMapping, List<ColumnInfo> idColumns) {
                DdlTypeRegistry ddlTypeRegistry = pluralAttributeMapping.getCollectionDescriptor().getFactory().getTypeConfiguration().getDdlTypeRegistry();
                this.addIdColumns(pluralAttributeMapping.getKeyDescriptor().getKeyPart(), ddlTypeRegistry, idColumns);
            }

            private void addIdColumns(EntityMappingType entityMappingType, List<ColumnInfo> idColumns) {
                DdlTypeRegistry ddlTypeRegistry = entityMappingType.getEntityPersister().getFactory().getTypeConfiguration().getDdlTypeRegistry();
                this.addIdColumns(entityMappingType.getIdentifierMapping(), ddlTypeRegistry, idColumns);
            }

            private void addIdColumns(ValuedModelPart modelPart, DdlTypeRegistry ddlTypeRegistry, List<ColumnInfo> idColumns) {
                modelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
                    JdbcMapping jdbcMapping = selectableMapping.getJdbcMapping().getSingleJdbcMapping();
                    idColumns.add(new ColumnInfo(selectableMapping.getSelectionExpression(), jdbcMapping, ddlTypeRegistry.getTypeName(jdbcMapping.getJdbcType().getDefaultSqlTypeCode(), selectableMapping.toSize(), (Type)((Object)jdbcMapping))));
                });
            }
        };
    }

    @Override
    protected void renderXmlTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        int offset;
        XmlHelper.CollectionTags collectionTags = XmlHelper.determineCollectionTags((BasicPluralJavaType)((Object)pluralType.getJavaTypeDescriptor()), walker.getSessionFactory());
        sqlAppender.appendSql("xmltable('/");
        sqlAppender.appendSql(collectionTags.rootName());
        sqlAppender.appendSql('/');
        sqlAppender.appendSql(collectionTags.elementName());
        sqlAppender.appendSql("' passing ");
        array.accept(walker);
        sqlAppender.appendSql(" columns");
        int separator = 32;
        if (array instanceof TableColumnReferenceExpression) {
            TableColumnReferenceExpression expression = (TableColumnReferenceExpression)array;
            offset = expression.getIdColumns().size();
            for (ColumnInfo columnInfo : expression.getIdColumns()) {
                sqlAppender.appendSql((char)separator);
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendSql(columnInfo.ddlType());
                sqlAppender.appendSql(" path 'ancestor::");
                sqlAppender.appendSql(collectionTags.rootName());
                sqlAppender.appendSql("/@");
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql('\'');
                separator = 44;
            }
        } else {
            offset = 0;
        }
        if (tupleType.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null) == null) {
            tupleType.forEachSelectable(offset, (selectionIndex, selectableMapping) -> {
                if (selectionIndex == 0) {
                    sqlAppender.append(' ');
                } else {
                    sqlAppender.append(',');
                }
                sqlAppender.append(selectableMapping.getSelectionExpression());
                if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    sqlAppender.append(" for ordinality");
                } else {
                    sqlAppender.append(' ');
                    sqlAppender.append(this.getDdlType(selectableMapping, 3019, walker));
                    sqlAppender.appendSql(" path '");
                    sqlAppender.appendSql(selectableMapping.getSelectableName());
                    sqlAppender.appendSql("'");
                }
            });
        } else {
            tupleType.forEachSelectable(offset, (selectionIndex, selectableMapping) -> {
                if (selectionIndex == 0) {
                    sqlAppender.append(' ');
                } else {
                    sqlAppender.append(',');
                }
                sqlAppender.append(selectableMapping.getSelectionExpression());
                if (CollectionPart.Nature.INDEX.getName().equals(selectableMapping.getSelectableName())) {
                    sqlAppender.append(" for ordinality");
                } else {
                    sqlAppender.append(' ');
                    sqlAppender.append(this.getDdlType(selectableMapping, 3019, walker));
                    sqlAppender.appendSql(" path '");
                    sqlAppender.appendSql(".");
                    sqlAppender.appendSql("'");
                }
            });
        }
        sqlAppender.appendSql(')');
    }

    @Override
    protected String getDdlType(SqlTypedMapping sqlTypedMapping, int containerSqlTypeCode, SqlAstTranslator<?> translator) {
        String ddlType = super.getDdlType(sqlTypedMapping, containerSqlTypeCode, translator);
        if (containerSqlTypeCode == 3018) {
            return HANAJsonValueFunction.jsonValueReturningType(ddlType);
        }
        return ddlType;
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_table(");
        array.accept(walker);
        if (array instanceof TableColumnReferenceExpression) {
            TableColumnReferenceExpression expression = (TableColumnReferenceExpression)array;
            sqlAppender.appendSql(",'$' columns(");
            for (ColumnInfo columnInfo : expression.getIdColumns()) {
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendSql(columnInfo.ddlType());
                sqlAppender.appendSql(" path '$.");
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql("',");
            }
            sqlAppender.appendSql("nested path '$.v' columns");
            this.renderJsonTableColumns(sqlAppender, tupleType, walker, true);
            sqlAppender.appendSql("))");
        } else {
            sqlAppender.appendSql(",'$[*]' columns");
            this.renderJsonTableColumns(sqlAppender, tupleType, walker, true);
            sqlAppender.appendSql(")");
        }
    }

    static class TableColumnReferenceExpression
    implements SelfRenderingExpression {
        private final Expression argument;
        private final String tableName;
        private final List<ColumnInfo> idColumns;

        public TableColumnReferenceExpression(Expression argument, String tableName, List<ColumnInfo> idColumns) {
            this.argument = argument;
            this.tableName = tableName;
            this.idColumns = idColumns;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql(this.tableName);
            sqlAppender.appendSql(".v");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }

        public List<ColumnInfo> getIdColumns() {
            return this.idColumns;
        }
    }

    record ColumnInfo(String name, JdbcMapping jdbcMapping, String ddlType) {
    }

    static class JsonWrapperExpression
    implements SelfRenderingExpression {
        private final List<ColumnInfo> idColumns;
        private final String tableQualifier;
        private final Expression argument;

        public JsonWrapperExpression(List<ColumnInfo> idColumns, String tableQualifier, Expression argument) {
            this.idColumns = idColumns;
            this.tableQualifier = tableQualifier;
            this.argument = argument;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            sqlAppender.appendSql("'{'||trim('{}' from (select");
            int separator = 32;
            for (ColumnInfo columnInfo : this.idColumns) {
                sqlAppender.appendSql((char)separator);
                sqlAppender.appendSql(this.tableQualifier);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendDoubleQuoteEscapedString(columnInfo.name());
                separator = 44;
            }
            sqlAppender.appendSql(" from sys.dummy for json('arraywrap'='no')))||");
            sqlAppender.appendSql("',\"v\":'||case when ");
            this.argument.accept(walker);
            sqlAppender.appendSql(" not like '[]' then ");
            this.argument.accept(walker);
            sqlAppender.appendSql(" end||'}'");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }
    }

    static class XmlWrapperExpression
    implements SelfRenderingExpression {
        private final List<ColumnInfo> idColumns;
        private final String tableQualifier;
        private final Expression argument;

        public XmlWrapperExpression(List<ColumnInfo> idColumns, String tableQualifier, Expression argument) {
            this.idColumns = idColumns;
            this.tableQualifier = tableQualifier;
            this.argument = argument;
        }

        @Override
        public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
            BasicPluralType pluralType = (BasicPluralType)this.argument.getExpressionType().getSingleJdbcMapping();
            XmlHelper.CollectionTags collectionTags = XmlHelper.determineCollectionTags((BasicPluralJavaType)((Object)pluralType.getJavaTypeDescriptor()), sessionFactory);
            sqlAppender.appendSql("trim('/>' from (select");
            int separator = 32;
            for (ColumnInfo columnInfo : this.idColumns) {
                sqlAppender.appendSql((char)separator);
                sqlAppender.appendSql(this.tableQualifier);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(columnInfo.name());
                sqlAppender.appendSql(' ');
                sqlAppender.appendDoubleQuoteEscapedString(columnInfo.name());
                separator = 44;
            }
            sqlAppender.appendSql(" from sys.dummy for xml('root'='no','columnstyle'='attribute','rowname'='");
            sqlAppender.appendSql(collectionTags.rootName());
            sqlAppender.appendSql("','format'='no')))||substring(");
            this.argument.accept(walker);
            sqlAppender.appendSql(",locate('<");
            sqlAppender.appendSql(collectionTags.rootName());
            sqlAppender.appendSql(">',");
            this.argument.accept(walker);
            sqlAppender.appendSql(")+");
            sqlAppender.appendSql(collectionTags.rootName().length() + 2);
            sqlAppender.appendSql(",length(");
            this.argument.accept(walker);
            sqlAppender.appendSql("))");
        }

        @Override
        public JdbcMappingContainer getExpressionType() {
            return this.argument.getExpressionType();
        }
    }
}

