/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.UnnestSetReturningFunctionTypeResolver;
import org.hibernate.dialect.function.array.UnnestFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class H2UnnestFunction
extends UnnestFunction {
    private final int maximumArraySize;

    public H2UnnestFunction(int maximumArraySize) {
        super(new H2UnnestSetReturningFunctionTypeResolver());
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                List<? extends SqlAstNode> sqlArguments = functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
                final ColumnReference columnReference = ((Expression)sqlArguments.get(0)).getColumnReference();
                if (columnReference != null) {
                    String tableQualifier = columnReference.getQualifier();
                    FromClauseAccess fromClauseAccess = walker.getFromClauseAccess();
                    TableGroup sourceTableGroup = fromClauseAccess.findTableGroupByIdentificationVariable(tableQualifier);
                    if (sourceTableGroup != null) {
                        walker.registerQueryTransformer((cteContainer, querySpec, converter) -> {
                            TableGroup parentTableGroup = querySpec.getFromClause().queryTableGroups(tg -> tg.findTableGroupJoin(functionTableGroup) == null ? null : tg);
                            TableGroupJoin join = parentTableGroup.findTableGroupJoin(functionTableGroup);
                            final BasicType<Integer> integerType = walker.getCreationContext().getSessionFactory().getNodeBuilder().getIntegerType();
                            SelfRenderingExpression lhs = new SelfRenderingExpression(){

                                @Override
                                public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                                    sqlAppender.append("coalesce(array_length(");
                                    columnReference.accept(walker);
                                    sqlAppender.append("),0)");
                                }

                                @Override
                                public JdbcMappingContainer getExpressionType() {
                                    return integerType;
                                }
                            };
                            ColumnReference rhs = new ColumnReference(functionTableGroup.getPrimaryTableReference().getIdentificationVariable(), "x", false, null, integerType);
                            join.applyPredicate(new ComparisonPredicate(lhs, ComparisonOperator.GREATER_THAN_OR_EQUAL, rhs));
                            return querySpec;
                        });
                    }
                }
                return functionTableGroup;
            }
        };
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        this.renderUnnest(sqlAppender, array, pluralType, sqlTypedMapping, tupleType, tableIdentifierVariable, walker);
    }

    @Override
    protected void renderUnnest(SqlAppender sqlAppender, Expression array, BasicPluralType<?, ?> pluralType, @Nullable SqlTypedMapping sqlTypedMapping, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        ColumnReference columnReference = array.getColumnReference();
        if (columnReference != null) {
            sqlAppender.append("system_range(1,");
            sqlAppender.append(Integer.toString(this.maximumArraySize));
            sqlAppender.append(")");
        } else {
            super.renderUnnest(sqlAppender, array, pluralType, sqlTypedMapping, tupleType, tableIdentifierVariable, walker);
        }
    }

    private static class H2UnnestSetReturningFunctionTypeResolver
    extends UnnestSetReturningFunctionTypeResolver {
        public H2UnnestSetReturningFunctionTypeResolver() {
            super("c1", "nord");
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            SelectableMapping[] returnType;
            AggregateJdbcType aggregateJdbcType;
            Expression expression = (Expression)arguments.get(0);
            JdbcMappingContainer expressionType = expression.getExpressionType();
            if (expressionType == null) {
                throw new IllegalArgumentException("Couldn't determine array type of argument to function 'unnest'");
            }
            JdbcMapping jdbcMapping = expressionType.getSingleJdbcMapping();
            if (!(jdbcMapping instanceof BasicPluralType)) {
                throw new IllegalArgumentException("Argument passed to function 'unnest' is not a BasicPluralType. Found: " + expressionType);
            }
            BasicPluralType pluralType = (BasicPluralType)jdbcMapping;
            SelectableMappingImpl indexMapping = withOrdinality ? new SelectableMappingImpl("", expression.getColumnReference() != null ? "x" : this.defaultIndexSelectionExpression, new SelectablePath(CollectionPart.Nature.INDEX.getName()), null, null, null, null, null, null, null, false, false, false, false, false, false, converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class)) : null;
            BasicType elementType = pluralType.getElementType();
            JdbcType jdbcType = elementType.getJdbcType();
            if (jdbcType instanceof AggregateJdbcType && (aggregateJdbcType = (AggregateJdbcType)jdbcType).getEmbeddableMappingType() != null) {
                ColumnReference arrayColumnReference = expression.getColumnReference();
                if (arrayColumnReference == null) {
                    throw new IllegalArgumentException("Argument passed to function 'unnest' is not a column reference, but an aggregate type, which is not yet supported.");
                }
                String elementReadExpression = "array_get(" + arrayColumnReference.getExpressionText() + ",{@}.x)";
                String arrayReadExpression = NullnessUtil.castNonNull(arrayColumnReference.getReadExpression());
                EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                returnType = new SelectableMapping[jdbcValueCount + (indexMapping == null ? 0 : 1)];
                for (int i = 0; i < jdbcValueCount; ++i) {
                    SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                    String customReadExpression = selectableMapping.getCustomReadExpression().replace(arrayReadExpression, elementReadExpression);
                    returnType[i] = new SelectableMappingImpl(selectableMapping.getContainingTableExpression(), selectableMapping.getSelectablePath().getSelectableName(), new SelectablePath(selectableMapping.getSelectablePath().getSelectableName()), customReadExpression, selectableMapping.getCustomWriteExpression(), selectableMapping.getColumnDefinition(), selectableMapping.getLength(), selectableMapping.getPrecision(), selectableMapping.getScale(), selectableMapping.getTemporalPrecision(), selectableMapping.isLob(), true, false, false, false, selectableMapping.isFormula(), selectableMapping.getJdbcMapping());
                }
                if (indexMapping != null) {
                    returnType[jdbcValueCount] = indexMapping;
                }
            } else {
                SelectableMappingImpl elementMapping;
                String elementReadExpression;
                String elementSelectionExpression;
                ColumnReference columnReference = expression.getColumnReference();
                if (columnReference != null) {
                    elementSelectionExpression = columnReference.getColumnExpression();
                    elementReadExpression = "array_get(" + columnReference.getExpressionText() + ",{@}.x)";
                } else {
                    elementSelectionExpression = this.defaultBasicArrayColumnName;
                    elementReadExpression = null;
                }
                if (expressionType instanceof SqlTypedMapping) {
                    SqlTypedMapping typedMapping = (SqlTypedMapping)((Object)expressionType);
                    elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), elementReadExpression, null, typedMapping.getColumnDefinition(), typedMapping.getLength(), typedMapping.getPrecision(), typedMapping.getScale(), typedMapping.getTemporalPrecision(), typedMapping.isLob(), true, false, false, false, false, elementType);
                } else {
                    elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), elementReadExpression, null, null, null, null, null, null, false, true, false, false, false, false, elementType);
                }
                returnType = indexMapping == null ? new SelectableMapping[]{elementMapping} : new SelectableMapping[]{elementMapping, indexMapping};
            }
            return returnType;
        }
    }
}

