/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.function.DateTruncEmulation;
import org.hibernate.dialect.function.TruncFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class SybaseTruncFunction
extends TruncFunction {
    private final SybaseDateTruncEmulation dateTruncEmulation;

    public SybaseTruncFunction(TypeConfiguration typeConfiguration) {
        super("sign(?1)*floor(abs(?1))", "sign(?1)*floor(abs(?1)*power(10,?2))/power(10,?2)", null, null, typeConfiguration);
        this.dateTruncEmulation = new SybaseDateTruncEmulation("convert", typeConfiguration);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        ArrayList args = new ArrayList(arguments);
        if (arguments.size() == 2 && arguments.get(1) instanceof SqmExtractUnit) {
            return this.dateTruncEmulation.generateSqmFunctionExpression(arguments, impliedResultType, queryEngine);
        }
        return new SelfRenderingSqmFunction<T>(this, this.numericRenderingSupport, args, impliedResultType, TruncFunction.TruncArgumentsValidator.NUMERIC_VALIDATOR, this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    private static class SybaseDateTruncEmulation
    extends DateTruncEmulation {
        public SybaseDateTruncEmulation(String toDateFunction, TypeConfiguration typeConfiguration) {
            super(toDateFunction, typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
            sqlAppender.appendSql(this.toDateFunction);
            sqlAppender.append('(');
            sqlAppender.append("datetime,substring(convert(varchar,");
            sqlAstArguments.get(0).accept(walker);
            sqlAppender.append(",140),1,26");
            if (sqlAstArguments.size() > 1) {
                sqlAppender.append("-len(");
                sqlAstArguments.get(1).accept(walker);
                sqlAppender.append("))+");
                sqlAstArguments.get(1).accept(walker);
            } else {
                sqlAppender.append(')');
            }
            sqlAppender.append(",140)");
        }

        @Override
        protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
            TemporalUnit temporalUnit = ((SqmExtractUnit)arguments.get(1)).getUnit();
            String literal = switch (temporalUnit) {
                case TemporalUnit.YEAR -> "-01-01T00:00:00.000000";
                case TemporalUnit.MONTH -> "-01T00:00:00.000000";
                case TemporalUnit.DAY -> "T00:00:00.000000";
                case TemporalUnit.HOUR -> ":00:00.000000";
                case TemporalUnit.MINUTE -> ":00.000000";
                case TemporalUnit.SECOND -> ".000000";
                default -> throw new UnsupportedOperationException("Temporal unit not supported [" + temporalUnit + "]");
            };
            NodeBuilder nodeBuilder = queryEngine.getCriteriaBuilder();
            return new SelfRenderingSqmFunction<T>(this, this, Arrays.asList(arguments.get(0), new SqmLiteral<String>(literal, queryEngine.getTypeConfiguration().getBasicTypeForJavaType(String.class), nodeBuilder)), impliedResultType, null, this.getReturnTypeResolver(), nodeBuilder, this.getName());
        }
    }
}

