/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.sql.Timestamp;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.GenerateSeriesFunction;
import org.hibernate.dialect.function.GenerateSeriesSetReturningFunctionTypeResolver;
import org.hibernate.engine.spi.LazySessionWrapperOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.expression.NumericTypeCategory;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.expression.SelfRenderingSqlFragmentExpression;
import org.hibernate.sql.ast.tree.expression.UnparsedNumericLiteral;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.PredicateContainer;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class NumberSeriesGenerateSeriesFunction
extends GenerateSeriesFunction {
    protected final int maxSeriesSize;

    public NumberSeriesGenerateSeriesFunction(@Nullable String defaultValueColumnName, String defaultIndexSelectionExpression, boolean coerceToTimestamp, TypeConfiguration typeConfiguration, int maxSeriesSize) {
        super(defaultValueColumnName, defaultIndexSelectionExpression, coerceToTimestamp, typeConfiguration);
        this.maxSeriesSize = maxSeriesSize;
    }

    public NumberSeriesGenerateSeriesFunction(SetReturningFunctionTypeResolver setReturningFunctionTypeResolver, BasicType<java.time.Duration> durationType, int maxSeriesSize) {
        super(setReturningFunctionTypeResolver, durationType);
        this.maxSeriesSize = maxSeriesSize;
    }

    public NumberSeriesGenerateSeriesFunction(SetReturningFunctionTypeResolver setReturningFunctionTypeResolver, BasicType<java.time.Duration> durationType, boolean coerceToTimestamp, int maxSeriesSize) {
        super(setReturningFunctionTypeResolver, durationType, coerceToTimestamp);
        this.maxSeriesSize = maxSeriesSize;
    }

    @Override
    protected abstract void renderGenerateSeries(SqlAppender var1, Expression var2, Expression var3, @Nullable Expression var4, AnonymousTupleTableGroupProducer var5, String var6, SqlAstTranslator<?> var7);

    protected static boolean needsVariable(Expression expression) {
        return !(expression instanceof Literal) && !(expression instanceof ColumnReference);
    }

    public static Expression add(Expression left, Expression right, SqmToSqlAstConverter converter) {
        if (right instanceof Duration) {
            Duration duration = (Duration)right;
            BasicType nodeType = (BasicType)left.getExpressionType().getSingleJdbcMapping();
            FunctionRenderer timestampadd = (FunctionRenderer)((Object)converter.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd"));
            return new SelfRenderingFunctionSqlAstExpression("timestampadd", timestampadd, List.of(new DurationUnit(duration.getUnit(), duration.getExpressionType()), duration.getMagnitude(), left), nodeType, nodeType);
        }
        return new BinaryArithmeticExpression(left, BinaryArithmeticOperator.ADD, right, (BasicValuedMapping)left.getExpressionType());
    }

    public static Expression multiply(Expression left, int multiplier, BasicType<Integer> integerType) {
        return NumberSeriesGenerateSeriesFunction.multiply(left, new UnparsedNumericLiteral(Integer.toString(multiplier), NumericTypeCategory.INTEGER, integerType));
    }

    public static Expression multiply(Expression left, Expression multiplier) {
        if (left instanceof Duration) {
            Duration duration = (Duration)left;
            return new Duration(NumberSeriesGenerateSeriesFunction.multiply(duration.getMagnitude(), multiplier), duration.getUnit(), duration.getExpressionType());
        }
        return new BinaryArithmeticExpression(left, BinaryArithmeticOperator.MULTIPLY, multiplier, (BasicValuedMapping)left.getExpressionType());
    }

    static Expression castToTimestamp(SqlAstNode node, SqmToSqlAstConverter converter) {
        BasicType nodeType = (BasicType)((Expression)node).getExpressionType().getSingleJdbcMapping();
        FunctionRenderer cast = (FunctionRenderer)((Object)converter.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("cast"));
        BasicType<Timestamp> timestampType = converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Timestamp.class);
        return new SelfRenderingFunctionSqlAstExpression("cast", cast, List.of(node, new CastTarget(timestampType)), nodeType, nodeType);
    }

    protected static class NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver
    extends GenerateSeriesSetReturningFunctionTypeResolver {
        public NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver(@Nullable String defaultValueColumnName, String defaultIndexSelectionExpression) {
            super(defaultValueColumnName, defaultIndexSelectionExpression);
        }

        protected SelectableMapping[] resolveIterationVariableBasedFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            SelectableMappingImpl elementMapping;
            String elementSelectionExpression;
            Object customReadExpression;
            Expression start = (Expression)arguments.get(0);
            Expression stop = (Expression)arguments.get(0);
            JdbcMappingContainer expressionType = NullnessHelper.coalesce(start.getExpressionType(), stop.getExpressionType());
            Expression explicitStep = arguments.size() > 2 ? (Expression)arguments.get(2) : null;
            JdbcMapping type = expressionType.getSingleJdbcMapping();
            if (type == null) {
                throw new IllegalArgumentException("Couldn't determine types of arguments to function 'generate_series'");
            }
            SelectableMappingImpl indexMapping = withOrdinality ? new SelectableMappingImpl("", this.defaultIndexSelectionExpression, new SelectablePath(CollectionPart.Nature.INDEX.getName()), null, null, null, null, null, null, null, false, false, false, false, false, false, converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class)) : null;
            String startExpression = this.getStartExpression(start, tableIdentifierVariable, converter);
            String stepExpression = this.getStepExpression(explicitStep, tableIdentifierVariable, converter);
            if (type.getJdbcType().isTemporal()) {
                Duration step = (Duration)explicitStep;
                customReadExpression = NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver.timestampadd(startExpression, stepExpression, type, step, converter);
            } else {
                customReadExpression = startExpression + "+" + stepExpression;
            }
            String string = elementSelectionExpression = this.defaultValueColumnName == null ? tableIdentifierVariable : this.defaultValueColumnName;
            if (expressionType instanceof SqlTypedMapping) {
                SqlTypedMapping typedMapping = (SqlTypedMapping)((Object)expressionType);
                elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), (String)customReadExpression, null, typedMapping.getColumnDefinition(), typedMapping.getLength(), typedMapping.getPrecision(), typedMapping.getScale(), typedMapping.getTemporalPrecision(), typedMapping.isLob(), true, false, false, false, false, type);
            } else {
                elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), (String)customReadExpression, null, null, null, null, null, null, false, true, false, false, false, false, type);
            }
            SelectableMapping[] returnType = indexMapping == null ? new SelectableMapping[]{elementMapping} : new SelectableMapping[]{elementMapping, indexMapping};
            return returnType;
        }

        private static String timestampadd(String startExpression, String stepExpression, JdbcMapping type, Duration duration, SqmToSqlAstConverter converter) {
            FunctionRenderer renderer = (FunctionRenderer)((Object)converter.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd"));
            QuerySpec fakeQuery = new QuerySpec(true);
            fakeQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(new SelfRenderingFunctionSqlAstExpression("timestampadd", renderer, List.of(new DurationUnit(duration.getUnit(), duration.getExpressionType()), new SelfRenderingSqlFragmentExpression(stepExpression, duration.getExpressionType()), new SelfRenderingSqlFragmentExpression(startExpression, type)), (ReturnableType)((Object)type), type)));
            SqlAstTranslator<JdbcOperationQuerySelect> translator = converter.getCreationContext().getSessionFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildSelectTranslator(converter.getCreationContext().getSessionFactory(), new SelectStatement(fakeQuery));
            JdbcOperationQuerySelect operation = translator.translate(null, QueryOptions.NONE);
            String sqlString = operation.getSqlString();
            assert (sqlString.startsWith("select "));
            int startIndex = "select ".length();
            int fromIndex = sqlString.lastIndexOf(" from");
            return fromIndex == -1 ? sqlString.substring(startIndex) : sqlString.substring(startIndex, fromIndex);
        }

        private String getStartExpression(Expression expression, String tableIdentifierVariable, SqmToSqlAstConverter walker) {
            return this.getExpression(expression, tableIdentifierVariable, "b", walker);
        }

        private String getStepExpression(@Nullable Expression explicitStep, String tableIdentifierVariable, SqmToSqlAstConverter walker) {
            if (explicitStep == null) {
                return "({@}." + this.defaultIndexSelectionExpression + "-1)";
            }
            return "(" + this.getExpression(explicitStep, tableIdentifierVariable, "s", walker) + "*({@}." + this.defaultIndexSelectionExpression + "-1))";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getExpression(Expression expression, String tableIdentifierVariable, String syntheticColumnName, SqmToSqlAstConverter walker) {
            if (expression instanceof Literal) {
                Literal literal = (Literal)expression;
                SessionFactoryImplementor sessionFactory = walker.getCreationContext().getSessionFactory();
                LazySessionWrapperOptions wrapperOptions = new LazySessionWrapperOptions(sessionFactory);
                try {
                    String string = literal.getJdbcMapping().getJdbcLiteralFormatter().toJdbcLiteral(literal.getLiteralValue(), sessionFactory.getJdbcServices().getDialect(), wrapperOptions);
                    return string;
                }
                finally {
                    wrapperOptions.cleanup();
                }
            }
            if (expression instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)expression;
                return columnReference.getExpressionText();
            }
            return tableIdentifierVariable + "_." + syntheticColumnName;
        }
    }

    protected static class NumberSeriesQueryTransformer
    implements QueryTransformer {
        protected final FunctionTableGroup functionTableGroup;
        protected final TableGroup targetTableGroup;
        protected final String positionColumnName;
        protected final boolean coerceToTimestamp;

        public NumberSeriesQueryTransformer(FunctionTableGroup functionTableGroup, TableGroup targetTableGroup, String positionColumnName, boolean coerceToTimestamp) {
            this.functionTableGroup = functionTableGroup;
            this.targetTableGroup = targetTableGroup;
            this.positionColumnName = positionColumnName;
            this.coerceToTimestamp = coerceToTimestamp;
        }

        @Override
        public QuerySpec transform(CteContainer cteContainer, QuerySpec querySpec, SqmToSqlAstConverter converter) {
            List<? extends SqlAstNode> arguments = this.functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
            JdbcType boundType = ((Expression)arguments.get(0)).getExpressionType().getSingleJdbcMapping().getJdbcType();
            boolean castTimestamp = this.coerceToTimestamp && (boundType.getDdlTypeCode() == 91 || boundType.getDdlTypeCode() == 92);
            Expression start = castTimestamp ? NumberSeriesGenerateSeriesFunction.castToTimestamp(arguments.get(0), converter) : (Expression)arguments.get(0);
            Expression stop = castTimestamp ? NumberSeriesGenerateSeriesFunction.castToTimestamp(arguments.get(1), converter) : (Expression)arguments.get(1);
            Expression explicitStep = arguments.size() > 2 ? (Expression)arguments.get(2) : null;
            TableGroup parentTableGroup = querySpec.getFromClause().queryTableGroups(tg -> tg.findTableGroupJoin(this.targetTableGroup) == null ? null : tg);
            PredicateContainer predicateContainer = parentTableGroup != null ? parentTableGroup.findTableGroupJoin(this.targetTableGroup) : querySpec;
            BasicType<Integer> integerType = converter.getCreationContext().getSessionFactory().getNodeBuilder().getIntegerType();
            ColumnReference oneBasedOrdinal = new ColumnReference(this.functionTableGroup.getPrimaryTableReference().getIdentificationVariable(), this.positionColumnName, false, null, integerType);
            QueryLiteral<Integer> one = new QueryLiteral<Integer>(1, integerType);
            BinaryArithmeticExpression zeroBasedOrdinal = new BinaryArithmeticExpression(oneBasedOrdinal, BinaryArithmeticOperator.SUBTRACT, one, integerType);
            BinaryArithmeticExpression stepExpression = explicitStep != null ? NumberSeriesGenerateSeriesFunction.multiply(explicitStep, zeroBasedOrdinal) : zeroBasedOrdinal;
            Expression nextValue = NumberSeriesGenerateSeriesFunction.add(start, stepExpression, converter);
            if (explicitStep == null) {
                predicateContainer.applyPredicate(new ComparisonPredicate(nextValue, ComparisonOperator.LESS_THAN_OR_EQUAL, stop));
            } else {
                BasicType<Boolean> booleanType = converter.getCreationContext().getSessionFactory().getNodeBuilder().getBooleanType();
                Junction positiveProgress = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.LESS_THAN, stop), new ComparisonPredicate(explicitStep, ComparisonOperator.GREATER_THAN, NumberSeriesGenerateSeriesFunction.multiply(explicitStep, -1, integerType)), new ComparisonPredicate(nextValue, ComparisonOperator.LESS_THAN_OR_EQUAL, stop)), booleanType);
                Junction negativeProgress = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.GREATER_THAN, stop), new ComparisonPredicate(explicitStep, ComparisonOperator.LESS_THAN, NumberSeriesGenerateSeriesFunction.multiply(explicitStep, -1, integerType)), new ComparisonPredicate(nextValue, ComparisonOperator.GREATER_THAN_OR_EQUAL, stop)), booleanType);
                Junction initialValue = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.EQUAL, stop), new ComparisonPredicate(oneBasedOrdinal, ComparisonOperator.EQUAL, one)), booleanType);
                predicateContainer.applyPredicate(new Junction(Junction.Nature.DISJUNCTION, List.of(positiveProgress, negativeProgress, initialValue), booleanType));
            }
            return querySpec;
        }
    }
}

