/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class GenerateSeriesSetReturningFunctionTypeResolver
implements SetReturningFunctionTypeResolver {
    protected final @Nullable String defaultValueColumnName;
    protected final String defaultIndexSelectionExpression;

    public GenerateSeriesSetReturningFunctionTypeResolver(@Nullable String defaultValueColumnName, String defaultIndexSelectionExpression) {
        this.defaultValueColumnName = defaultValueColumnName;
        this.defaultIndexSelectionExpression = defaultIndexSelectionExpression;
    }

    @Override
    public AnonymousTupleType<?> resolveTupleType(List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
        SqmTypedNode<?> start = arguments.get(0);
        SqmTypedNode<?> stop = arguments.get(1);
        SqmExpressible<?> startExpressible = start.getExpressible();
        SqmExpressible<?> stopExpressible = stop.getExpressible();
        DomainType type = NullnessHelper.coalesce(startExpressible == null ? null : startExpressible.getSqmType(), stopExpressible == null ? null : stopExpressible.getSqmType());
        if (type == null) {
            throw new IllegalArgumentException("Couldn't determine types of arguments to function 'generate_series'");
        }
        SqmExpressible[] componentTypes = new SqmExpressible[]{type, typeConfiguration.getBasicTypeForJavaType(Long.class)};
        String[] componentNames = new String[]{CollectionPart.Nature.ELEMENT.getName(), CollectionPart.Nature.INDEX.getName()};
        return new AnonymousTupleType(componentTypes, componentNames);
    }

    @Override
    public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
        SelectableMappingImpl elementMapping;
        String elementSelectionExpression;
        Expression start = (Expression)arguments.get(0);
        Expression stop = (Expression)arguments.get(0);
        JdbcMappingContainer expressionType = NullnessHelper.coalesce(start.getExpressionType(), stop.getExpressionType());
        JdbcMapping type = expressionType.getSingleJdbcMapping();
        if (type == null) {
            throw new IllegalArgumentException("Couldn't determine types of arguments to function 'generate_series'");
        }
        SelectableMappingImpl indexMapping = withOrdinality ? new SelectableMappingImpl("", this.defaultIndexSelectionExpression, new SelectablePath(CollectionPart.Nature.INDEX.getName()), null, null, null, null, null, null, null, false, false, false, false, false, false, converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class)) : null;
        String string = elementSelectionExpression = this.defaultValueColumnName == null ? tableIdentifierVariable : this.defaultValueColumnName;
        if (expressionType instanceof SqlTypedMapping) {
            SqlTypedMapping typedMapping = (SqlTypedMapping)((Object)expressionType);
            elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), null, null, typedMapping.getColumnDefinition(), typedMapping.getLength(), typedMapping.getPrecision(), typedMapping.getScale(), typedMapping.getTemporalPrecision(), typedMapping.isLob(), true, false, false, false, false, type);
        } else {
            elementMapping = new SelectableMappingImpl("", elementSelectionExpression, new SelectablePath(CollectionPart.Nature.ELEMENT.getName()), null, null, null, null, null, null, null, false, true, false, false, false, false, type);
        }
        SelectableMapping[] returnType = indexMapping == null ? new SelectableMapping[]{elementMapping} : new SelectableMapping[]{elementMapping, indexMapping};
        return returnType;
    }
}

