/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.time.Duration;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.produce.function.internal.AbstractFunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.BasicType;

public class GenerateSeriesArgumentTypeResolver
extends AbstractFunctionArgumentTypeResolver {
    private final BasicType<Duration> durationType;

    public GenerateSeriesArgumentTypeResolver(BasicType<Duration> durationType) {
        this.durationType = durationType;
    }

    @Override
    public @Nullable MappingModelExpressible<?> resolveFunctionArgumentType(List<? extends SqmTypedNode<?>> arguments, int argumentIndex, SqmToSqlAstConverter converter) {
        MappingModelExpressible<?> firstType;
        if (argumentIndex == 0) {
            MappingModelExpressible<?> mappingModelExpressible = converter.resolveFunctionImpliedReturnType();
            return mappingModelExpressible != null ? mappingModelExpressible : converter.determineValueMapping((SqmExpression)arguments.get(1));
        }
        if (argumentIndex == 1) {
            MappingModelExpressible<?> mappingModelExpressible = converter.resolveFunctionImpliedReturnType();
            return mappingModelExpressible != null ? mappingModelExpressible : converter.determineValueMapping((SqmExpression)arguments.get(0));
        }
        assert (argumentIndex == 2);
        MappingModelExpressible<?> implied = converter.resolveFunctionImpliedReturnType();
        MappingModelExpressible<?> resultType = implied != null ? implied : ((firstType = converter.determineValueMapping((SqmExpression)arguments.get(0))) != null ? firstType : converter.determineValueMapping((SqmExpression)arguments.get(1)));
        assert (resultType != null);
        if (resultType.getSingleJdbcMapping().getJdbcType().isTemporal()) {
            return this.durationType;
        }
        return resultType;
    }
}

