/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class DateTruncEmulation
extends AbstractSqmFunctionDescriptor
implements FunctionRenderer {
    protected final String toDateFunction;
    private final SqmFormat sqmFormat;

    protected DateTruncEmulation(String toDateFunction, TypeConfiguration typeConfiguration) {
        super("trunc", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL_UNIT), StandardFunctionReturnTypeResolvers.useArgType(1), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL_UNIT));
        this.toDateFunction = toDateFunction;
        this.sqmFormat = new SqmFormat("yyyy-MM-dd HH:mm:ss", (SqmExpressible<String>)typeConfiguration.getBasicTypeForJavaType(String.class), null);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(this.toDateFunction);
        sqlAppender.append('(');
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append(',');
        sqlAstArguments.get(2).accept(walker);
        sqlAppender.append(')');
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        String pattern;
        NodeBuilder nodeBuilder = queryEngine.getCriteriaBuilder();
        TemporalUnit temporalUnit = ((SqmExtractUnit)arguments.get(1)).getUnit();
        String literal = switch (temporalUnit) {
            case TemporalUnit.YEAR -> {
                pattern = "yyyy";
                yield "-01-01 00:00:00";
            }
            case TemporalUnit.MONTH -> {
                pattern = "yyyy-MM";
                yield "-01 00:00:00";
            }
            case TemporalUnit.DAY -> {
                pattern = "yyyy-MM-dd";
                yield " 00:00:00";
            }
            case TemporalUnit.HOUR -> {
                pattern = "yyyy-MM-dd HH";
                yield ":00:00";
            }
            case TemporalUnit.MINUTE -> {
                pattern = "yyyy-MM-dd HH:mm";
                yield ":00";
            }
            case TemporalUnit.SECOND -> {
                pattern = "yyyy-MM-dd HH:mm:ss";
                yield null;
            }
            default -> throw new UnsupportedOperationException("Temporal unit not supported [" + temporalUnit + "]");
        };
        SqmTypedNode<?> datetime = arguments.get(0);
        SelfRenderingSqmFunction formatExpression = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("format").generateSqmExpression(Arrays.asList(datetime, new SqmFormat(pattern, (SqmExpressible<String>)nodeBuilder.getTypeConfiguration().getBasicTypeForJavaType(String.class), nodeBuilder)), null, queryEngine);
        SelfRenderingSqmFunction formattedDatetime = literal != null ? queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("concat").generateSqmExpression(Arrays.asList(formatExpression, new SqmLiteral<String>(literal, nodeBuilder.getTypeConfiguration().getBasicTypeForJavaType(String.class), nodeBuilder)), null, queryEngine) : formatExpression;
        return new SelfRenderingSqmFunction<T>(this, this, Arrays.asList(datetime, formattedDatetime, this.sqmFormat), impliedResultType, null, this.getReturnTypeResolver(), nodeBuilder, this.getName());
    }
}

