/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.time.Duration;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.NumberSeriesGenerateSeriesFunction;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.NumericTypeCategory;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.UnparsedNumericLiteral;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class CteGenerateSeriesFunction
extends NumberSeriesGenerateSeriesFunction {
    public CteGenerateSeriesFunction(int maxSeriesSize, boolean supportsIntervals, boolean coerceToTimestamp, TypeConfiguration typeConfiguration) {
        super(new CteGenerateSeriesSetReturningFunctionTypeResolver(), typeConfiguration.getBasicTypeRegistry().resolve(Duration.class, supportsIntervals ? 3100 : 3015), coerceToTimestamp, maxSeriesSize);
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup tableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                AnonymousTupleTableGroupProducer tableGroupProducer = (AnonymousTupleTableGroupProducer)tableGroup.getModelPart();
                if (!lateral) {
                    return new QueryPartTableGroup(navigablePath, tableGroupProducer, CteGenerateSeriesFunction.this.createCteSubquery(tableGroup, walker), identifierVariable, tableGroupProducer.getColumnNames(), tableGroup.getPrimaryTableReference().getCompatibleTableExpressions(), lateral, canUseInnerJoins, walker.getCreationContext().getSessionFactory());
                }
                CteTableGroup cteTableGroup = new CteTableGroup(canUseInnerJoins, navigablePath, null, tableGroupProducer, new NamedTableReference("max_series", identifierVariable), tableGroupProducer.getCompatibleTableExpressions());
                walker.registerQueryTransformer(new CteGenerateSeriesQueryTransformer(tableGroup, cteTableGroup, CteGenerateSeriesFunction.this.maxSeriesSize, "i", CteGenerateSeriesFunction.this.coerceToTimestamp));
                return cteTableGroup;
            }
        };
    }

    private SelectStatement createCteSubquery(FunctionTableGroup tableGroup, SqmToSqlAstConverter walker) {
        AnonymousTupleTableGroupProducer tableGroupProducer = (AnonymousTupleTableGroupProducer)tableGroup.getModelPart();
        ModelPart indexPart = tableGroupProducer.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        ModelPart elementPart = tableGroupProducer.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null);
        NumericTypeCategory numericTypeCategory = NumericTypeCategory.BIG_DECIMAL;
        BasicType resultType = (BasicType)elementPart.getSingleJdbcMapping();
        BasicType<Integer> integerType = walker.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        BasicType<Boolean> booleanType = walker.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Boolean.class);
        JdbcType boundType = resultType.getJdbcType();
        boolean castTimestamp = this.coerceToTimestamp && (boundType.getDdlTypeCode() == 91 || boundType.getDdlTypeCode() == 92);
        List<? extends SqlAstNode> arguments = tableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
        Expression start = castTimestamp ? CteGenerateSeriesFunction.castToTimestamp(arguments.get(0), walker) : (Expression)arguments.get(0);
        Expression stop = castTimestamp ? CteGenerateSeriesFunction.castToTimestamp(arguments.get(1), walker) : (Expression)arguments.get(1);
        Expression explicitStep = arguments.size() > 2 ? (Expression)arguments.get(2) : null;
        Expression step = explicitStep != null ? explicitStep : new UnparsedNumericLiteral("1", numericTypeCategory, resultType);
        String cteName = "generate_series";
        List<CteColumn> cteColumns = indexPart == null ? List.of(new CteColumn("v", resultType)) : List.of(new CteColumn("v", resultType), new CteColumn("i", indexPart.getSingleJdbcMapping()));
        QuerySpec cteStart = new QuerySpec(false);
        if (explicitStep == null) {
            cteStart.getSelectClause().addSqlSelection(new SqlSelectionImpl(start));
        } else {
            cteStart.getSelectClause().addSqlSelection(new SqlSelectionImpl(CteGenerateSeriesFunction.add(start, CteGenerateSeriesFunction.multiply(step, 0, integerType), walker)));
        }
        if (indexPart != null) {
            cteStart.getSelectClause().addSqlSelection(new SqlSelectionImpl(new UnparsedNumericLiteral("1", NumericTypeCategory.INTEGER, integerType)));
        }
        if (explicitStep == null) {
            cteStart.applyPredicate(new ComparisonPredicate(start, ComparisonOperator.LESS_THAN_OR_EQUAL, stop));
        } else {
            Junction positiveProgress = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.LESS_THAN_OR_EQUAL, stop), new ComparisonPredicate(step, ComparisonOperator.GREATER_THAN, CteGenerateSeriesFunction.multiply(step, -1, integerType))), booleanType);
            Junction negativeProgress = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.GREATER_THAN_OR_EQUAL, stop), new ComparisonPredicate(step, ComparisonOperator.LESS_THAN, CteGenerateSeriesFunction.multiply(step, -1, integerType))), booleanType);
            cteStart.applyPredicate(new Junction(Junction.Nature.DISJUNCTION, List.of(positiveProgress, negativeProgress), booleanType));
        }
        QuerySpec cteUnion = new QuerySpec(false);
        CteTableGroup cteTableGroup = new CteTableGroup(new NamedTableReference("generate_series", "t"));
        cteUnion.getFromClause().addRoot(cteTableGroup);
        ColumnReference tValue = new ColumnReference(cteTableGroup.getPrimaryTableReference(), "v", (JdbcMapping)resultType);
        ColumnReference tIndex = indexPart == null ? null : new ColumnReference(cteTableGroup.getPrimaryTableReference(), "i", indexPart.getSingleJdbcMapping());
        Expression nextValue = CteGenerateSeriesFunction.add(tValue, step, walker);
        cteUnion.getSelectClause().addSqlSelection(new SqlSelectionImpl(nextValue));
        if (tIndex != null) {
            cteUnion.getSelectClause().addSqlSelection(new SqlSelectionImpl(new BinaryArithmeticExpression(tIndex, BinaryArithmeticOperator.ADD, new UnparsedNumericLiteral("1", NumericTypeCategory.INTEGER, integerType), (BasicValuedMapping)((Object)indexPart.getSingleJdbcMapping()))));
        }
        if (explicitStep == null) {
            cteUnion.applyPredicate(new ComparisonPredicate(nextValue, ComparisonOperator.LESS_THAN_OR_EQUAL, stop));
        } else {
            Junction positiveProgress = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.LESS_THAN, stop), new ComparisonPredicate(nextValue, ComparisonOperator.LESS_THAN_OR_EQUAL, stop)), booleanType);
            Junction negativeProgress = new Junction(Junction.Nature.CONJUNCTION, List.of(new ComparisonPredicate(start, ComparisonOperator.GREATER_THAN, stop), new ComparisonPredicate(nextValue, ComparisonOperator.GREATER_THAN_OR_EQUAL, stop)), booleanType);
            cteUnion.applyPredicate(new Junction(Junction.Nature.DISJUNCTION, List.of(positiveProgress, negativeProgress), booleanType));
        }
        QueryGroup cteContent = new QueryGroup(false, SetOperator.UNION_ALL, List.of(cteStart, cteUnion));
        QuerySpec mainQuery = new QuerySpec(false);
        SelectStatement selectStatement = new SelectStatement(mainQuery);
        CteStatement cteStatement = new CteStatement(new CteTable("generate_series", cteColumns), new SelectStatement(cteContent));
        cteStatement.setRecursive();
        selectStatement.addCteStatement(cteStatement);
        mainQuery.getFromClause().addRoot(cteTableGroup);
        mainQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(tValue));
        if (indexPart != null) {
            mainQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(tIndex));
        }
        return selectStatement;
    }

    @Override
    protected void renderGenerateSeries(SqlAppender sqlAppender, Expression start, Expression stop, @Nullable Expression step, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        throw new UnsupportedOperationException("Function expands to custom SQL AST");
    }

    static class CteGenerateSeriesSetReturningFunctionTypeResolver
    extends NumberSeriesGenerateSeriesFunction.NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver {
        public CteGenerateSeriesSetReturningFunctionTypeResolver() {
            super("v", "i");
        }

        public CteGenerateSeriesSetReturningFunctionTypeResolver(@Nullable String defaultValueColumnName, String defaultIndexSelectionExpression) {
            super(defaultValueColumnName, defaultIndexSelectionExpression);
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            if (!lateral) {
                return super.resolveFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
            }
            return this.resolveIterationVariableBasedFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
        }
    }

    public static class CteGenerateSeriesQueryTransformer
    extends NumberSeriesGenerateSeriesFunction.NumberSeriesQueryTransformer {
        public static final String NAME = "max_series";
        protected final int maxSeriesSize;

        public CteGenerateSeriesQueryTransformer(FunctionTableGroup functionTableGroup, TableGroup targetTableGroup, int maxSeriesSize, String positionColumnName, boolean coerceToTimestamp) {
            super(functionTableGroup, targetTableGroup, positionColumnName, coerceToTimestamp);
            this.maxSeriesSize = maxSeriesSize;
        }

        @Override
        public QuerySpec transform(CteContainer cteContainer, QuerySpec querySpec, SqmToSqlAstConverter converter) {
            if (cteContainer.getCteStatement(NAME) == null) {
                cteContainer.addCteStatement(this.createSeriesCte(converter));
            }
            return super.transform(cteContainer, querySpec, converter);
        }

        protected CteStatement createSeriesCte(SqmToSqlAstConverter converter) {
            return CteGenerateSeriesQueryTransformer.createSeriesCte(this.maxSeriesSize, converter);
        }

        public static CteStatement createSeriesCte(int maxSeriesSize, SqmToSqlAstConverter converter) {
            BasicType<Long> longType = converter.getCreationContext().getTypeConfiguration().getBasicTypeForJavaType(Long.class);
            UnparsedNumericLiteral one = new UnparsedNumericLiteral("1", NumericTypeCategory.LONG, longType);
            List<CteColumn> cteColumns = List.of(new CteColumn("i", longType));
            QuerySpec cteStart = new QuerySpec(false);
            cteStart.getSelectClause().addSqlSelection(new SqlSelectionImpl(one));
            QuerySpec cteUnion = new QuerySpec(false);
            CteTableGroup cteTableGroup = new CteTableGroup(new NamedTableReference(NAME, "t"));
            cteUnion.getFromClause().addRoot(cteTableGroup);
            ColumnReference tIndex = new ColumnReference(cteTableGroup.getPrimaryTableReference(), "i", longType);
            BinaryArithmeticExpression nextValue = new BinaryArithmeticExpression(tIndex, BinaryArithmeticOperator.ADD, one, longType);
            cteUnion.getSelectClause().addSqlSelection(new SqlSelectionImpl(nextValue));
            cteUnion.applyPredicate(new ComparisonPredicate(nextValue, ComparisonOperator.LESS_THAN_OR_EQUAL, new UnparsedNumericLiteral(Integer.toString(maxSeriesSize), NumericTypeCategory.LONG, longType)));
            QueryGroup cteContent = new QueryGroup(false, SetOperator.UNION_ALL, List.of(cteStart, cteUnion));
            CteStatement cteStatement = new CteStatement(new CteTable(NAME, cteColumns), new SelectStatement(cteContent));
            cteStatement.setRecursive();
            return cteStatement;
        }
    }
}

