/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.NamedAuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DB2StructJdbcType;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2AggregateSupport
extends AggregateSupportImpl {
    public static final AggregateSupport INSTANCE = new DB2AggregateSupport(false);
    public static final AggregateSupport JSON_INSTANCE = new DB2AggregateSupport(true);
    private final boolean jsonSupport;

    public DB2AggregateSupport(boolean jsonSupport) {
        this.jsonSupport = jsonSupport;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                if (!this.jsonSupport) break;
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 16: {
                        if (SqlTypes.isNumericType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                            return template.replace(placeholder, "decode(json_value(" + aggregateParentReadExpression + ",'$." + columnExpression + "'),'true',1,'false',0)");
                        }
                        return template.replace(placeholder, "decode(json_value(" + aggregateParentReadExpression + ",'$." + columnExpression + "'),'true',true,'false',false)");
                    }
                    case 2014: 
                    case 3003: {
                        return template.replace(placeholder, "cast(trim(trailing 'Z' from json_value(" + aggregateParentReadExpression + ",'$." + columnExpression + "' returning varchar(35))) as " + column.getColumnDefinition() + ")");
                    }
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, "hextoraw(json_value(" + aggregateParentReadExpression + ",'$." + columnExpression + "'))");
                    }
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, "json_query(" + aggregateParentReadExpression + ",'$." + columnExpression + "')");
                    }
                }
                return template.replace(placeholder, "json_value(" + aggregateParentReadExpression + ",'$." + columnExpression + "' returning " + column.getColumnDefinition() + ")");
            }
            case 2002: {
                return template.replace(placeholder, aggregateParentReadExpression + ".." + columnExpression);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "hex(" + customWriteExpression + ")";
            }
            case 2003: 
            case 3018: {
                return "(" + customWriteExpression + ") format json";
            }
            case 92: {
                return "varchar_format(timestamp('1970-01-01'," + customWriteExpression + "),'HH24:MI:SS')";
            }
            case 93: {
                return "replace(varchar_format(" + customWriteExpression + ",'YYYY-MM-DD HH24:MI:SS.FF9'),' ','T')";
            }
            case 3003: {
                return "replace(varchar_format(" + customWriteExpression + ",'YYYY-MM-DD HH24:MI:SS.FF9'),' ','T')||'Z'";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                if (!this.jsonSupport) break;
                return aggregateParentAssignmentExpression;
            }
            case 2002: {
                return aggregateParentAssignmentExpression + ".." + columnExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public String aggregateCustomWriteExpression(AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        int sqlTypeCode = aggregateColumn.getType().getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode == 2003 ? aggregateColumn.getTypeCode() : sqlTypeCode) {
            case 3001: 
            case 3018: {
                if (!this.jsonSupport) break;
                return null;
            }
            case 2002: {
                StringBuilder sb = new StringBuilder();
                DB2AggregateSupport.appendStructCustomWriteExpression(aggregateColumn, aggregatedColumns, sb);
                return sb.toString();
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumn.getTypeCode());
    }

    private static void appendStructCustomWriteExpression(ColumnTypeInformation aggregateColumnType, List<Column> aggregatedColumns, StringBuilder sb) {
        sb.append(aggregateColumnType.getTypeName()).append("()");
        for (Column udtColumn : aggregatedColumns) {
            sb.append("..").append(udtColumn.getName()).append('(');
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                DB2AggregateSupport.appendStructCustomWriteExpression(aggregateColumn, aggregateColumn.getComponent().getAggregatedColumns(), sb);
            } else {
                sb.append("cast(? as ").append(udtColumn.getSqlType()).append(')');
            }
            sb.append(')');
        }
    }

    @Override
    public int aggregateComponentSqlTypeCode(int aggregateColumnSqlTypeCode, int columnSqlTypeCode) {
        if (aggregateColumnSqlTypeCode == 2002) {
            return columnSqlTypeCode == 16 ? 5 : columnSqlTypeCode;
        }
        if (aggregateColumnSqlTypeCode == 3001) {
            return columnSqlTypeCode == 2003 ? 3018 : columnSqlTypeCode;
        }
        return columnSqlTypeCode;
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 2002 || aggregateSqlTypeCode == 3001;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                if (!this.jsonSupport) break;
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate);
            }
            case 2002: {
                return this.structAggregateColumnWriter(aggregateColumn, columnsToUpdate, typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
        return new RootJsonWriteExpression(aggregateColumn, columns);
    }

    private AggregateSupport.WriteExpressionRenderer structAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
        return new RootStructWriteExpression(aggregateColumn, columns, typeConfiguration);
    }

    private static String determineTypeName(SelectableMapping column, TypeConfiguration typeConfiguration) {
        if (column.getColumnDefinition() == null) {
            DdlType ddlType = typeConfiguration.getDdlTypeRegistry().getDescriptor(column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode());
            Size size = new Size();
            size.setLength(column.getLength());
            size.setPrecision(column.getPrecision());
            size.setScale(column.getScale());
            return ddlType.getCastTypeName(size, (SqlExpressible)((Object)column.getJdbcMapping()), typeConfiguration.getDdlTypeRegistry());
        }
        String typeName = column.getColumnDefinition();
        return typeName;
    }

    @Override
    public boolean preferSelectAggregateMapping(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode != 2002;
    }

    @Override
    public boolean preferBindAggregateMapping(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode != 2002;
    }

    @Override
    public List<AuxiliaryDatabaseObject> aggregateAuxiliaryDatabaseObjects(Namespace namespace, String aggregatePath, AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        if (aggregateColumn.getTypeCode() != 2002) {
            return Collections.emptyList();
        }
        String columnType = aggregateColumn.getTypeName();
        ArrayList<AuxiliaryDatabaseObject> list = new ArrayList<AuxiliaryDatabaseObject>(3);
        StringBuilder serializerSb = new StringBuilder();
        StringBuilder deserializerSb = new StringBuilder();
        serializerSb.append("create function ").append(columnType).append("_serializer(v ").append(columnType).append(") returns xml language sql ").append("return xmlelement(name \"").append("e").append("\"");
        DB2AggregateSupport.appendSerializer(aggregatedColumns, serializerSb, "v..");
        serializerSb.append(')');
        deserializerSb.append("create function ").append(columnType).append("_deserializer(v xml) returns ").append(columnType).append(" language sql ").append("return select ").append(columnType).append("()");
        DB2AggregateSupport.appendDeserializerConstructor(aggregatedColumns, deserializerSb, "");
        deserializerSb.append(" from xmltable('$").append("e").append("' passing v as \"").append("e").append("\" columns");
        DB2AggregateSupport.appendDeserializerColumns(aggregatedColumns, deserializerSb, ' ', "");
        deserializerSb.append(") as t");
        list.add(new NamedAuxiliaryDatabaseObject("DB2 " + columnType + " serializer", namespace, serializerSb.toString(), "drop function " + columnType + "_serializer", Set.of(DB2Dialect.class.getName())));
        list.add(new NamedAuxiliaryDatabaseObject("DB2 " + columnType + " deserializer", namespace, deserializerSb.toString(), "drop function " + columnType + "_deserializer", Set.of(DB2Dialect.class.getName())));
        list.add(new NamedAuxiliaryDatabaseObject("DB2 " + columnType + " transform", namespace, "create transform for " + columnType + " db2_program (from sql with function " + columnType + "_serializer, to sql with function " + columnType + "_deserializer)", "drop transform db2_program for " + columnType, Set.of(DB2Dialect.class.getName())));
        return list;
    }

    private static void appendSerializer(List<Column> aggregatedColumns, StringBuilder serializerSb, String prefix) {
        int sep;
        if (aggregatedColumns.size() > 1) {
            serializerSb.append(",xmlconcat");
            sep = 40;
        } else {
            sep = 44;
        }
        for (Column udtColumn : aggregatedColumns) {
            serializerSb.append((char)sep);
            serializerSb.append("xmlelement(name \"").append(udtColumn.getName()).append("\"");
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                DB2AggregateSupport.appendSerializer(aggregateColumn.getComponent().getAggregatedColumns(), serializerSb, prefix + udtColumn.getName() + "..");
            } else if (DB2AggregateSupport.needsVarcharForBitDataCast(udtColumn.getSqlType())) {
                serializerSb.append(",cast(").append(prefix).append(udtColumn.getName()).append(" as varchar(").append(udtColumn.getColumnSize(null, null).getLength()).append(") for bit data)");
            } else {
                serializerSb.append(',').append(prefix).append(udtColumn.getName());
            }
            serializerSb.append(')');
            sep = 44;
        }
        if (aggregatedColumns.size() > 1) {
            serializerSb.append(')');
        }
    }

    private static void appendDeserializerConstructor(List<Column> aggregatedColumns, StringBuilder deserializerSb, String prefix) {
        for (Column udtColumn : aggregatedColumns) {
            deserializerSb.append("..").append(udtColumn.getName()).append('(');
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                deserializerSb.append(udtColumn.getSqlType()).append("()");
                DB2AggregateSupport.appendDeserializerConstructor(aggregateColumn.getComponent().getAggregatedColumns(), deserializerSb, udtColumn.getName() + "_");
                deserializerSb.append(')');
                continue;
            }
            if (DB2AggregateSupport.needsVarcharForBitDataCast(udtColumn.getSqlType())) {
                deserializerSb.append("cast(t.").append(prefix).append(udtColumn.getName()).append(" as ").append(udtColumn.getSqlType()).append("))");
                continue;
            }
            deserializerSb.append("t.").append(prefix).append(udtColumn.getName()).append(')');
        }
    }

    private static void appendDeserializerColumns(List<Column> aggregatedColumns, StringBuilder deserializerSb, char sep, String prefix) {
        for (Column udtColumn : aggregatedColumns) {
            if (udtColumn.getSqlTypeCode() == 2002) {
                AggregateColumn aggregateColumn = (AggregateColumn)udtColumn;
                DB2AggregateSupport.appendDeserializerColumns(aggregateColumn.getComponent().getAggregatedColumns(), deserializerSb, sep, udtColumn.getName() + "_");
            } else {
                deserializerSb.append(sep);
                deserializerSb.append(prefix).append(udtColumn.getName()).append(' ');
                if (DB2AggregateSupport.needsVarcharForBitDataCast(udtColumn.getSqlType())) {
                    deserializerSb.append("varchar(").append(udtColumn.getColumnSize(null, null).getLength()).append(") for bit data");
                } else {
                    deserializerSb.append(udtColumn.getSqlType());
                }
                deserializerSb.append(" path '/").append("e").append('/').append(udtColumn.getName()).append('\'');
            }
            sep = (char)44;
        }
    }

    private static boolean needsVarcharForBitDataCast(String columnType) {
        String columTypeLC = columnType.toLowerCase(Locale.ROOT).trim();
        return columTypeLC.contains("binary") || columTypeLC.startsWith("char") && columTypeLC.endsWith(" bit data");
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class RootStructWriteExpression
    extends AggregateStructWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String selectableName;

        RootStructWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
            super(aggregateColumn);
            this.selectableName = aggregateColumn.getSelectableName();
            this.initializeSubExpressions(columns, typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object path = qualifier == null || qualifier.isBlank() ? this.selectableName : qualifier + "." + this.selectableName;
            this.append(sqlAppender, (String)path, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("' value ");
            sb.append(path);
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("' value ");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression() {
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression());
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, DB2AggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                JsonWriteExpression jsonWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (jsonWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughExpression(selectableMapping));
                    continue;
                }
                if (!(jsonWriteExpression instanceof AggregateJsonWriteExpression)) continue;
                AggregateJsonWriteExpression writeExpression = (AggregateJsonWriteExpression)jsonWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("json_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = "json_query(" + path + ",'$." + column + "') format json";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    sb.append("' value coalesce(");
                    value.append(sb, subPath, translator, expression);
                    sb.append(",json_object())");
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }

    private static class BasicStructWriteExpression
    implements AggregateWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String typeName;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicStructWriteExpression(SelectableMapping selectableMapping, String typeName, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            this.typeName = typeName;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("cast(");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.DEFAULT);
            sb.append(this.customWriteExpressionEnd);
            sb.append(" as ");
            sb.append(this.typeName);
            sb.append(')');
        }
    }

    private static class AggregateStructWriteExpression
    implements AggregateWriteExpression {
        private final LinkedHashMap<String, AggregateWriteExpression> subExpressions = new LinkedHashMap();
        protected final EmbeddableMappingType embeddableMappingType;
        protected final String structTypeName;
        protected final boolean nullable;

        public AggregateStructWriteExpression(SelectableMapping selectableMapping) {
            DB2StructJdbcType structJdbcType = (DB2StructJdbcType)selectableMapping.getJdbcMapping().getJdbcType();
            this.embeddableMappingType = structJdbcType.getEmbeddableMappingType();
            this.structTypeName = structJdbcType.getStructTypeName();
            this.nullable = selectableMapping.isNullable();
        }

        protected void initializeSubExpressions(SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                String typeName = DB2AggregateSupport.determineTypeName(column, typeConfiguration);
                AggregateStructWriteExpression currentAggregate = this;
                EmbeddableMappingType currentMappingType = this.embeddableMappingType;
                for (int i = 1; i < parts.length - 1; ++i) {
                    SelectableMapping selectableMapping = currentMappingType.getJdbcValueSelectable(currentMappingType.getSelectableIndex(parts[i].getSelectableName()));
                    currentAggregate = (AggregateStructWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateStructWriteExpression(selectableMapping));
                    currentMappingType = currentAggregate.embeddableMappingType;
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicStructWriteExpression(column, typeName, customWriteExpression));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            if (this.nullable) {
                sb.append("coalesce(");
                sb.append(path);
                sb.append(",");
                sb.append(this.structTypeName);
                sb.append("())");
            } else {
                sb.append(path);
            }
            for (Map.Entry<String, AggregateWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                AggregateWriteExpression value = entry.getValue();
                sb.append("..");
                sb.append(column);
                sb.append('(');
                value.append(sb, path + ".." + column, translator, expression);
                sb.append(')');
            }
        }
    }

    static interface AggregateWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

