/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.SpannerDialectTableExporter;
import org.hibernate.dialect.SpannerSqlAstTranslator;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class SpannerDialect
extends Dialect {
    private final Exporter<Table> spannerTableExporter = new SpannerDialectTableExporter(this);
    private static final LockingStrategy LOCKING_STRATEGY = new DoNothingLockingStrategy();
    private static final EmptyExporter NOOP_EXPORTER = new EmptyExporter();
    private static final UniqueDelegate NOOP_UNIQUE_DELEGATE = new DoNothingUniqueDelegate();

    public SpannerDialect() {
        super(SimpleDatabaseVersion.ZERO_VERSION);
    }

    public SpannerDialect(DialectResolutionInfo info) {
        super(info);
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "bool";
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "int64";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "float64";
            }
            case 92: 
            case 93: 
            case 2014: {
                return "timestamp";
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return "string($l)";
            }
            case -3: 
            case -2: {
                return "bytes($l)";
            }
            case 2005: 
            case 2011: {
                return "string(max)";
            }
            case 2004: {
                return "bytes(max)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "string";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytes";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    public int getMaxVarcharLength() {
        return 0x280000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return 0xA00000;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public String getArrayTypeName(String javaElementTypeName, String elementTypeName, Integer maxLength) {
        return "ARRAY<" + elementTypeName + ">";
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<byte[]> byteArrayType = basicTypeRegistry.resolve(StandardBasicTypes.BINARY);
        BasicType<Long> longType = basicTypeRegistry.resolve(StandardBasicTypes.LONG);
        BasicType<Boolean> booleanType = basicTypeRegistry.resolve(StandardBasicTypes.BOOLEAN);
        BasicType<String> stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        BasicType<Date> dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType<Date> timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        functionContributions.getFunctionRegistry().namedAggregateDescriptorBuilder("any_value").setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedAggregateDescriptorBuilder("array_agg").setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedAggregateDescriptorBuilder("countif").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedAggregateDescriptorBuilder("logical_and").setInvariantType(booleanType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedAggregateDescriptorBuilder("logical_or").setInvariantType(booleanType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedAggregateDescriptorBuilder("string_agg").setInvariantType(stringType).setArgumentCountBetween(1, 2).register();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.log();
        functionFactory.log10();
        functionFactory.trunc();
        functionFactory.ceiling_ceil();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.moreHyperbolic();
        functionFactory.bitandorxornot_bitAndOrXorNot();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("is_inf").setInvariantType(booleanType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("is_nan").setInvariantType(booleanType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("ieee_divide").setInvariantType(booleanType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("div").setInvariantType(longType).setExactArgumentCount(2).register();
        functionFactory.sha1();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("farm_fingerprint").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("sha256").setInvariantType(byteArrayType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("sha512").setInvariantType(byteArrayType).setExactArgumentCount(1).register();
        functionFactory.concat_pipeOperator();
        functionFactory.trim2();
        functionFactory.reverse();
        functionFactory.repeat();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("byte_length").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("code_points_to_bytes").setInvariantType(byteArrayType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("code_points_to_string").setInvariantType(stringType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("ends_with").setInvariantType(booleanType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("from_base64").setInvariantType(byteArrayType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("from_hex").setInvariantType(byteArrayType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("regexp_contains").setInvariantType(booleanType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("regexp_extract").setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("regexp_extract_all").setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("regexp_replace").setExactArgumentCount(3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("safe_convert_bytes_to_string").setInvariantType(stringType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("split").setArgumentCountBetween(1, 2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("starts_with").setInvariantType(booleanType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("strpos").setInvariantType(longType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("to_base64").setInvariantType(stringType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("to_code_points").setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("to_hex").setInvariantType(stringType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("json_query").setInvariantType(stringType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("json_value").setInvariantType(stringType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("array").setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("array_concat").register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("array_length").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("array_to_string").setInvariantType(stringType).setArgumentCountBetween(2, 3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("array_reverse").setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("date").setInvariantType(dateType).setArgumentCountBetween(1, 3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("date_add").setInvariantType(dateType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("date_sub").setInvariantType(dateType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("date_diff").setInvariantType(longType).setExactArgumentCount(3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("date_trunc").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType(1)).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("date_from_unix_date").setInvariantType(dateType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("format_date").setInvariantType(stringType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("parse_date").setInvariantType(dateType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("unix_date").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("string").setInvariantType(stringType).setArgumentCountBetween(1, 2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp").setInvariantType(timestampType).setArgumentCountBetween(1, 2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_add").setInvariantType(timestampType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_sub").setInvariantType(timestampType).setExactArgumentCount(2).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_diff").setInvariantType(longType).setExactArgumentCount(3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_trunc").setInvariantType(timestampType).setArgumentCountBetween(2, 3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("format_timestamp").setInvariantType(stringType).setArgumentCountBetween(2, 3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("parse_timestamp").setInvariantType(timestampType).setArgumentCountBetween(2, 3).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_seconds").setInvariantType(timestampType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_millis").setInvariantType(timestampType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timestamp_micros").setInvariantType(timestampType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("unix_seconds").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("unix_millis").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("unix_micros").setInvariantType(longType).setExactArgumentCount(1).register();
        functionContributions.getFunctionRegistry().register("format", new FormatFunction("format_timestamp", true, true, functionContributions.getTypeConfiguration()));
        functionFactory.listagg_stringAgg("string");
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.array_spanner();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SpannerSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public Exporter<Table> getTableExporter() {
        return this.spannerTableExporter;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp() as now";
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "isoweek";
            }
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (temporalType == TemporalType.TIMESTAMP) {
            switch (unit) {
                case YEAR: 
                case QUARTER: 
                case MONTH: {
                    throw new SemanticException("Illegal unit for timestamp_add(): " + unit);
                }
            }
            return "timestamp_add(?3,interval ?2 ?1)";
        }
        switch (unit) {
            case NANOSECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case NATIVE: {
                throw new SemanticException("Illegal unit for date_add(): " + unit);
            }
        }
        return "date_add(?3,interval ?2 ?1)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (toTemporalType == TemporalType.TIMESTAMP || fromTemporalType == TemporalType.TIMESTAMP) {
            switch (unit) {
                case YEAR: 
                case QUARTER: 
                case MONTH: {
                    throw new SemanticException("Illegal unit for timestamp_diff(): " + unit);
                }
            }
            return "timestamp_diff(?3,?2,?1)";
        }
        switch (unit) {
            case NANOSECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case NATIVE: {
                throw new SemanticException("Illegal unit for date_diff(): " + unit);
            }
        }
        return "date_diff(?3,?2,?1)";
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SpannerDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return MySQLDialect.datetimeFormat(format).replace("EEEE", "%A").replace("EEE", "%a").replace("mm", "%M").replace("m", "%M").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%m").replace("ww", "%V").replace("w", "%V").replace("YYYY", "%G").replace("YYY", "%G").replace("YY", "%g").replace("Y", "%g").replace("zzz", "%Z").replace("zz", "%Z").replace("z", "%Z").replace("ZZZ", "%z").replace("ZZ", "%z").replace("Z", "%z").replace("xxx", "%Ez").replace("xx", "%z");
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public String getCurrentSchemaCommand() {
        throw new UnsupportedOperationException("No current schema syntax supported by " + this.getClass().getName());
    }

    @Override
    public SchemaNameResolver getSchemaNameResolver() {
        return (connection, dialect) -> "";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getDropForeignKeyString() {
        throw new UnsupportedOperationException("Cannot drop foreign-key constraint because Cloud Spanner does not support foreign keys.");
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        throw new UnsupportedOperationException("Cannot add foreign-key constraint because Cloud Spanner does not support foreign keys.");
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        throw new UnsupportedOperationException("Cannot add foreign-key constraint because Cloud Spanner does not support foreign keys.");
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("Cannot add primary key constraint in Cloud Spanner.");
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public LockingStrategy getLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        return LOCKING_STRATEGY;
    }

    @Override
    public String getForUpdateString(LockOptions lockOptions) {
        return "";
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public String getForUpdateString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getWriteLockString(int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getReadLockString(int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public String getForUpdateNowaitString() {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateSkipLockedString() {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    @Override
    public Exporter<Sequence> getSequenceExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public Exporter<ForeignKey> getForeignKeyExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public Exporter<UniqueKey> getUniqueKeyExporter() {
        return NOOP_EXPORTER;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return NOOP_UNIQUE_DELEGATE;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitOffsetLimitHandler.INSTANCE;
    }

    static class EmptyExporter<T extends Exportable>
    implements Exporter<T> {
        EmptyExporter() {
        }

        @Override
        public String[] getSqlCreateStrings(T exportable, Metadata metadata, SqlStringGenerationContext context) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }

        @Override
        public String[] getSqlDropStrings(T exportable, Metadata metadata, SqlStringGenerationContext context) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
    }

    static class DoNothingLockingStrategy
    implements LockingStrategy {
        DoNothingLockingStrategy() {
        }

        @Override
        public void lock(Object id, Object version, Object object, int timeout, EventSource session) throws StaleObjectStateException, LockingStrategyException {
        }
    }

    static class DoNothingUniqueDelegate
    implements UniqueDelegate {
        DoNothingUniqueDelegate() {
        }

        @Override
        public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
            return "";
        }

        @Override
        public String getTableCreationUniqueConstraintsFragment(Table table, SqlStringGenerationContext context) {
            return "";
        }

        @Override
        public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
            return "";
        }

        @Override
        public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
            return "";
        }
    }
}

