/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleEnumJdbcType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;

public class OracleOrdinalEnumJdbcType
extends OracleEnumJdbcType {
    public static final OracleOrdinalEnumJdbcType INSTANCE = new OracleOrdinalEnumJdbcType();

    @Override
    public int getJdbcTypeCode() {
        return 4;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 6003;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, OracleOrdinalEnumJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, OracleOrdinalEnumJdbcType.this.getJdbcTypeCode());
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setInt(index, ((Enum)value).ordinal() + 1);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setInt(name, ((Enum)value).ordinal() + 1);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                int value = rs.getInt(paramIndex);
                return rs.wasNull() ? this.getJavaType().wrap(null, options) : this.getJavaType().wrap(value - 1, options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getInt(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(statement.getInt(name), options);
            }
        };
    }

    @Override
    String[] getCreateEnumTypeCommand(String name, String[] enumeratedValues, Dialect dialect) {
        return dialect.getCreateEnumTypeCommand(name, enumeratedValues);
    }
}

