/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;

public class MySQLSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private static final int MAX_CHAR_SIZE = 0x3FFFFFFF;

    public MySQLSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public static String getSqlType(CastTarget castTarget, SessionFactoryImplementor factory) {
        String sqlType = MySQLSqlAstTranslator.getCastTypeName(castTarget, factory.getTypeConfiguration());
        return MySQLSqlAstTranslator.getSqlType(castTarget, sqlType, factory.getJdbcServices().getDialect());
    }

    private static String getSqlType(CastTarget castTarget, String sqlType, Dialect dialect) {
        if (sqlType != null) {
            int parenthesesIndex = sqlType.indexOf(40);
            String baseName = parenthesesIndex == -1 ? sqlType : sqlType.substring(0, parenthesesIndex).trim();
            switch (baseName.toLowerCase(Locale.ROOT)) {
                case "bit": {
                    return "unsigned";
                }
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    return "signed";
                }
                case "float": 
                case "real": 
                case "double precision": {
                    if (((MySQLDialect)dialect).getMySQLVersion().isSameOrAfter(8, 0, 17)) {
                        return sqlType;
                    }
                    int precision = castTarget.getPrecision() == null ? dialect.getDefaultDecimalPrecision() : castTarget.getPrecision().intValue();
                    int scale = castTarget.getScale() == null ? 2 : castTarget.getScale();
                    return "decimal(" + precision + "," + scale + ")";
                }
                case "char": 
                case "varchar": 
                case "nchar": 
                case "nvarchar": 
                case "text": 
                case "mediumtext": 
                case "longtext": 
                case "enum": {
                    if (castTarget.getLength() == null) {
                        if (castTarget.getJdbcMapping().getJdbcJavaType().getJavaType() == Character.class) {
                            return "char(1)";
                        }
                        return "char";
                    }
                    return castTarget.getLength() > 0x3FFFFFFFL ? "char" : "char(" + castTarget.getLength() + ")";
                }
                case "binary": 
                case "varbinary": 
                case "mediumblob": 
                case "longblob": {
                    return castTarget.getLength() == null ? "binary" : "binary(" + castTarget.getLength() + ")";
                }
            }
        }
        return sqlType;
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(" div ");
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    @Override
    protected void visitInsertSource(InsertSelectStatement statement) {
        if (statement.getSourceSelectStatement() != null) {
            if (statement.getConflictClause() != null) {
                List<ColumnReference> targetColumnReferences = statement.getTargetColumns();
                ArrayList<String> columnNames = new ArrayList<String>(targetColumnReferences.size());
                for (ColumnReference targetColumnReference : targetColumnReferences) {
                    columnNames.add(targetColumnReference.getColumnExpression());
                }
                this.appendSql("select * from ");
                this.emulateQueryPartTableReferenceColumnAliasing(new QueryPartTableReference(new SelectStatement(statement.getSourceSelectStatement()), "excluded", columnNames, false, this.getSessionFactory()));
            } else {
                statement.getSourceSelectStatement().accept(this);
            }
        } else {
            this.visitValuesList(statement.getValuesList());
            if (statement.getConflictClause() != null && this.getDialect().getMySQLVersion().isSameOrAfter(8, 0, 19)) {
                this.appendSql(" as excluded");
                int separator = 40;
                for (ColumnReference targetColumn : statement.getTargetColumns()) {
                    this.appendSql((char)separator);
                    this.appendSql(targetColumn.getColumnExpression());
                    separator = 44;
                }
                this.appendSql(')');
            }
        }
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        Statement currentStatement;
        if (this.getDialect().getMySQLVersion().isBefore(8, 0, 19) && "excluded".equals(columnReference.getQualifier()) && (currentStatement = this.getStatementStack().getCurrent()) instanceof InsertSelectStatement && ((InsertSelectStatement)currentStatement).getSourceSelectStatement() == null) {
            this.appendSql("values(");
            columnReference.appendReadExpression(this, null);
            this.append(')');
        } else {
            super.visitColumnReference(columnReference);
        }
    }

    @Override
    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderTableReferenceIdentificationVariable(statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (updateStatement.getFromClause().getRoots().isEmpty()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update ");
            this.renderFromClauseSpaces(updateStatement.getFromClause());
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected boolean supportsJoinsInDelete() {
        return true;
    }

    @Override
    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), this.getUniqueConstraintNameThatMayFail(sqlAst));
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitOnDuplicateKeyConflictClause(conflictClause);
    }

    @Override
    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        String dmlAlias;
        MutationStatement currentDmlStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (this.getClauseStack().getCurrent() != Clause.SET || !((currentDmlStatement = this.getCurrentDmlStatement()) instanceof InsertSelectStatement) || (dmlAlias = currentDmlStatement.getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        if (qualifierSupport != DmlTargetColumnQualifierSupport.NONE || !this.getQueryPartStack().isEmpty()) {
            return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
        }
        return null;
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        if (sizeEstimate == -1) {
            super.visitRecursivePath(recursivePath, sizeEstimate);
        } else {
            this.appendSql("cast(");
            recursivePath.accept(this);
            this.appendSql(" as char(");
            this.appendSql(sizeEstimate);
            this.appendSql("))");
        }
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    @Override
    protected String getForShare(int timeoutMillis) {
        return " for share";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    @Override
    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        if (tableReference instanceof FunctionTableReference && tableReference.isLateral()) {
            tableReference.accept(this);
        } else {
            super.renderDerivedTableReference(tableReference);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonDistinctOperator(lhs, operator, rhs);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        if (this.getDialect().getVersion().isSameOrAfter(8, 0, 24)) {
            super.visitLikePredicate(likePredicate);
            if (!this.getDialect().isNoBackslashEscapesEnabled() && likePredicate.getEscapeCharacter() == null) {
                this.appendSql(" escape ''");
            }
        } else {
            if (likePredicate.isCaseSensitive()) {
                likePredicate.getMatchExpression().accept(this);
                if (likePredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" like ");
                this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.getDialect().isNoBackslashEscapesEnabled());
            } else {
                this.appendSql(this.getDialect().getLowercaseFunction());
                this.appendSql('(');
                likePredicate.getMatchExpression().accept(this);
                this.appendSql(')');
                if (likePredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" like ");
                this.appendSql(this.getDialect().getLowercaseFunction());
                this.appendSql('(');
                this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.getDialect().isNoBackslashEscapesEnabled());
                this.appendSql(')');
            }
            if (likePredicate.getEscapeCharacter() != null) {
                this.appendSql(" escape ");
                likePredicate.getEscapeCharacter().accept(this);
            }
        }
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInSet() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean supportsIntersect() {
        return false;
    }

    @Override
    protected boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return true;
    }

    @Override
    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    @Override
    protected boolean supportsWithClause() {
        return true;
    }

    @Override
    public MySQLDialect getDialect() {
        return (MySQLDialect)DialectDelegateWrapper.extractRealDialect(super.getDialect());
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType(castTarget, this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }

    @Override
    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        haystack.accept(this);
        this.appendSql(" like concat('%',replace(replace(replace(");
        needle.accept(this);
        this.appendSql(",'~','~~'),'?','~?'),'%','~%'),'%') escape '~'");
    }
}

