/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.boot.models.DialectOverrideAnnotations;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.models.AnnotationAccessException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class OrmAnnotationHelper {
    public static void forEachOrmAnnotation(Consumer<AnnotationDescriptor<?>> consumer) {
        JpaAnnotations.forEachAnnotation(consumer);
        HibernateAnnotations.forEachAnnotation(consumer);
        DialectOverrideAnnotations.forEachAnnotation(consumer);
        XmlAnnotations.forEachAnnotation(consumer);
    }

    public static void forEachOrmAnnotation(Class<?> declarer, Consumer<AnnotationDescriptor<?>> consumer) {
        for (Field field : declarer.getFields()) {
            if (!AnnotationDescriptor.class.isAssignableFrom(field.getType())) continue;
            try {
                consumer.accept((AnnotationDescriptor)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new AnnotationAccessException(String.format(Locale.ROOT, "Unable to access standard annotation descriptor field - %s", field.getName()), (Throwable)e);
            }
        }
    }

    public static <V, A extends Annotation> V extractJdkValue(A jdkAnnotation, AttributeDescriptor<V> attributeDescriptor, SourceModelBuildingContext modelContext) {
        return (V)attributeDescriptor.getTypeDescriptor().createJdkValueExtractor(modelContext).extractValue(jdkAnnotation, attributeDescriptor, modelContext);
    }

    public static <V, A extends Annotation> V extractJdkValue(A jdkAnnotation, AnnotationDescriptor<A> annotationDescriptor, String attributeName, SourceModelBuildingContext modelContext) {
        AttributeDescriptor attributeDescriptor = annotationDescriptor.getAttribute(attributeName);
        return OrmAnnotationHelper.extractJdkValue(jdkAnnotation, attributeDescriptor, modelContext);
    }

    public static List<Annotation> extractAnnotationTypeAnnotations(Class<? extends Annotation> annotationType) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        Annotation[] annotationTypeAnnotations = annotationType.getAnnotations();
        for (int i = 0; i < annotationTypeAnnotations.length; ++i) {
            Annotation annotationTypeAnnotation = annotationTypeAnnotations[i];
            Class<? extends Annotation> annotationTypeAnnotationType = annotationTypeAnnotation.annotationType();
            if (annotationTypeAnnotationType == Repeatable.class || annotationTypeAnnotationType == Target.class || annotationTypeAnnotationType == Retention.class || annotationTypeAnnotationType == Documented.class) continue;
            result.add(annotationTypeAnnotation);
        }
        return result;
    }
}

