/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import java.util.List;
import org.hibernate.boot.models.categorize.spi.AttributeConsumer;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.NonAggregatedKeyMapping;
import org.hibernate.models.spi.ClassDetails;

public class NonAggregatedKeyMappingImpl
implements NonAggregatedKeyMapping {
    private final List<AttributeMetadata> idAttributes;
    private final ClassDetails idClassType;

    public NonAggregatedKeyMappingImpl(List<AttributeMetadata> idAttributes, ClassDetails idClassType) {
        this.idAttributes = idAttributes;
        this.idClassType = idClassType;
    }

    @Override
    public List<AttributeMetadata> getIdAttributes() {
        return this.idAttributes;
    }

    @Override
    public ClassDetails getIdClassType() {
        return this.idClassType;
    }

    @Override
    public ClassDetails getKeyType() {
        return this.idClassType;
    }

    @Override
    public void forEachAttribute(AttributeConsumer consumer) {
        for (int i = 0; i < this.idAttributes.size(); ++i) {
            consumer.accept(i, this.idAttributes.get(i));
        }
    }

    @Override
    public boolean contains(AttributeMetadata attributeMetadata) {
        for (int i = 0; i < this.idAttributes.size(); ++i) {
            if (this.idAttributes.get(i) != attributeMetadata) continue;
            return true;
        }
        return false;
    }
}

