/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.AccessType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import java.util.Locale;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.OptimisticLocking;
import org.hibernate.boot.models.categorize.ModelCategorizationLogging;
import org.hibernate.boot.models.categorize.internal.AbstractIdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.internal.CategorizationHelper;
import org.hibernate.boot.models.categorize.internal.EntityTypeMetadataImpl;
import org.hibernate.boot.models.categorize.internal.HierarchyMetadataCollector;
import org.hibernate.boot.models.categorize.internal.HierarchyTypeConsumer;
import org.hibernate.boot.models.categorize.internal.MappedSuperclassTypeMetadataImpl;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.CacheRegion;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.spi.KeyMapping;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.boot.models.categorize.spi.NaturalIdCacheRegion;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.models.spi.ClassDetails;

public class EntityHierarchyImpl
implements EntityHierarchy {
    private final IdentifiableTypeMetadata absoluteRootTypeMetadata;
    private final EntityTypeMetadata rootEntityTypeMetadata;
    private final InheritanceType inheritanceType;
    private final AccessType defaultAccessType;
    private final OptimisticLockStyle optimisticLockStyle;
    private final KeyMapping idMapping;
    private final KeyMapping naturalIdMapping;
    private final AttributeMetadata versionAttribute;
    private final AttributeMetadata tenantIdAttribute;
    private final CacheRegion cacheRegion;
    private final NaturalIdCacheRegion naturalIdCacheRegion;
    private static final OptimisticLockStyle DEFAULT_LOCKING_STRATEGY = OptimisticLockStyle.VERSION;

    public EntityHierarchyImpl(ClassDetails rootEntityClassDetails, AccessType defaultAccessType, org.hibernate.cache.spi.access.AccessType defaultCacheAccessType, HierarchyTypeConsumer typeConsumer, ModelCategorizationContext categorizationContext) {
        this.defaultAccessType = defaultAccessType;
        ClassDetails absoluteRootClassDetails = this.findRootRoot(rootEntityClassDetails);
        HierarchyMetadataCollector metadataCollector = new HierarchyMetadataCollector(this, rootEntityClassDetails, typeConsumer, categorizationContext);
        if (CategorizationHelper.isEntity(absoluteRootClassDetails)) {
            this.rootEntityTypeMetadata = new EntityTypeMetadataImpl(absoluteRootClassDetails, (EntityHierarchy)this, defaultAccessType, (HierarchyTypeConsumer)metadataCollector, categorizationContext);
            this.absoluteRootTypeMetadata = this.rootEntityTypeMetadata;
        } else {
            assert (CategorizationHelper.isMappedSuperclass(absoluteRootClassDetails));
            this.absoluteRootTypeMetadata = EntityHierarchyImpl.processRootMappedSuperclasses(absoluteRootClassDetails, this, defaultAccessType, metadataCollector, categorizationContext);
            this.rootEntityTypeMetadata = new EntityTypeMetadataImpl(rootEntityClassDetails, (EntityHierarchy)this, (AbstractIdentifiableTypeMetadata)this.absoluteRootTypeMetadata, (HierarchyTypeConsumer)metadataCollector, categorizationContext);
        }
        this.inheritanceType = this.determineInheritanceType(metadataCollector);
        this.optimisticLockStyle = this.determineOptimisticLockStyle(metadataCollector);
        this.idMapping = metadataCollector.getIdMapping();
        this.naturalIdMapping = metadataCollector.getNaturalIdMapping();
        this.versionAttribute = metadataCollector.getVersionAttribute();
        this.tenantIdAttribute = metadataCollector.getTenantIdAttribute();
        this.cacheRegion = this.determineCacheRegion(metadataCollector, defaultCacheAccessType);
        this.naturalIdCacheRegion = this.determineNaturalIdCacheRegion(metadataCollector, this.cacheRegion);
    }

    private static IdentifiableTypeMetadata processRootMappedSuperclasses(ClassDetails absoluteRootClassDetails, EntityHierarchyImpl entityHierarchy, AccessType defaultAccessType, HierarchyMetadataCollector metadataCollector, ModelCategorizationContext modelBuildingContext) {
        return new MappedSuperclassTypeMetadataImpl(absoluteRootClassDetails, entityHierarchy, null, defaultAccessType, metadataCollector, modelBuildingContext);
    }

    private ClassDetails findRootRoot(ClassDetails rootEntityClassDetails) {
        ClassDetails match;
        if (rootEntityClassDetails.getSuperClass() != null && (match = this.walkSupers(rootEntityClassDetails.getSuperClass())) != null) {
            return match;
        }
        return rootEntityClassDetails;
    }

    private ClassDetails walkSupers(ClassDetails type) {
        ClassDetails match;
        assert (type != null);
        if (type.getSuperClass() != null && (match = this.walkSupers(type.getSuperClass())) != null) {
            return match;
        }
        if (CategorizationHelper.isIdentifiable(type)) {
            return type;
        }
        return null;
    }

    @Override
    public EntityTypeMetadata getRoot() {
        return this.rootEntityTypeMetadata;
    }

    @Override
    public IdentifiableTypeMetadata getAbsoluteRoot() {
        return this.absoluteRootTypeMetadata;
    }

    @Override
    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    @Override
    public AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    @Override
    public KeyMapping getIdMapping() {
        return this.idMapping;
    }

    @Override
    public KeyMapping getNaturalIdMapping() {
        return this.naturalIdMapping;
    }

    @Override
    public AttributeMetadata getVersionAttribute() {
        return this.versionAttribute;
    }

    @Override
    public AttributeMetadata getTenantIdAttribute() {
        return this.tenantIdAttribute;
    }

    @Override
    public OptimisticLockStyle getOptimisticLockStyle() {
        return this.optimisticLockStyle;
    }

    @Override
    public CacheRegion getCacheRegion() {
        return this.cacheRegion;
    }

    @Override
    public NaturalIdCacheRegion getNaturalIdCacheRegion() {
        return this.naturalIdCacheRegion;
    }

    @Override
    public void forEachType(EntityHierarchy.HierarchyTypeVisitor typeVisitor) {
        IdentifiableTypeMetadata absoluteRoot = this.getAbsoluteRoot();
        EntityHierarchy.HierarchyRelation hierarchyRelation = absoluteRoot == this.getRoot() ? EntityHierarchy.HierarchyRelation.ROOT : EntityHierarchy.HierarchyRelation.SUPER;
        this.forEachType(absoluteRoot, null, hierarchyRelation, typeVisitor);
    }

    private void forEachType(IdentifiableTypeMetadata type, IdentifiableTypeMetadata superType, EntityHierarchy.HierarchyRelation hierarchyRelation, EntityHierarchy.HierarchyTypeVisitor typeVisitor) {
        typeVisitor.visitType(type, superType, this, hierarchyRelation);
        EntityHierarchy.HierarchyRelation nextRelation = hierarchyRelation == EntityHierarchy.HierarchyRelation.SUPER ? (type == this.getRoot().getSuperType() ? EntityHierarchy.HierarchyRelation.ROOT : EntityHierarchy.HierarchyRelation.SUPER) : EntityHierarchy.HierarchyRelation.SUB;
        type.forEachSubType(subType -> this.forEachType((IdentifiableTypeMetadata)subType, type, nextRelation, typeVisitor));
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityHierarchy(`%s` (%s))", this.rootEntityTypeMetadata.getEntityName(), this.inheritanceType.name());
    }

    private InheritanceType determineInheritanceType(HierarchyMetadataCollector metadataCollector) {
        Inheritance inheritanceAnnotation;
        if (ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.isDebugEnabled()) {
            this.ensureNoInheritanceAnnotationsOnSubclasses(this.rootEntityTypeMetadata);
        }
        if ((inheritanceAnnotation = metadataCollector.getInheritanceAnnotation()) != null) {
            return inheritanceAnnotation.strategy();
        }
        return InheritanceType.SINGLE_TABLE;
    }

    private OptimisticLockStyle determineOptimisticLockStyle(HierarchyMetadataCollector metadataCollector) {
        OptimisticLocking optimisticLockingAnnotation = metadataCollector.getOptimisticLockingAnnotation();
        if (optimisticLockingAnnotation != null) {
            OptimisticLockType lockingType = optimisticLockingAnnotation.type();
            return OptimisticLockStyle.fromLockType(lockingType);
        }
        return DEFAULT_LOCKING_STRATEGY;
    }

    private CacheRegion determineCacheRegion(HierarchyMetadataCollector metadataCollector, org.hibernate.cache.spi.access.AccessType defaultCacheAccessType) {
        Cache cacheAnnotation = metadataCollector.getCacheAnnotation();
        return new CacheRegion(cacheAnnotation, defaultCacheAccessType, this.rootEntityTypeMetadata.getEntityName());
    }

    private NaturalIdCacheRegion determineNaturalIdCacheRegion(HierarchyMetadataCollector metadataCollector, CacheRegion cacheRegion) {
        NaturalIdCache naturalIdCacheAnnotation = metadataCollector.getNaturalIdCacheAnnotation();
        return new NaturalIdCacheRegion(naturalIdCacheAnnotation, cacheRegion);
    }

    private static InheritanceType getLocallyDefinedInheritanceType(ClassDetails managedClass) {
        Inheritance localAnnotation = (Inheritance)managedClass.getDirectAnnotationUsage(Inheritance.class);
        if (localAnnotation == null) {
            return null;
        }
        return localAnnotation.strategy();
    }

    private void ensureNoInheritanceAnnotationsOnSubclasses(IdentifiableTypeMetadata type) {
        type.forEachSubType(subType -> {
            if (EntityHierarchyImpl.getLocallyDefinedInheritanceType(subType.getClassDetails()) != null) {
                ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("@javax.persistence.Inheritance was specified on non-root entity [%s]; ignoring...", (Object)type.getClassDetails().getName());
            }
            this.ensureNoInheritanceAnnotationsOnSubclasses((IdentifiableTypeMetadata)subType);
        });
    }
}

