/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import java.net.URL;
import java.util.Collection;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.models.spi.ClassLoading;

public class ClassLoaderServiceLoading
implements ClassLoading {
    private final ClassLoaderService classLoaderService;

    public ClassLoaderServiceLoading(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }

    public <T> Class<T> classForName(String name) {
        return this.classLoaderService.classForName(name);
    }

    public <T> Class<T> findClassForName(String name) {
        try {
            return this.classLoaderService.classForName(name);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public Package packageForName(String name) {
        return this.classLoaderService.packageForNameOrNull(name);
    }

    public URL locateResource(String resourceName) {
        return this.classLoaderService.locateResource(resourceName);
    }

    public <S> Collection<S> loadJavaServices(Class<S> serviceType) {
        return this.classLoaderService.loadJavaServices(serviceType);
    }
}

