/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.Version;
import java.util.EnumSet;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.AnyKeyJavaType;
import org.hibernate.annotations.AnyKeyJdbcType;
import org.hibernate.annotations.AnyKeyJdbcTypeCode;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.JavaType;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.TenantId;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.Type;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.MultipleAttributeNaturesException;
import org.hibernate.boot.models.categorize.ModelCategorizationLogging;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.ClassAttributeAccessType;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;

public class CategorizationHelper {
    public static ClassDetails toClassDetails(Class<?> clazz, ClassDetailsRegistry classDetailsRegistry) {
        return classDetailsRegistry.resolveClassDetails(clazz.getName());
    }

    public static boolean isMappedSuperclass(ClassDetails classDetails) {
        return classDetails.hasDirectAnnotationUsage(MappedSuperclass.class);
    }

    public static boolean isEntity(ClassDetails classDetails) {
        return classDetails.getDirectAnnotationUsage(Entity.class) != null;
    }

    public static boolean isIdentifiable(ClassDetails classDetails) {
        return CategorizationHelper.isEntity(classDetails) || CategorizationHelper.isMappedSuperclass(classDetails);
    }

    public static ClassAttributeAccessType determineAccessType(ClassDetails classDetails, AccessType implicitAccessType) {
        Access annotation = (Access)classDetails.getDirectAnnotationUsage(Access.class);
        if (annotation != null) {
            AccessType explicitValue = annotation.value();
            assert (explicitValue != null);
            return explicitValue == AccessType.FIELD ? ClassAttributeAccessType.EXPLICIT_FIELD : ClassAttributeAccessType.EXPLICIT_PROPERTY;
        }
        return implicitAccessType == AccessType.FIELD ? ClassAttributeAccessType.IMPLICIT_FIELD : ClassAttributeAccessType.IMPLICIT_PROPERTY;
    }

    public static AttributeMetadata.AttributeNature determineAttributeNature(ClassDetails declarer, MemberDetails backingMember) {
        boolean implicitlyAny;
        EnumSet<AttributeMetadata.AttributeNature> natures = EnumSet.noneOf(AttributeMetadata.AttributeNature.class);
        Any any = (Any)backingMember.getDirectAnnotationUsage(Any.class);
        Basic basic = (Basic)backingMember.getDirectAnnotationUsage(Basic.class);
        ElementCollection elementCollection = (ElementCollection)backingMember.getDirectAnnotationUsage(ElementCollection.class);
        Embedded embedded = (Embedded)backingMember.getDirectAnnotationUsage(Embedded.class);
        EmbeddedId embeddedId = (EmbeddedId)backingMember.getDirectAnnotationUsage(EmbeddedId.class);
        ManyToAny manyToAny = (ManyToAny)backingMember.getDirectAnnotationUsage(ManyToAny.class);
        ManyToMany manyToMany = (ManyToMany)backingMember.getDirectAnnotationUsage(ManyToMany.class);
        ManyToOne manyToOne = (ManyToOne)backingMember.getDirectAnnotationUsage(ManyToOne.class);
        OneToMany oneToMany = (OneToMany)backingMember.getDirectAnnotationUsage(OneToMany.class);
        OneToOne oneToOne = (OneToOne)backingMember.getDirectAnnotationUsage(OneToOne.class);
        if (basic != null) {
            natures.add(AttributeMetadata.AttributeNature.BASIC);
        }
        if (embedded != null || embeddedId != null || backingMember.getType() != null && backingMember.getType().determineRawClass().hasDirectAnnotationUsage(Embeddable.class)) {
            natures.add(AttributeMetadata.AttributeNature.EMBEDDED);
        }
        if (any != null) {
            natures.add(AttributeMetadata.AttributeNature.ANY);
        }
        if (oneToOne != null || manyToOne != null) {
            natures.add(AttributeMetadata.AttributeNature.TO_ONE);
        }
        if (elementCollection != null) {
            natures.add(AttributeMetadata.AttributeNature.ELEMENT_COLLECTION);
        }
        if (oneToMany != null) {
            natures.add(AttributeMetadata.AttributeNature.ONE_TO_MANY);
        }
        if (manyToMany != null) {
            natures.add(AttributeMetadata.AttributeNature.MANY_TO_MANY);
        }
        if (manyToAny != null) {
            natures.add(AttributeMetadata.AttributeNature.MANY_TO_ANY);
        }
        boolean plural = oneToMany != null || manyToMany != null || elementCollection != null || manyToAny != null;
        boolean implicitlyBasic = backingMember.hasDirectAnnotationUsage(Temporal.class) || backingMember.hasDirectAnnotationUsage(Lob.class) || backingMember.hasDirectAnnotationUsage(Enumerated.class) || backingMember.hasDirectAnnotationUsage(Version.class) || backingMember.hasDirectAnnotationUsage(HibernateAnnotations.GENERATED.getAnnotationType()) || backingMember.hasDirectAnnotationUsage(Nationalized.class) || backingMember.hasDirectAnnotationUsage(TimeZoneColumn.class) || backingMember.hasDirectAnnotationUsage(TimeZoneStorage.class) || backingMember.hasDirectAnnotationUsage(Type.class) || backingMember.hasDirectAnnotationUsage(TenantId.class) || backingMember.hasDirectAnnotationUsage(JavaType.class) || backingMember.hasDirectAnnotationUsage(JdbcType.class) || backingMember.hasDirectAnnotationUsage(JdbcTypeCode.class);
        boolean implicitlyEmbedded = backingMember.hasDirectAnnotationUsage(EmbeddableInstantiator.class) || backingMember.hasDirectAnnotationUsage(CompositeType.class);
        boolean bl = implicitlyAny = backingMember.hasDirectAnnotationUsage(AnyDiscriminator.class) || backingMember.hasDirectAnnotationUsage(AnyKeyJavaType.class) || backingMember.hasDirectAnnotationUsage(AnyKeyJavaClass.class) || backingMember.hasDirectAnnotationUsage(AnyKeyJdbcType.class) || backingMember.hasDirectAnnotationUsage(AnyKeyJdbcTypeCode.class);
        if (!plural) {
            if (implicitlyBasic) {
                natures.add(AttributeMetadata.AttributeNature.BASIC);
            }
            if (implicitlyEmbedded) {
                natures.add(AttributeMetadata.AttributeNature.EMBEDDED);
            }
            if (implicitlyAny) {
                natures.add(AttributeMetadata.AttributeNature.ANY);
            }
        } else if (elementCollection != null) {
            if (natures.contains((Object)AttributeMetadata.AttributeNature.BASIC)) {
                if (!natures.contains((Object)AttributeMetadata.AttributeNature.EMBEDDED)) {
                    ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Ignoring @Basic on @ElementCollection - %s", (Object)backingMember.resolveAttributeName());
                    natures.remove((Object)AttributeMetadata.AttributeNature.BASIC);
                }
            } else if (natures.contains((Object)AttributeMetadata.AttributeNature.EMBEDDED)) {
                ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Ignoring @Embedded on @ElementCollection - %s", (Object)backingMember.resolveAttributeName());
                natures.remove((Object)AttributeMetadata.AttributeNature.EMBEDDED);
            }
        }
        int size = natures.size();
        return switch (size) {
            case 0 -> {
                ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Implicitly interpreting attribute `%s` as BASIC", (Object)backingMember.resolveAttributeName());
                yield AttributeMetadata.AttributeNature.BASIC;
            }
            case 1 -> (AttributeMetadata.AttributeNature)((Object)natures.iterator().next());
            default -> throw new MultipleAttributeNaturesException(declarer.getName() + "#" + backingMember.resolveAttributeName(), natures);
        };
    }
}

