/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.model.source.spi.AttributeRole;
import org.hibernate.boot.model.source.spi.NaturalIdMutability;
import org.hibernate.boot.models.categorize.internal.AttributeMetadataImpl;
import org.hibernate.boot.models.categorize.internal.CategorizationHelper;
import org.hibernate.boot.models.categorize.spi.AllMemberConsumer;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.ManagedTypeMetadata;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public abstract class AbstractManagedTypeMetadata
implements ManagedTypeMetadata {
    private final ClassDetails classDetails;
    private final ModelCategorizationContext modelContext;
    private final AttributePath attributePathBase;
    private final AttributeRole attributeRoleBase;

    public AbstractManagedTypeMetadata(ClassDetails classDetails, ModelCategorizationContext modelContext) {
        this.classDetails = classDetails;
        this.modelContext = modelContext;
        this.attributeRoleBase = new AttributeRole(classDetails.getName());
        this.attributePathBase = new AttributePath();
    }

    public AbstractManagedTypeMetadata(ClassDetails classDetails, AttributeRole attributeRoleBase, AttributePath attributePathBase, ModelCategorizationContext modelContext) {
        this.classDetails = classDetails;
        this.modelContext = modelContext;
        this.attributeRoleBase = attributeRoleBase;
        this.attributePathBase = attributePathBase;
    }

    @Override
    public ClassDetails getClassDetails() {
        return this.classDetails;
    }

    public ModelCategorizationContext getModelContext() {
        return this.modelContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractManagedTypeMetadata that = (AbstractManagedTypeMetadata)o;
        return Objects.equals(this.classDetails.getName(), that.classDetails.getName());
    }

    public int hashCode() {
        return Objects.hash(this.classDetails);
    }

    public String toString() {
        return "ManagedTypeMetadata(" + this.classDetails.getName() + ")";
    }

    protected abstract List<AttributeMetadata> attributeList();

    @Override
    public int getNumberOfAttributes() {
        return this.attributeList().size();
    }

    @Override
    public Collection<AttributeMetadata> getAttributes() {
        return this.attributeList();
    }

    @Override
    public AttributeMetadata findAttribute(String name) {
        List<AttributeMetadata> attributeList = this.attributeList();
        for (int i = 0; i < attributeList.size(); ++i) {
            AttributeMetadata attribute = attributeList.get(i);
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void forEachAttribute(IndexedConsumer<AttributeMetadata> consumer) {
        for (int i = 0; i < this.attributeList().size(); ++i) {
            consumer.accept(i, this.attributeList().get(i));
        }
    }

    protected List<AttributeMetadata> resolveAttributes(AllMemberConsumer memberConsumer) {
        List<MemberDetails> backingMembers = this.getModelContext().getPersistentAttributeMemberResolver().resolveAttributesMembers(this.classDetails, this.getClassLevelAccessType(), memberConsumer);
        ArrayList<AttributeMetadata> attributeList = CollectionHelper.arrayList(backingMembers.size());
        for (MemberDetails backingMember : backingMembers) {
            AttributeMetadataImpl attribute = new AttributeMetadataImpl(backingMember.resolveAttributeName(), CategorizationHelper.determineAttributeNature(this.classDetails, backingMember), backingMember);
            attributeList.add(attribute);
        }
        return attributeList;
    }

    public boolean canAttributesBeInsertable() {
        return true;
    }

    public boolean canAttributesBeUpdatable() {
        return true;
    }

    public NaturalIdMutability getContainerNaturalIdMutability() {
        return NaturalIdMutability.NOT_NATURAL_ID;
    }
}

