/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedHqlQueryImpl;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.query.QueryFlushMode;

public class NamedQueryAnnotation
implements NamedQuery {
    private String name;
    private String query;
    private Class<?> resultClass;
    private FlushModeType flushMode;
    private QueryFlushMode flush;
    boolean cacheable;
    String cacheRegion;
    int fetchSize;
    int timeout;
    String comment;
    CacheStoreMode cacheStoreMode;
    CacheRetrieveMode cacheRetrieveMode;
    boolean readOnly;

    public NamedQueryAnnotation(SourceModelBuildingContext modelContext) {
        this.resultClass = Void.TYPE;
        this.flushMode = FlushModeType.PERSISTENCE_CONTEXT;
        this.flush = QueryFlushMode.DEFAULT;
        this.cacheable = false;
        this.cacheRegion = "";
        this.fetchSize = -1;
        this.timeout = -1;
        this.comment = "";
        this.cacheStoreMode = CacheStoreMode.USE;
        this.cacheRetrieveMode = CacheRetrieveMode.USE;
        this.readOnly = false;
    }

    public NamedQueryAnnotation(NamedQuery annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.query = annotation.query();
        this.resultClass = annotation.resultClass();
        this.flushMode = annotation.flushMode();
        this.flush = annotation.flush();
        this.cacheable = annotation.cacheable();
        this.cacheRegion = annotation.cacheRegion();
        this.fetchSize = annotation.fetchSize();
        this.timeout = annotation.timeout();
        this.comment = annotation.comment();
        this.cacheStoreMode = annotation.cacheStoreMode();
        this.cacheRetrieveMode = annotation.cacheRetrieveMode();
        if (annotation.cacheMode() != CacheMode.NORMAL) {
            this.cacheStoreMode = annotation.cacheMode().getJpaStoreMode();
            this.cacheRetrieveMode = annotation.cacheMode().getJpaRetrieveMode();
        }
        this.readOnly = annotation.readOnly();
    }

    public NamedQueryAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.query = (String)attributeValues.get("query");
        this.resultClass = (Class)attributeValues.get("resultClass");
        this.flushMode = (FlushModeType)((Object)attributeValues.get("flushMode"));
        this.flush = (QueryFlushMode)((Object)attributeValues.get("flush"));
        this.cacheable = (Boolean)attributeValues.get("cacheable");
        this.cacheRegion = (String)attributeValues.get("cacheRegion");
        this.fetchSize = (Integer)attributeValues.get("fetchSize");
        this.timeout = (Integer)attributeValues.get("timeout");
        this.comment = (String)attributeValues.get("comment");
        this.cacheStoreMode = (CacheStoreMode)attributeValues.get("cacheStoreMode");
        this.cacheRetrieveMode = (CacheRetrieveMode)attributeValues.get("cacheRetrieveMode");
        this.readOnly = (Boolean)attributeValues.get("readOnly");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NamedQuery.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String query() {
        return this.query;
    }

    public void query(String value) {
        this.query = value;
    }

    @Override
    public Class<?> resultClass() {
        return this.resultClass;
    }

    public void resultClass(Class<?> value) {
        this.resultClass = value;
    }

    @Override
    public QueryFlushMode flush() {
        return this.flush;
    }

    public void flush(QueryFlushMode value) {
        this.flush = value;
    }

    @Override
    public FlushModeType flushMode() {
        return this.flushMode;
    }

    public void flushMode(FlushModeType value) {
        this.flushMode = value;
    }

    @Override
    public boolean cacheable() {
        return this.cacheable;
    }

    public void cacheable(boolean value) {
        this.cacheable = value;
    }

    @Override
    public String cacheRegion() {
        return this.cacheRegion;
    }

    public void cacheRegion(String value) {
        this.cacheRegion = value;
    }

    @Override
    public int fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize(int value) {
        this.fetchSize = value;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    public void timeout(int value) {
        this.timeout = value;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public void comment(String value) {
        this.comment = value;
    }

    @Override
    public CacheStoreMode cacheStoreMode() {
        return this.cacheStoreMode;
    }

    public void cacheStoreMode(CacheStoreMode value) {
        this.cacheStoreMode = value;
    }

    @Override
    public CacheRetrieveMode cacheRetrieveMode() {
        return this.cacheRetrieveMode;
    }

    public void cacheRetrieveMode(CacheRetrieveMode value) {
        this.cacheRetrieveMode = value;
    }

    @Override
    public CacheMode cacheMode() {
        return CacheMode.fromJpaModes(this.cacheRetrieveMode, this.cacheStoreMode);
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    public void readOnly(boolean value) {
        this.readOnly = value;
    }

    public void apply(JaxbNamedHqlQueryImpl jaxbNamedQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbNamedQuery.getName());
        this.query(jaxbNamedQuery.getQuery());
        if (jaxbNamedQuery.isCacheable() != null) {
            boolean cacheable = jaxbNamedQuery.isCacheable();
            this.cacheable(cacheable);
            if (cacheable) {
                if (StringHelper.isNotEmpty(jaxbNamedQuery.getCacheRegion())) {
                    this.cacheRegion(jaxbNamedQuery.getCacheRegion());
                }
                if (jaxbNamedQuery.getCacheMode() != null) {
                    if (jaxbNamedQuery.getCacheMode().isGetEnabled()) {
                        this.cacheRetrieveMode(CacheRetrieveMode.USE);
                    }
                    if (jaxbNamedQuery.getCacheMode().isPutEnabled()) {
                        this.cacheStoreMode(CacheStoreMode.USE);
                    }
                }
            }
        }
        if (jaxbNamedQuery.getFetchSize() != null) {
            this.fetchSize(jaxbNamedQuery.getFetchSize());
        }
        if (jaxbNamedQuery.getTimeout() != null) {
            this.timeout(jaxbNamedQuery.getTimeout());
        }
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getComment())) {
            this.comment(jaxbNamedQuery.getComment());
        }
        if (jaxbNamedQuery.isReadOnly() != null) {
            this.readOnly(jaxbNamedQuery.isReadOnly());
        }
        if (jaxbNamedQuery.getFlushMode() != null) {
            this.flushMode(QueryProcessing.interpretFlushMode(jaxbNamedQuery.getFlushMode()));
        }
    }
}

