/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CheckConstraint;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinTableImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.CommonTableDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class JoinTableJpaAnnotation
implements JoinTable,
CommonTableDetails {
    private String name;
    private String catalog;
    private String schema;
    private JoinColumn[] joinColumns;
    private JoinColumn[] inverseJoinColumns;
    private ForeignKey foreignKey;
    private ForeignKey inverseForeignKey;
    private UniqueConstraint[] uniqueConstraints;
    private Index[] indexes;
    private CheckConstraint[] check;
    private String comment;
    private String options;

    public JoinTableJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.catalog = "";
        this.schema = "";
        this.joinColumns = new JoinColumn[0];
        this.inverseJoinColumns = new JoinColumn[0];
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
        this.inverseForeignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
        this.uniqueConstraints = new UniqueConstraint[0];
        this.indexes = new Index[0];
        this.check = new CheckConstraint[0];
        this.comment = "";
        this.options = "";
    }

    public JoinTableJpaAnnotation(JoinTable annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.catalog = annotation.catalog();
        this.schema = annotation.schema();
        this.joinColumns = (JoinColumn[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "joinColumns", modelContext);
        this.inverseJoinColumns = (JoinColumn[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "inverseJoinColumns", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "foreignKey", modelContext);
        this.inverseForeignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "inverseForeignKey", modelContext);
        this.uniqueConstraints = (UniqueConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "uniqueConstraints", modelContext);
        this.indexes = (Index[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "indexes", modelContext);
        this.check = (CheckConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_TABLE, "check", modelContext);
        this.comment = annotation.comment();
        this.options = annotation.options();
    }

    public JoinTableJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.catalog = (String)attributeValues.get("catalog");
        this.schema = (String)attributeValues.get("schema");
        this.joinColumns = (JoinColumn[])attributeValues.get("joinColumns");
        this.inverseJoinColumns = (JoinColumn[])attributeValues.get("inverseJoinColumns");
        this.foreignKey = (ForeignKey)attributeValues.get("foreignKey");
        this.inverseForeignKey = (ForeignKey)attributeValues.get("inverseForeignKey");
        this.uniqueConstraints = (UniqueConstraint[])attributeValues.get("uniqueConstraints");
        this.indexes = (Index[])attributeValues.get("indexes");
        this.check = (CheckConstraint[])attributeValues.get("check");
        this.comment = (String)attributeValues.get("comment");
        this.options = (String)attributeValues.get("options");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JoinTable.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public void catalog(String value) {
        this.catalog = value;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public void schema(String value) {
        this.schema = value;
    }

    public JoinColumn[] joinColumns() {
        return this.joinColumns;
    }

    public void joinColumns(JoinColumn[] value) {
        this.joinColumns = value;
    }

    public JoinColumn[] inverseJoinColumns() {
        return this.inverseJoinColumns;
    }

    public void inverseJoinColumns(JoinColumn[] value) {
        this.inverseJoinColumns = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    public ForeignKey inverseForeignKey() {
        return this.inverseForeignKey;
    }

    public void inverseForeignKey(ForeignKey value) {
        this.inverseForeignKey = value;
    }

    @Override
    public UniqueConstraint[] uniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public void uniqueConstraints(UniqueConstraint[] value) {
        this.uniqueConstraints = value;
    }

    @Override
    public Index[] indexes() {
        return this.indexes;
    }

    @Override
    public void indexes(Index[] value) {
        this.indexes = value;
    }

    public CheckConstraint[] check() {
        return this.check;
    }

    public void check(CheckConstraint[] value) {
        this.check = value;
    }

    public String comment() {
        return this.comment;
    }

    public void comment(String value) {
        this.comment = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public void apply(JaxbJoinTableImpl jaxbJoinTable, XmlDocumentContext xmlDocumentContext) {
        List<JaxbJoinColumnImpl> inverseJoinColumns;
        XmlAnnotationHelper.applyOptionalString(jaxbJoinTable.getName(), this::name);
        XmlAnnotationHelper.applyCatalog(jaxbJoinTable, this, xmlDocumentContext);
        XmlAnnotationHelper.applySchema(jaxbJoinTable, this, xmlDocumentContext);
        XmlAnnotationHelper.applyOptionalString(jaxbJoinTable.getComment(), this::comment);
        XmlAnnotationHelper.applyOptionalString(jaxbJoinTable.getOptions(), this::options);
        this.check(XmlAnnotationHelper.collectCheckConstraints(jaxbJoinTable.getCheckConstraints(), xmlDocumentContext));
        this.indexes(XmlAnnotationHelper.collectIndexes(jaxbJoinTable.getIndexes(), xmlDocumentContext));
        this.uniqueConstraints(XmlAnnotationHelper.collectUniqueConstraints(jaxbJoinTable.getUniqueConstraints(), xmlDocumentContext));
        List<JaxbJoinColumnImpl> joinColumns = jaxbJoinTable.getJoinColumn();
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            this.joinColumns(JoinColumnProcessing.transformJoinColumnList(joinColumns, xmlDocumentContext));
        }
        if (CollectionHelper.isNotEmpty(inverseJoinColumns = jaxbJoinTable.getInverseJoinColumn())) {
            this.inverseJoinColumns(JoinColumnProcessing.transformJoinColumnList(inverseJoinColumns, xmlDocumentContext));
        }
        if (jaxbJoinTable.getForeignKey() != null) {
            this.foreignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbJoinTable.getForeignKey(), xmlDocumentContext));
        }
        if (jaxbJoinTable.getInverseForeignKey() != null) {
            this.inverseForeignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbJoinTable.getInverseForeignKey(), xmlDocumentContext));
        }
    }
}

