/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import java.util.UUID;
import org.hibernate.boot.model.internal.AbstractEntityIdGeneratorResolver;
import org.hibernate.boot.model.internal.GeneratorAnnotationHelper;
import org.hibernate.boot.models.annotations.internal.SequenceGeneratorJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TableGeneratorJpaAnnotation;
import org.hibernate.boot.models.spi.GenericGeneratorRegistration;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.spi.SequenceGeneratorRegistration;
import org.hibernate.boot.models.spi.TableGeneratorRegistration;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.MemberDetails;

public class StrictIdGeneratorResolverSecondPass
extends AbstractEntityIdGeneratorResolver {
    public StrictIdGeneratorResolverSecondPass(PersistentClass entityMapping, SimpleValue idValue, MemberDetails idMember, GeneratedValue generatedValue, MetadataBuildingContext buildingContext) {
        super(entityMapping, idValue, idMember, generatedValue, buildingContext);
    }

    @Override
    protected void handleUnnamedSequenceGenerator() {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        SequenceGeneratorRegistration globalMatch = metadataCollector.getGlobalRegistrations().getSequenceGeneratorRegistrations().get(this.entityMapping.getJpaEntityName());
        if (globalMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(this.entityMapping.getJpaEntityName(), globalMatch.configuration(), this.idValue, this.idMember, this.buildingContext);
            return;
        }
        GeneratorAnnotationHelper.handleSequenceGenerator(this.entityMapping.getJpaEntityName(), new SequenceGeneratorJpaAnnotation(metadataCollector.getSourceModelBuildingContext()), this.idValue, this.idMember, this.buildingContext);
    }

    @Override
    protected void handleNamedSequenceGenerator() {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        SequenceGeneratorRegistration globalMatch = metadataCollector.getGlobalRegistrations().getSequenceGeneratorRegistrations().get(this.generatedValue.generator());
        if (globalMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(this.generatedValue.generator(), globalMatch.configuration(), this.idValue, this.idMember, this.buildingContext);
            return;
        }
        GeneratorAnnotationHelper.handleSequenceGenerator(this.generatedValue.generator(), new SequenceGeneratorJpaAnnotation(this.generatedValue.generator(), metadataCollector.getSourceModelBuildingContext()), this.idValue, this.idMember, this.buildingContext);
    }

    @Override
    protected void handleUnnamedTableGenerator() {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        TableGeneratorRegistration globalMatch = metadataCollector.getGlobalRegistrations().getTableGeneratorRegistrations().get(this.entityMapping.getJpaEntityName());
        if (globalMatch != null) {
            GeneratorAnnotationHelper.handleTableGenerator(this.entityMapping.getJpaEntityName(), globalMatch.configuration(), this.entityMapping, this.idValue, this.idMember, this.buildingContext);
            return;
        }
        GeneratorAnnotationHelper.handleTableGenerator(this.entityMapping.getJpaEntityName(), new TableGeneratorJpaAnnotation(metadataCollector.getSourceModelBuildingContext()), this.entityMapping, this.idValue, this.idMember, this.buildingContext);
    }

    @Override
    protected void handleNamedTableGenerator() {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        TableGeneratorRegistration globalMatch = metadataCollector.getGlobalRegistrations().getTableGeneratorRegistrations().get(this.generatedValue.generator());
        if (globalMatch != null) {
            GeneratorAnnotationHelper.handleTableGenerator(this.generatedValue.generator(), globalMatch.configuration(), this.entityMapping, this.idValue, this.idMember, this.buildingContext);
            return;
        }
        GeneratorAnnotationHelper.handleTableGenerator(this.generatedValue.generator(), new TableGeneratorJpaAnnotation(this.generatedValue.generator(), metadataCollector.getSourceModelBuildingContext()), this.entityMapping, this.idValue, this.idMember, this.buildingContext);
    }

    @Override
    protected void handleUnnamedAutoGenerator() {
        this.handleAutoGenerator(this.entityMapping.getJpaEntityName());
    }

    @Override
    protected void handleNamedAutoGenerator() {
        this.handleAutoGenerator(this.generatedValue.generator());
    }

    private void handleAutoGenerator(String globalRegistrationName) {
        InFlightMetadataCollector metadataCollector = this.buildingContext.getMetadataCollector();
        GlobalRegistrations globalRegistrations = metadataCollector.getGlobalRegistrations();
        SequenceGeneratorRegistration globalSequenceMatch = globalRegistrations.getSequenceGeneratorRegistrations().get(globalRegistrationName);
        if (globalSequenceMatch != null) {
            GeneratorAnnotationHelper.handleSequenceGenerator(globalRegistrationName, globalSequenceMatch.configuration(), this.idValue, this.idMember, this.buildingContext);
            return;
        }
        TableGeneratorRegistration globalTableMatch = globalRegistrations.getTableGeneratorRegistrations().get(globalRegistrationName);
        if (globalTableMatch != null) {
            GeneratorAnnotationHelper.handleTableGenerator(globalRegistrationName, globalTableMatch.configuration(), this.entityMapping, this.idValue, this.idMember, this.buildingContext);
            return;
        }
        GenericGeneratorRegistration globalGenericMatch = globalRegistrations.getGenericGeneratorRegistrations().get(globalRegistrationName);
        if (globalGenericMatch != null) {
            GeneratorAnnotationHelper.handleGenericGenerator(globalRegistrationName, globalGenericMatch.configuration(), this.entityMapping, this.idValue, this.buildingContext);
            return;
        }
        if (this.handleAsMetaAnnotated()) {
            return;
        }
        if (this.idMember.getType().isImplementor(UUID.class) || this.idMember.getType().isImplementor(String.class)) {
            GeneratorAnnotationHelper.handleUuidStrategy(this.idValue, this.idMember, this.buildingContext);
            return;
        }
        if (this.handleAsLegacyGenerator()) {
            return;
        }
        GeneratorAnnotationHelper.handleSequenceGenerator(globalRegistrationName, new SequenceGeneratorJpaAnnotation(this.generatedValue.generator(), metadataCollector.getSourceModelBuildingContext()), this.idValue, this.idMember, this.buildingContext);
    }
}

