/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.GeneratorAnnotationHelper;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.internal.GeneratorStrategies;
import org.hibernate.boot.model.internal.IdGeneratorResolver;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.SequenceGeneratorJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TableGeneratorJpaAnnotation;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.spi.SequenceGeneratorRegistration;
import org.hibernate.boot.models.spi.TableGeneratorRegistration;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.generator.Generator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.resource.beans.container.spi.BeanContainer;

public class IdBagIdGeneratorResolverSecondPass
implements IdGeneratorResolver {
    private final PersistentClass entityMapping = null;
    private final SimpleValue idValue;
    private final MemberDetails idBagMember;
    private final String generatorType;
    private final String generatorName;
    private final MetadataBuildingContext buildingContext;
    private final Map<String, String> configuration;

    public IdBagIdGeneratorResolverSecondPass(IdentifierBag idBagMapping, SimpleValue idValue, MemberDetails idBagMember, String generatorType, String generatorName, MetadataBuildingContext buildingContext) {
        this.idValue = idValue;
        this.idBagMember = idBagMember;
        this.generatorType = generatorType;
        this.generatorName = generatorName;
        this.buildingContext = buildingContext;
        this.configuration = new HashMap<String, String>();
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> idGeneratorDefinitionMap) throws MappingException {
        GeneratedValue generatedValue = (GeneratedValue)this.idBagMember.getDirectAnnotationUsage(GeneratedValue.class);
        switch (generatedValue.strategy()) {
            case UUID: {
                GeneratorAnnotationHelper.handleUuidStrategy(this.idValue, this.idBagMember, this.buildingContext);
                break;
            }
            case IDENTITY: {
                GeneratorAnnotationHelper.handleIdentityStrategy(this.idValue);
                break;
            }
            case SEQUENCE: {
                this.handleSequenceStrategy(this.generatorName, this.idValue, this.idBagMember, this.buildingContext);
                break;
            }
            case TABLE: {
                this.handleTableStrategy(this.generatorName, this.entityMapping, this.idValue, this.idBagMember, this.buildingContext);
                break;
            }
            case AUTO: {
                this.handleAutoStrategy(this.generatorName, this.idValue, this.idBagMember, this.buildingContext);
            }
        }
    }

    private void handleTableStrategy(String generatorName, PersistentClass entityMapping, SimpleValue idValue, MemberDetails idBagMember, MetadataBuildingContext buildingContext) {
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        GlobalRegistrations globalRegistrations = metadataCollector.getGlobalRegistrations();
        TableGeneratorRegistration globalTableGenerator = globalRegistrations.getTableGeneratorRegistrations().get(generatorName);
        if (globalTableGenerator != null) {
            IdBagIdGeneratorResolverSecondPass.handleTableGenerator(generatorName, globalTableGenerator.configuration(), idValue, idBagMember, buildingContext);
            return;
        }
        TableGenerator localizedTableMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.TABLE_GENERATOR, idBagMember, TableGenerator::name, generatorName, buildingContext);
        if (localizedTableMatch != null) {
            IdBagIdGeneratorResolverSecondPass.handleTableGenerator(generatorName, localizedTableMatch, idValue, idBagMember, buildingContext);
            return;
        }
        GeneratorAnnotationHelper.handleTableGenerator(generatorName, new TableGeneratorJpaAnnotation(metadataCollector.getSourceModelBuildingContext()), entityMapping, idValue, idBagMember, buildingContext);
    }

    private void handleSequenceStrategy(String generatorName, SimpleValue idValue, MemberDetails idBagMember, MetadataBuildingContext buildingContext) {
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        GlobalRegistrations globalRegistrations = metadataCollector.getGlobalRegistrations();
        SequenceGeneratorRegistration globalSequenceGenerator = globalRegistrations.getSequenceGeneratorRegistrations().get(generatorName);
        if (globalSequenceGenerator != null) {
            IdBagIdGeneratorResolverSecondPass.handleSequenceGenerator(generatorName, globalSequenceGenerator.configuration(), idValue, idBagMember, buildingContext);
            return;
        }
        SequenceGenerator localizedSequencedMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.SEQUENCE_GENERATOR, idBagMember, SequenceGenerator::name, generatorName, buildingContext);
        if (localizedSequencedMatch != null) {
            IdBagIdGeneratorResolverSecondPass.handleSequenceGenerator(generatorName, localizedSequencedMatch, idValue, idBagMember, buildingContext);
            return;
        }
        IdBagIdGeneratorResolverSecondPass.handleSequenceGenerator(generatorName, new SequenceGeneratorJpaAnnotation(metadataCollector.getSourceModelBuildingContext()), idValue, idBagMember, buildingContext);
    }

    private void handleAutoStrategy(String generatorName, SimpleValue idValue, MemberDetails idBagMember, MetadataBuildingContext buildingContext) {
        GlobalRegistrations globalRegistrations = buildingContext.getMetadataCollector().getGlobalRegistrations();
        SequenceGeneratorRegistration globalSequenceGenerator = globalRegistrations.getSequenceGeneratorRegistrations().get(generatorName);
        if (globalSequenceGenerator != null) {
            IdBagIdGeneratorResolverSecondPass.handleSequenceGenerator(generatorName, globalSequenceGenerator.configuration(), idValue, idBagMember, buildingContext);
            return;
        }
        TableGeneratorRegistration globalTableGenerator = globalRegistrations.getTableGeneratorRegistrations().get(generatorName);
        if (globalTableGenerator != null) {
            IdBagIdGeneratorResolverSecondPass.handleTableGenerator(generatorName, globalTableGenerator.configuration(), idValue, idBagMember, buildingContext);
            return;
        }
        Class<? extends Generator> legacyNamedGenerator = GeneratorStrategies.mapLegacyNamedGenerator(generatorName, idValue);
        if (legacyNamedGenerator != null) {
            if (idValue.getColumnSpan() == 1) {
                this.configuration.put("target_column", idValue.getColumns().get(0).getName());
            }
            GeneratorBinder.createGeneratorFrom(new IdentifierGeneratorDefinition(generatorName, legacyNamedGenerator.getName(), this.configuration), idValue, this.configuration, buildingContext);
            return;
        }
        SequenceGenerator localizedSequencedMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.SEQUENCE_GENERATOR, idBagMember, SequenceGenerator::name, generatorName, buildingContext);
        if (localizedSequencedMatch != null) {
            IdBagIdGeneratorResolverSecondPass.handleSequenceGenerator(generatorName, localizedSequencedMatch, idValue, idBagMember, buildingContext);
            return;
        }
        TableGenerator localizedTableMatch = GeneratorAnnotationHelper.findLocalizedMatch(JpaAnnotations.TABLE_GENERATOR, idBagMember, TableGenerator::name, generatorName, buildingContext);
        if (localizedTableMatch != null) {
            IdBagIdGeneratorResolverSecondPass.handleTableGenerator(generatorName, localizedTableMatch, idValue, idBagMember, buildingContext);
            return;
        }
        GeneratorBinder.makeIdGenerator(idValue, idBagMember, this.generatorType, generatorName, buildingContext, null);
    }

    public static void handleSequenceGenerator(String nameFromGeneratedValue, SequenceGenerator generatorAnnotation, SimpleValue idValue, MemberDetails idBagMember, MetadataBuildingContext buildingContext) {
        idValue.setCustomIdGeneratorCreator(creationContext -> {
            BeanContainer beanContainer = GeneratorBinder.beanContainer(buildingContext);
            SequenceStyleGenerator identifierGenerator = GeneratorBinder.instantiateGenerator(beanContainer, SequenceStyleGenerator.class);
            GeneratorAnnotationHelper.prepareForUse(identifierGenerator, generatorAnnotation, idBagMember, properties -> {
                if (generatorAnnotation != null) {
                    properties.put("GENERATOR_NAME", generatorAnnotation.name());
                } else if (nameFromGeneratedValue != null) {
                    properties.put("GENERATOR_NAME", nameFromGeneratedValue);
                }
                properties.put("increment_size", (Object)GeneratorParameters.fallbackAllocationSize((Annotation)generatorAnnotation, buildingContext));
            }, generatorAnnotation == null ? null : (a, properties) -> SequenceStyleGenerator.applyConfiguration(generatorAnnotation, properties::put), creationContext);
            return identifierGenerator;
        });
    }

    public static void handleTableGenerator(String nameFromGeneratedValue, TableGenerator generatorAnnotation, SimpleValue idValue, MemberDetails idBagMember, MetadataBuildingContext buildingContext) {
        idValue.setCustomIdGeneratorCreator(creationContext -> {
            BeanContainer beanContainer = GeneratorBinder.beanContainer(buildingContext);
            org.hibernate.id.enhanced.TableGenerator identifierGenerator = GeneratorBinder.instantiateGenerator(beanContainer, org.hibernate.id.enhanced.TableGenerator.class);
            GeneratorAnnotationHelper.prepareForUse(identifierGenerator, generatorAnnotation, idBagMember, properties -> {
                if (generatorAnnotation != null) {
                    properties.put("GENERATOR_NAME", generatorAnnotation.name());
                } else if (nameFromGeneratedValue != null) {
                    properties.put("GENERATOR_NAME", nameFromGeneratedValue);
                }
                properties.put("increment_size", (Object)GeneratorParameters.fallbackAllocationSize((Annotation)generatorAnnotation, buildingContext));
            }, generatorAnnotation == null ? null : (a, properties) -> org.hibernate.id.enhanced.TableGenerator.applyConfiguration(generatorAnnotation, properties::put), creationContext);
            return identifierGenerator;
        });
    }
}

