/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.InstantiationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AnnotationHelper;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.internal.GeneratorStrategies;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.StrictIdGeneratorResolverSecondPass;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.models.spi.GlobalRegistrar;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.Assigned;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.uuid.UuidValueGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.internal.Helper;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;

public class GeneratorBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(GeneratorBinder.class);
    public static final String ASSIGNED_GENERATOR_NAME = "assigned";
    public static final GeneratorCreator ASSIGNED_IDENTIFIER_GENERATOR_CREATOR = new GeneratorCreator(){

        @Override
        public Generator createGenerator(GeneratorCreationContext context) {
            return new Assigned();
        }

        @Override
        public boolean isAssigned() {
            return true;
        }
    };

    public static void makeIdGenerator(SimpleValue identifierValue, MemberDetails idAttributeMember, String generatorType, String generatorName, MetadataBuildingContext context, Map<String, ? extends IdentifierGeneratorDefinition> localGenerators) {
        String strategyGeneratorClassName;
        GenerationType strategy;
        IdentifierGeneratorDefinition impliedGenerator;
        GeneratedValue generatedValue;
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("GENERATOR_NAME", generatorName);
        configuration.put("target_table", identifierValue.getTable().getName());
        if (identifierValue.getColumnSpan() == 1) {
            configuration.put("target_column", identifierValue.getColumns().get(0).getName());
        }
        if (generatorName.isEmpty() && (generatedValue = (GeneratedValue)idAttributeMember.getDirectAnnotationUsage(GeneratedValue.class)) != null && (impliedGenerator = GeneratorBinder.determineImpliedGenerator(strategy = generatedValue.strategy(), strategyGeneratorClassName = GeneratorBinder.correspondingGeneratorName(strategy), localGenerators)) != null) {
            configuration.putAll(impliedGenerator.getParameters());
            BeanContainer beanContainer = GeneratorBinder.beanContainer(context);
            identifierValue.setCustomIdGeneratorCreator(creationContext -> {
                Generator identifierGenerator = GeneratorBinder.instantiateGenerator(beanContainer, GeneratorStrategies.generatorClass(strategyGeneratorClassName, identifierValue));
                GeneratorBinder.callConfigure(creationContext, identifierGenerator, configuration, identifierValue);
                if (identifierGenerator instanceof IdentityGenerator) {
                    identifierValue.setColumnToIdentity();
                }
                return identifierGenerator;
            });
            return;
        }
        String generatorStrategy = GeneratorBinder.determineStrategy(idAttributeMember, generatorType, generatorName, context, localGenerators, configuration);
        GeneratorBinder.setGeneratorCreator(identifierValue, configuration, generatorStrategy, context);
    }

    private static IdentifierGeneratorDefinition determineImpliedGenerator(GenerationType strategy, String strategyGeneratorClassName, Map<String, ? extends IdentifierGeneratorDefinition> localGenerators) {
        if (localGenerators == null) {
            return null;
        }
        if (localGenerators.size() == 1) {
            IdentifierGeneratorDefinition generatorDefinition = localGenerators.entrySet().iterator().next().getValue();
            if (strategy == GenerationType.AUTO || GeneratorBinder.isImpliedGenerator(strategy, strategyGeneratorClassName, generatorDefinition)) {
                return generatorDefinition;
            }
        }
        IdentifierGeneratorDefinition matching = null;
        for (Map.Entry<String, ? extends IdentifierGeneratorDefinition> localGeneratorEntry : localGenerators.entrySet()) {
            if (!GeneratorBinder.isImpliedGenerator(strategy, strategyGeneratorClassName, localGeneratorEntry.getValue())) continue;
            if (matching != null) {
                return null;
            }
            matching = localGeneratorEntry.getValue();
        }
        return matching;
    }

    private static boolean isImpliedGenerator(GenerationType strategy, String strategyGeneratorClassName, IdentifierGeneratorDefinition generatorDefinition) {
        return generatorDefinition.getStrategy().equals(strategyGeneratorClassName);
    }

    private static String correspondingGeneratorName(GenerationType strategy) {
        return switch (strategy) {
            case GenerationType.UUID -> UuidValueGenerator.class.getName();
            case GenerationType.TABLE -> org.hibernate.id.enhanced.TableGenerator.class.getName();
            case GenerationType.IDENTITY -> null;
            default -> SequenceStyleGenerator.class.getName();
        };
    }

    private static String determineStrategy(MemberDetails idAttributeMember, String generatorType, String generatorName, MetadataBuildingContext context, Map<String, ? extends IdentifierGeneratorDefinition> localGenerators, Map<String, Object> configuration) {
        if (!generatorName.isEmpty()) {
            IdentifierGeneratorDefinition definition = GeneratorBinder.makeIdentifierGeneratorDefinition(generatorName, idAttributeMember, localGenerators, context);
            if (definition == null) {
                throw new AnnotationException("No id generator was declared with the name '" + generatorName + "' specified by '@GeneratedValue' (define a named generator using '@SequenceGenerator', '@TableGenerator', or '@GenericGenerator')");
            }
            String generatorStrategy = generatorType == null || !definition.getStrategy().equals("identity") ? definition.getStrategy() : generatorType;
            configuration.putAll(definition.getParameters());
            return generatorStrategy;
        }
        return generatorType;
    }

    private static IdentifierGeneratorDefinition makeIdentifierGeneratorDefinition(String name, MemberDetails idAttributeMember, Map<String, ? extends IdentifierGeneratorDefinition> localGenerators, MetadataBuildingContext buildingContext) {
        IdentifierGeneratorDefinition result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        IdentifierGeneratorDefinition globalDefinition = buildingContext.getMetadataCollector().getIdentifierGenerator(name);
        if (globalDefinition != null) {
            return globalDefinition;
        }
        LOG.debugf("Could not resolve explicit IdentifierGeneratorDefinition - using implicit interpretation (%s)", name);
        GeneratedValue generatedValue = (GeneratedValue)idAttributeMember.getDirectAnnotationUsage(GeneratedValue.class);
        if (generatedValue == null) {
            throw new AssertionFailure("No @GeneratedValue annotation");
        }
        return IdentifierGeneratorDefinition.createImplicit(name, idAttributeMember.getType(), generatedValue.generator(), GeneratorBinder.interpretGenerationType(generatedValue));
    }

    private static GenerationType interpretGenerationType(GeneratedValue generatedValueAnn) {
        GenerationType strategy = generatedValueAnn.strategy();
        return strategy == null ? GenerationType.AUTO : strategy;
    }

    public static void visitIdGeneratorDefinitions(AnnotationTarget annotatedElement, Consumer<IdentifierGeneratorDefinition> consumer, MetadataBuildingContext context) {
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        SourceModelBuildingContext sourceModelContext = metadataCollector.getSourceModelBuildingContext();
        annotatedElement.forEachAnnotationUsage(TableGenerator.class, sourceModelContext, usage -> {
            IdentifierGeneratorDefinition idGenerator = GeneratorBinder.buildTableIdGenerator(usage);
            consumer.accept(idGenerator);
        });
        annotatedElement.forEachAnnotationUsage(SequenceGenerator.class, sourceModelContext, usage -> {
            IdentifierGeneratorDefinition idGenerator = GeneratorBinder.buildSequenceIdGenerator(usage);
            consumer.accept(idGenerator);
        });
        annotatedElement.forEachAnnotationUsage(GenericGenerator.class, sourceModelContext, usage -> {
            IdentifierGeneratorDefinition idGenerator = GeneratorBinder.buildIdGenerator(usage);
            consumer.accept(idGenerator);
        });
    }

    public static void registerGlobalGenerators(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        if (!context.getBootstrapContext().getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
            return;
        }
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        GeneratorBinder.visitIdGeneratorDefinitions(annotatedElement, definition -> {
            if (!definition.getName().isEmpty()) {
                metadataCollector.addIdentifierGenerator((IdentifierGeneratorDefinition)definition);
            }
        }, context);
    }

    private static IdentifierGeneratorDefinition buildIdGenerator(GenericGenerator generatorAnnotation) {
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        definitionBuilder.setName(generatorAnnotation.name());
        Class<? extends Generator> generatorClass = generatorAnnotation.type();
        String strategy = generatorClass.equals(Generator.class) ? generatorAnnotation.strategy() : generatorClass.getName();
        definitionBuilder.setStrategy(strategy);
        definitionBuilder.addParams(AnnotationHelper.extractParameterMap(generatorAnnotation.parameters()));
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Added generator with name: {0}, strategy: {0}", definitionBuilder.getName(), definitionBuilder.getStrategy());
        }
        return definitionBuilder.build();
    }

    private static IdentifierGeneratorDefinition buildSequenceIdGenerator(SequenceGenerator generatorAnnotation) {
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        GeneratorParameters.interpretSequenceGenerator(generatorAnnotation, definitionBuilder);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Add sequence generator with name: {0}", definitionBuilder.getName());
        }
        return definitionBuilder.build();
    }

    private static IdentifierGeneratorDefinition buildTableIdGenerator(TableGenerator generatorAnnotation) {
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        GeneratorParameters.interpretTableGenerator(generatorAnnotation, definitionBuilder);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Add sequence generator with name: {0}", definitionBuilder.getName());
        }
        return definitionBuilder.build();
    }

    private static void checkGeneratorClass(Class<? extends Generator> generatorClass) {
        if (!BeforeExecutionGenerator.class.isAssignableFrom(generatorClass) && !OnExecutionGenerator.class.isAssignableFrom(generatorClass)) {
            throw new MappingException("Generator class '" + generatorClass.getName() + "' must implement either 'BeforeExecutionGenerator' or 'OnExecutionGenerator'");
        }
    }

    private static void checkGeneratorInterfaces(Class<? extends Generator> generatorClass) {
        if (IdentifierGenerator.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'IdentifierGenerator' and may not be used with '@ValueGenerationType'");
        }
        if (ExportableProducer.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'ExportableProducer' and may not be used with '@ValueGenerationType'");
        }
    }

    private static GeneratorCreator generatorCreator(MemberDetails memberDetails, Annotation annotation, BeanContainer beanContainer) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ValueGenerationType generatorAnnotation = annotationType.getAnnotation(ValueGenerationType.class);
        assert (generatorAnnotation != null);
        Class<? extends Generator> generatorClass = generatorAnnotation.generatedBy();
        GeneratorBinder.checkGeneratorClass(generatorClass);
        GeneratorBinder.checkGeneratorInterfaces(generatorClass);
        return creationContext -> {
            Generator generator = GeneratorBinder.instantiateGenerator(annotation, beanContainer, creationContext, generatorClass, memberDetails, annotationType);
            GeneratorBinder.callInitialize(annotation, memberDetails, creationContext, generator);
            GeneratorBinder.checkVersionGenerationAlways(memberDetails, generator);
            return generator;
        };
    }

    private static GeneratorCreator identifierGeneratorCreator(MemberDetails idAttributeMember, Annotation annotation, SimpleValue identifierValue, BeanContainer beanContainer) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        IdGeneratorType idGeneratorAnnotation = annotationType.getAnnotation(IdGeneratorType.class);
        assert (idGeneratorAnnotation != null);
        Class<? extends Generator> generatorClass = idGeneratorAnnotation.value();
        GeneratorBinder.checkGeneratorClass(generatorClass);
        return creationContext -> {
            Generator generator = GeneratorBinder.instantiateGenerator(annotation, beanContainer, creationContext, generatorClass, idAttributeMember, annotationType);
            GeneratorBinder.callInitialize(annotation, idAttributeMember, creationContext, generator);
            GeneratorBinder.callConfigure(creationContext, generator, Collections.emptyMap(), identifierValue);
            GeneratorBinder.checkIdGeneratorTiming(annotationType, generator);
            return generator;
        };
    }

    private static Generator instantiateGenerator(Annotation annotation, BeanContainer beanContainer, GeneratorCreationContext creationContext, Class<? extends Generator> generatorClass, MemberDetails memberDetails, Class<? extends Annotation> annotationType) {
        if (beanContainer != null) {
            return GeneratorBinder.instantiateGeneratorAsBean(annotation, beanContainer, creationContext, generatorClass, memberDetails, annotationType);
        }
        return GeneratorBinder.instantiateGenerator(annotation, memberDetails, annotationType, creationContext, generatorClass);
    }

    private static Generator instantiateGeneratorAsBean(final Annotation annotation, BeanContainer beanContainer, final GeneratorCreationContext creationContext, final Class<? extends Generator> generatorClass, final MemberDetails memberDetails, final Class<? extends Annotation> annotationType) {
        return beanContainer.getBean(generatorClass, new BeanContainer.LifecycleOptions(){

            @Override
            public boolean canUseCachedReferences() {
                return false;
            }

            @Override
            public boolean useJpaCompliantCreation() {
                return true;
            }
        }, new BeanInstanceProducer(){

            @Override
            public <B> B produceBeanInstance(Class<B> beanType) {
                return (B)GeneratorBinder.instantiateGenerator(annotation, memberDetails, annotationType, creationContext, generatorClass);
            }

            @Override
            public <B> B produceBeanInstance(String name, Class<B> beanType) {
                return this.produceBeanInstance(beanType);
            }
        }).getBeanInstance();
    }

    private static <T extends Generator> T instantiateGeneratorAsBean(BeanContainer beanContainer, final Class<T> generatorClass) {
        return (T)((Generator)beanContainer.getBean(generatorClass, new BeanContainer.LifecycleOptions(){

            @Override
            public boolean canUseCachedReferences() {
                return false;
            }

            @Override
            public boolean useJpaCompliantCreation() {
                return true;
            }
        }, new BeanInstanceProducer(){

            @Override
            public <B> B produceBeanInstance(Class<B> beanType) {
                return (B)GeneratorBinder.instantiateGeneratorViaDefaultConstructor(generatorClass);
            }

            @Override
            public <B> B produceBeanInstance(String name, Class<B> beanType) {
                return this.produceBeanInstance(beanType);
            }
        }).getBeanInstance());
    }

    private static <G extends Generator> G instantiateGenerator(Annotation annotation, MemberDetails memberDetails, Class<? extends Annotation> annotationType, GeneratorCreationContext creationContext, Class<? extends G> generatorClass) {
        try {
            try {
                return (G)((Generator)generatorClass.getConstructor(annotationType, Member.class, GeneratorCreationContext.class).newInstance(annotation, memberDetails.toJavaMember(), creationContext));
            }
            catch (NoSuchMethodException ignore) {
                try {
                    return (G)((Generator)generatorClass.getConstructor(annotationType).newInstance(annotation));
                }
                catch (NoSuchMethodException i) {
                    return GeneratorBinder.instantiateGeneratorViaDefaultConstructor(generatorClass);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | java.lang.InstantiationException | InvocationTargetException e) {
            throw new InstantiationException("Could not instantiate id generator", generatorClass, e);
        }
    }

    public static <T extends Generator> T instantiateGenerator(BeanContainer beanContainer, Class<T> generatorClass) {
        if (beanContainer != null) {
            return GeneratorBinder.instantiateGeneratorAsBean(beanContainer, generatorClass);
        }
        return GeneratorBinder.instantiateGeneratorViaDefaultConstructor(generatorClass);
    }

    private static <G extends Generator> G instantiateGeneratorViaDefaultConstructor(Class<? extends G> generatorClass) {
        try {
            return (G)((Generator)generatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException("No appropriate constructor for id generator class", generatorClass);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate id generator", generatorClass, e);
        }
    }

    public static <A extends Annotation> void callInitialize(A annotation, MemberDetails memberDetails, GeneratorCreationContext creationContext, Generator generator) {
        if (generator instanceof AnnotationBasedGenerator) {
            AnnotationBasedGenerator generation = (AnnotationBasedGenerator)generator;
            generation.initialize(annotation, memberDetails.toJavaMember(), creationContext);
        }
    }

    private static void checkVersionGenerationAlways(MemberDetails property, Generator generator) {
        if (property.hasDirectAnnotationUsage(Version.class)) {
            if (!generator.generatesOnInsert()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on inserts");
            }
            if (!generator.generatesOnUpdate()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on updates");
            }
        }
    }

    public static void callConfigure(GeneratorCreationContext creationContext, Generator generator, Map<String, Object> configuration, SimpleValue identifierValue) {
        Configurable configurable;
        if (generator instanceof Configurable) {
            configurable = (Configurable)((Object)generator);
            Properties parameters = GeneratorParameters.collectParameters(identifierValue, creationContext.getDatabase().getDialect(), creationContext.getRootClass(), configuration);
            configurable.configure(creationContext, parameters);
        }
        if (generator instanceof ExportableProducer) {
            ExportableProducer exportableProducer = (ExportableProducer)((Object)generator);
            exportableProducer.registerExportables(creationContext.getDatabase());
        }
        if (generator instanceof Configurable) {
            configurable = (Configurable)((Object)generator);
            configurable.initialize(creationContext.getSqlStringGenerationContext());
        }
    }

    private static void checkIdGeneratorTiming(Class<? extends Annotation> annotationType, Generator generator) {
        if (!generator.generatesOnInsert()) {
            throw new MappingException("Annotation '" + annotationType + "' is annotated 'IdGeneratorType' but the given 'Generator' does not generate on inserts");
        }
        if (generator.generatesOnUpdate()) {
            throw new MappingException("Annotation '" + annotationType + "' is annotated 'IdGeneratorType' but the given 'Generator' generates on updates (it must generate only on inserts)");
        }
    }

    private static void createIdGenerator(MemberDetails idMember, SimpleValue idValue, PersistentClass persistentClass, MetadataBuildingContext context) {
        GeneratedValue generatedValue = NullnessUtil.castNonNull((GeneratedValue)idMember.getDirectAnnotationUsage(GeneratedValue.class));
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            metadataCollector.getGlobalRegistrations().as(GlobalRegistrar.class).collectIdGenerators(idMember);
            metadataCollector.addSecondPass(new StrictIdGeneratorResolverSecondPass(persistentClass, idValue, idMember, generatedValue, context));
        } else {
            metadataCollector.addSecondPass(new IdGeneratorResolverSecondPass(persistentClass, idValue, idMember, generatedValue, context));
        }
    }

    public static void createGeneratorFrom(IdentifierGeneratorDefinition defaultedGenerator, SimpleValue idValue, Map<String, Object> configuration, MetadataBuildingContext context) {
        configuration.putAll(defaultedGenerator.getParameters());
        BeanContainer beanContainer = GeneratorBinder.beanContainer(context);
        idValue.setCustomIdGeneratorCreator(creationContext -> {
            Generator identifierGenerator = GeneratorBinder.instantiateGenerator(beanContainer, GeneratorStrategies.generatorClass(defaultedGenerator.getStrategy(), idValue));
            GeneratorBinder.callConfigure(creationContext, identifierGenerator, configuration, idValue);
            if (identifierGenerator instanceof IdentityGenerator) {
                idValue.setColumnToIdentity();
            }
            return identifierGenerator;
        });
    }

    public static void createGeneratorFrom(IdentifierGeneratorDefinition defaultedGenerator, SimpleValue idValue, MetadataBuildingContext context) {
        GeneratorBinder.createGeneratorFrom(defaultedGenerator, idValue, GeneratorBinder.buildConfigurationMap(idValue), context);
    }

    private static Map<String, Object> buildConfigurationMap(KeyValue idValue) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("target_table", idValue.getTable().getName());
        if (idValue.getColumnSpan() == 1) {
            configuration.put("target_column", idValue.getColumns().get(0).getName());
        }
        return configuration;
    }

    public static void makeIdGenerator(MappingDocument sourceDocument, IdentifierGeneratorDefinition definition, SimpleValue identifierValue, MetadataBuildingContext context) {
        if (definition != null) {
            String generatorStrategy;
            IdentifierGeneratorDefinition generatorDef = sourceDocument.getMetadataCollector().getIdentifierGenerator(definition.getName());
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            if (generatorDef != null) {
                generatorStrategy = generatorDef.getStrategy();
                configuration.putAll(generatorDef.getParameters());
            } else {
                generatorStrategy = definition.getStrategy();
            }
            configuration.putAll(definition.getParameters());
            GeneratorBinder.setGeneratorCreator(identifierValue, configuration, generatorStrategy, context);
        }
    }

    public static BeanContainer beanContainer(MetadataBuildingContext buildingContext) {
        StandardServiceRegistry serviceRegistry = buildingContext.getBootstrapContext().getServiceRegistry();
        return Helper.allowExtensionsInCdi(serviceRegistry) ? serviceRegistry.requireService(ManagedBeanRegistry.class).getBeanContainer() : null;
    }

    private static void setGeneratorCreator(SimpleValue identifierValue, Map<String, Object> configuration, String generatorStrategy, MetadataBuildingContext context) {
        if (ASSIGNED_GENERATOR_NAME.equals(generatorStrategy) || org.hibernate.id.Assigned.class.getName().equals(generatorStrategy)) {
            identifierValue.setCustomIdGeneratorCreator(ASSIGNED_IDENTIFIER_GENERATOR_CREATOR);
        } else {
            BeanContainer beanContainer = GeneratorBinder.beanContainer(context);
            identifierValue.setCustomIdGeneratorCreator(creationContext -> {
                Generator identifierGenerator = GeneratorBinder.instantiateGenerator(beanContainer, GeneratorStrategies.generatorClass(generatorStrategy, identifierValue));
                GeneratorBinder.callConfigure(creationContext, identifierGenerator, configuration, identifierValue);
                if (identifierGenerator instanceof IdentityGenerator) {
                    identifierValue.setColumnToIdentity();
                }
                return identifierGenerator;
            });
        }
    }

    static void createIdGeneratorsFromGeneratorAnnotations(PropertyHolder propertyHolder, PropertyData inferredData, SimpleValue idValue, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        MemberDetails idAttributeMember = inferredData.getAttributeMember();
        List idGeneratorAnnotations = idAttributeMember.getMetaAnnotated(IdGeneratorType.class, sourceModelContext);
        List generatorAnnotations = idAttributeMember.getMetaAnnotated(ValueGenerationType.class, sourceModelContext);
        for (Annotation id : idGeneratorAnnotations) {
            generatorAnnotations.removeIf(gen -> gen.annotationType().equals(id.annotationType()));
        }
        if (idGeneratorAnnotations.size() + generatorAnnotations.size() > 1) {
            throw new AnnotationException(String.format(Locale.ROOT, "Identifier attribute '%s' has too many generator annotations: %s", BinderHelper.getPath(propertyHolder, inferredData), CollectionHelper.combineUntyped(idGeneratorAnnotations, generatorAnnotations)));
        }
        if (!idGeneratorAnnotations.isEmpty()) {
            idValue.setCustomIdGeneratorCreator(GeneratorBinder.identifierGeneratorCreator(idAttributeMember, (Annotation)idGeneratorAnnotations.get(0), idValue, GeneratorBinder.beanContainer(context)));
        } else {
            if (!generatorAnnotations.isEmpty()) {
                throw new AnnotationException(String.format(Locale.ROOT, "Identifier attribute '%s' is annotated '%s' which is not an '@IdGeneratorType'", BinderHelper.getPath(propertyHolder, inferredData), ((Annotation)generatorAnnotations.get(0)).annotationType()));
            }
            if (idAttributeMember.hasDirectAnnotationUsage(GeneratedValue.class)) {
                GeneratorBinder.createIdGenerator(idAttributeMember, idValue, propertyHolder.getPersistentClass(), context);
            }
        }
    }

    static GeneratorCreator createValueGeneratorFromAnnotations(PropertyHolder holder, String propertyName, MemberDetails property, MetadataBuildingContext context) {
        List generatorAnnotations = property.getMetaAnnotated(ValueGenerationType.class, context.getMetadataCollector().getSourceModelBuildingContext());
        return switch (generatorAnnotations.size()) {
            case 0 -> null;
            case 1 -> GeneratorBinder.generatorCreator(property, (Annotation)generatorAnnotations.get(0), GeneratorBinder.beanContainer(context));
            default -> throw new AnnotationException("Property '" + StringHelper.qualify(holder.getPath(), propertyName) + "' has too many generator annotations: " + generatorAnnotations);
        };
    }

    public static void applyIfNotEmpty(String name, String value, BiConsumer<String, String> consumer) {
        if (StringHelper.isNotEmpty(value)) {
            consumer.accept(name, value);
        }
    }
}

