/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.converter.internal.JpaAttributeConverterImpl;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class AnnotationHelper {
    public static HashMap<String, String> extractParameterMap(Parameter[] parameters) {
        HashMap<String, String> paramMap = CollectionHelper.mapOfSize(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            paramMap.put(parameters[i].name(), parameters[i].value());
        }
        return paramMap;
    }

    public static JdbcMapping resolveUserType(Class<UserType<?>> userTypeClass, MetadataBuildingContext context) {
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        UserType<?> userType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(userTypeClass) : bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(userTypeClass).getBeanInstance();
        return new CustomType(userType, bootstrapContext.getTypeConfiguration());
    }

    public static JdbcMapping resolveAttributeConverter(Class<AttributeConverter<?, ?>> type, MetadataBuildingContext context) {
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        ManagedBean<AttributeConverter<?, ?>> bean = bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(type);
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        ParameterizedType converterParameterizedType = GenericsHelper.extractParameterizedType(bean.getBeanClass());
        Class<?> domainJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[1]);
        JavaType domainJtd = jtdRegistry.resolveDescriptor(domainJavaClass);
        JavaType relationalJtd = jtdRegistry.resolveDescriptor(relationalJavaClass);
        JavaType converterJtd = jtdRegistry.resolveDescriptor(bean.getBeanClass());
        JpaAttributeConverterImpl valueConverter = new JpaAttributeConverterImpl(bean, converterJtd, domainJtd, relationalJtd);
        return new ConvertedBasicTypeImpl("converted::" + valueConverter.getConverterJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getTypeName(), relationalJtd.getTypeName()), relationalJtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators()), valueConverter);
    }

    public static BasicType<Object> resolveBasicType(Class<?> type, final MetadataBuildingContext context) {
        final TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType jtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(type);
        if (jtd != null) {
            JdbcType jdbcType = jtd.getRecommendedJdbcType(new JdbcTypeIndicators(){

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }

                @Override
                public int getPreferredSqlTypeCodeForBoolean() {
                    return context.getPreferredSqlTypeCodeForBoolean();
                }

                @Override
                public int getPreferredSqlTypeCodeForDuration() {
                    return context.getPreferredSqlTypeCodeForDuration();
                }

                @Override
                public int getPreferredSqlTypeCodeForUuid() {
                    return context.getPreferredSqlTypeCodeForUuid();
                }

                @Override
                public int getPreferredSqlTypeCodeForInstant() {
                    return context.getPreferredSqlTypeCodeForInstant();
                }

                @Override
                public int getPreferredSqlTypeCodeForArray() {
                    return context.getPreferredSqlTypeCodeForArray();
                }

                @Override
                public Dialect getDialect() {
                    return context.getMetadataCollector().getDatabase().getDialect();
                }
            });
            return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
        }
        return null;
    }

    public static JdbcMapping resolveJavaType(Class<JavaType<?>> type, MetadataBuildingContext context) {
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType<?> jtd = AnnotationHelper.getJavaType(type, context, typeConfiguration);
        JdbcType jdbcType = jtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
    }

    private static JavaType<?> getJavaType(Class<JavaType<?>> javaTypeClass, MetadataBuildingContext context, TypeConfiguration typeConfiguration) {
        JavaType registeredJtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(javaTypeClass);
        if (registeredJtd != null) {
            return registeredJtd;
        }
        if (!context.getBuildingOptions().isAllowExtensionsInCdi()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
        }
        return context.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(javaTypeClass).getBeanInstance();
    }
}

