/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.GeneratorAnnotationHelper;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.GeneratorParameters;
import org.hibernate.boot.model.internal.GeneratorStrategies;
import org.hibernate.boot.model.internal.IdGeneratorResolver;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.Generator;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public abstract class AbstractEntityIdGeneratorResolver
implements IdGeneratorResolver {
    protected final PersistentClass entityMapping;
    protected final SimpleValue idValue;
    protected final MemberDetails idMember;
    protected final GeneratedValue generatedValue;
    protected final MetadataBuildingContext buildingContext;

    public AbstractEntityIdGeneratorResolver(PersistentClass entityMapping, SimpleValue idValue, MemberDetails idMember, GeneratedValue generatedValue, MetadataBuildingContext buildingContext) {
        this.entityMapping = entityMapping;
        this.idValue = idValue;
        this.idMember = idMember;
        this.generatedValue = generatedValue;
        this.buildingContext = buildingContext;
    }

    @Override
    public final void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        switch (this.generatedValue.strategy()) {
            case UUID: {
                GeneratorAnnotationHelper.handleUuidStrategy(this.idValue, this.idMember, this.buildingContext);
                break;
            }
            case IDENTITY: {
                GeneratorAnnotationHelper.handleIdentityStrategy(this.idValue);
                break;
            }
            case SEQUENCE: {
                this.handleSequenceStrategy();
                break;
            }
            case TABLE: {
                this.handleTableStrategy();
                break;
            }
            case AUTO: {
                this.handleAutoStrategy();
            }
        }
    }

    private void handleSequenceStrategy() {
        if (this.generatedValue.generator().isEmpty()) {
            this.handleUnnamedSequenceGenerator();
        } else {
            this.handleNamedSequenceGenerator();
        }
    }

    protected abstract void handleUnnamedSequenceGenerator();

    protected abstract void handleNamedSequenceGenerator();

    private void handleTableStrategy() {
        if (this.generatedValue.generator().isEmpty()) {
            this.handleUnnamedTableGenerator();
        } else {
            this.handleNamedTableGenerator();
        }
    }

    protected abstract void handleUnnamedTableGenerator();

    protected abstract void handleNamedTableGenerator();

    private void handleAutoStrategy() {
        if (this.generatedValue.generator().isEmpty()) {
            this.handleUnnamedAutoGenerator();
        } else {
            this.handleNamedAutoGenerator();
        }
    }

    protected abstract void handleUnnamedAutoGenerator();

    protected abstract void handleNamedAutoGenerator();

    protected boolean handleAsMetaAnnotated() {
        Annotation fromPackage;
        Annotation fromMember = this.findGeneratorAnnotation((AnnotationTarget)this.idMember);
        if (fromMember != null) {
            GeneratorAnnotationHelper.handleIdGeneratorType(fromMember, this.idValue, this.idMember, this.buildingContext);
            return true;
        }
        Annotation fromClass = this.findGeneratorAnnotation((AnnotationTarget)this.idMember.getDeclaringType());
        if (fromClass != null) {
            GeneratorAnnotationHelper.handleIdGeneratorType(fromClass, this.idValue, this.idMember, this.buildingContext);
            return true;
        }
        ClassDetails packageInfoDetails = GeneratorAnnotationHelper.locatePackageInfoDetails(this.idMember.getDeclaringType(), this.buildingContext);
        if (packageInfoDetails != null && (fromPackage = this.findGeneratorAnnotation((AnnotationTarget)packageInfoDetails)) != null) {
            GeneratorAnnotationHelper.handleIdGeneratorType(fromPackage, this.idValue, this.idMember, this.buildingContext);
            return true;
        }
        return false;
    }

    private Annotation findGeneratorAnnotation(AnnotationTarget annotationTarget) {
        List metaAnnotated = annotationTarget.getMetaAnnotated(IdGeneratorType.class, this.buildingContext.getMetadataCollector().getSourceModelBuildingContext());
        if (CollectionHelper.size(metaAnnotated) > 0) {
            return (Annotation)metaAnnotated.get(0);
        }
        return null;
    }

    protected boolean handleAsLegacyGenerator() {
        Class<? extends Generator> legacyNamedGenerator;
        String nameFromGeneratedValue = this.generatedValue.generator();
        if (!nameFromGeneratedValue.isEmpty() && (legacyNamedGenerator = GeneratorStrategies.mapLegacyNamedGenerator(nameFromGeneratedValue, this.idValue)) != null) {
            HashMap<String, Object> configuration = this.buildLegacyGeneratorConfig();
            GeneratorBinder.createGeneratorFrom(new IdentifierGeneratorDefinition(nameFromGeneratedValue, legacyNamedGenerator.getName(), configuration), this.idValue, configuration, this.buildingContext);
            return true;
        }
        return false;
    }

    private HashMap<String, String> buildLegacyGeneratorConfig() {
        Database database = this.buildingContext.getMetadataCollector().getDatabase();
        Dialect dialect = database.getDialect();
        HashMap<String, String> configuration = new HashMap<String, String>();
        String tableName = this.idValue.getTable().getQuotedName(dialect);
        configuration.put("target_table", tableName);
        Column idColumn = (Column)this.idValue.getSelectables().get(0);
        String idColumnName = idColumn.getQuotedName(dialect);
        configuration.put("target_column", idColumnName);
        configuration.put("entity_name", this.entityMapping.getEntityName());
        configuration.put("jpa_entity_name", this.entityMapping.getJpaEntityName());
        configuration.put("implicit_name_base", this.idValue.getTable().isSubselect() ? this.entityMapping.getJpaEntityName() : this.idValue.getTable().getName());
        configuration.put("identity_tables", GeneratorParameters.identityTablesString(dialect, this.entityMapping.getRootClass()));
        return configuration;
    }
}

