/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.beanvalidation;

import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.boot.beanvalidation.ActivationContext;
import org.hibernate.boot.beanvalidation.BeanValidationEventListener;
import org.hibernate.boot.beanvalidation.DuplicationStrategyImpl;
import org.hibernate.boot.beanvalidation.GroupsPerOperation;
import org.hibernate.boot.beanvalidation.IntegrationException;
import org.hibernate.boot.beanvalidation.ValidationMode;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.jboss.logging.Logger;

class TypeSafeActivator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)TypeSafeActivator.class.getName());

    TypeSafeActivator() {
    }

    public static void validateSuppliedFactory(Object object) {
        if (!(object instanceof ValidatorFactory)) {
            throw new IntegrationException("Given object was not an instance of " + ValidatorFactory.class.getName() + " [" + object.getClass().getName() + "]");
        }
    }

    public static void activate(ActivationContext context) {
        ValidatorFactory factory;
        try {
            factory = TypeSafeActivator.getValidatorFactory(context);
        }
        catch (IntegrationException e) {
            Set<ValidationMode> validationModes = context.getValidationModes();
            if (validationModes.contains((Object)ValidationMode.CALLBACK)) {
                throw new IntegrationException("Bean Validation provider was not available, but 'callback' validation was requested", (Throwable)((Object)e));
            }
            if (validationModes.contains((Object)ValidationMode.DDL)) {
                throw new IntegrationException("Bean Validation provider was not available, but 'ddl' validation was requested", (Throwable)((Object)e));
            }
            LOG.debug("Unable to acquire Bean Validation ValidatorFactory, skipping activation");
            return;
        }
        TypeSafeActivator.applyRelationalConstraints(factory, context);
        TypeSafeActivator.applyCallbackListeners(factory, context);
    }

    public static void applyCallbackListeners(ValidatorFactory validatorFactory, ActivationContext context) {
        if (TypeSafeActivator.isValidationEnabled(context)) {
            TypeSafeActivator.disableNullabilityChecking(context);
            TypeSafeActivator.setupListener(validatorFactory, context.getServiceRegistry());
        }
    }

    private static boolean isValidationEnabled(ActivationContext context) {
        Set<ValidationMode> modes = context.getValidationModes();
        return modes.contains((Object)ValidationMode.CALLBACK) || modes.contains((Object)ValidationMode.AUTO);
    }

    private static void disableNullabilityChecking(ActivationContext context) {
        if (TypeSafeActivator.isCheckNullabilityExplicit(context)) {
            context.getSessionFactory().getSessionFactoryOptions().setCheckNullability(false);
        }
    }

    private static boolean isCheckNullabilityExplicit(ActivationContext context) {
        return context.getServiceRegistry().requireService(ConfigurationService.class).getSettings().get("hibernate.check_nullability") == null;
    }

    private static void setupListener(ValidatorFactory validatorFactory, SessionFactoryServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = serviceRegistry.requireService(ClassLoaderService.class);
        ConfigurationService cfgService = serviceRegistry.requireService(ConfigurationService.class);
        BeanValidationEventListener listener = new BeanValidationEventListener(validatorFactory, cfgService.getSettings(), classLoaderService);
        EventListenerRegistry listenerRegistry = serviceRegistry.requireService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy(DuplicationStrategyImpl.INSTANCE);
        listenerRegistry.appendListeners(EventType.PRE_INSERT, listener);
        listenerRegistry.appendListeners(EventType.PRE_UPDATE, listener);
        listenerRegistry.appendListeners(EventType.PRE_DELETE, listener);
        listenerRegistry.appendListeners(EventType.PRE_UPSERT, listener);
        listener.initialize(cfgService.getSettings(), classLoaderService);
    }

    private static boolean isConstraintBasedValidationEnabled(ActivationContext context) {
        if (context.getServiceRegistry().requireService(ConfigurationService.class).getSetting("hibernate.validator.apply_to_ddl", StandardConverters.BOOLEAN, Boolean.valueOf(true)).booleanValue()) {
            Set<ValidationMode> modes = context.getValidationModes();
            return modes.contains((Object)ValidationMode.DDL) || modes.contains((Object)ValidationMode.AUTO);
        }
        LOG.debug("Skipping application of relational constraints from legacy Hibernate Validator");
        return false;
    }

    private static void applyRelationalConstraints(ValidatorFactory factory, ActivationContext context) {
        if (TypeSafeActivator.isConstraintBasedValidationEnabled(context)) {
            SessionFactoryServiceRegistry serviceRegistry = context.getServiceRegistry();
            TypeSafeActivator.applyRelationalConstraints(factory, context.getMetadata().getEntityBindings(), serviceRegistry.requireService(ConfigurationService.class).getSettings(), serviceRegistry.requireService(JdbcServices.class).getDialect(), new ClassLoaderAccessImpl(null, serviceRegistry.getService(ClassLoaderService.class)));
        }
    }

    public static void applyRelationalConstraints(ValidatorFactory factory, Collection<PersistentClass> persistentClasses, Map<String, Object> settings, Dialect dialect, ClassLoaderAccess classLoaderAccess) {
        Class<?>[] groupsArray = GroupsPerOperation.buildGroupsForOperation(GroupsPerOperation.Operation.DDL, settings, classLoaderAccess);
        HashSet groups = new HashSet(Arrays.asList(groupsArray));
        for (PersistentClass persistentClass : persistentClasses) {
            String className = persistentClass.getClassName();
            if (!StringHelper.isNotEmpty(className)) continue;
            Class<?> clazz = TypeSafeActivator.entityClass(classLoaderAccess, className);
            try {
                TypeSafeActivator.applyDDL("", persistentClass, clazz, factory, groups, true, dialect);
            }
            catch (Exception e) {
                LOG.unableToApplyConstraints(className, e);
            }
        }
    }

    private static Class<?> entityClass(ClassLoaderAccess classLoaderAccess, String className) {
        try {
            return classLoaderAccess.classForName(className);
        }
        catch (ClassLoadingException e) {
            throw new AssertionFailure("Entity class not found", (Throwable)((Object)e));
        }
    }

    private static void applyDDL(String prefix, PersistentClass persistentClass, Class<?> clazz, ValidatorFactory factory, Set<Class<?>> groups, boolean activateNotNull, Dialect dialect) {
        BeanDescriptor descriptor = factory.getValidator().getConstraintsForClass(clazz);
        for (PropertyDescriptor propertyDesc : descriptor.getConstrainedProperties()) {
            Property property = TypeSafeActivator.findPropertyByName(persistentClass, prefix + propertyDesc.getPropertyName());
            if (property == null) continue;
            boolean hasNotNull = TypeSafeActivator.applyConstraints(propertyDesc.getConstraintDescriptors(), property, propertyDesc, groups, activateNotNull, dialect);
            if (!property.isComposite() || !propertyDesc.isCascaded()) continue;
            Component component = (Component)property.getValue();
            TypeSafeActivator.applyDDL(prefix + propertyDesc.getPropertyName() + ".", persistentClass, component.getComponentClass(), factory, groups, activateNotNull && hasNotNull, dialect);
        }
    }

    private static boolean applyConstraints(Set<ConstraintDescriptor<?>> constraintDescriptors, Property property, PropertyDescriptor propertyDesc, Set<Class<?>> groups, boolean canApplyNotNull, Dialect dialect) {
        boolean hasNotNull = false;
        for (ConstraintDescriptor<?> descriptor : constraintDescriptors) {
            if (groups != null && Collections.disjoint(descriptor.getGroups(), groups)) continue;
            if (canApplyNotNull) {
                hasNotNull = hasNotNull || TypeSafeActivator.applyNotNull(property, descriptor);
            }
            TypeSafeActivator.applyDigits(property, descriptor);
            TypeSafeActivator.applySize(property, descriptor, propertyDesc);
            TypeSafeActivator.applyMin(property, descriptor, dialect);
            TypeSafeActivator.applyMax(property, descriptor, dialect);
            TypeSafeActivator.applyLength(property, descriptor, propertyDesc);
            boolean hasNotNullFromComposingConstraints = TypeSafeActivator.applyConstraints(descriptor.getComposingConstraints(), property, propertyDesc, null, canApplyNotNull, dialect);
            hasNotNull = hasNotNull || hasNotNullFromComposingConstraints;
        }
        return hasNotNull;
    }

    private static void applyMin(Property property, ConstraintDescriptor<?> descriptor, Dialect dialect) {
        if (Min.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> minConstraint = descriptor;
            long min = ((Min)minConstraint.getAnnotation()).value();
            for (Selectable selectable : property.getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                TypeSafeActivator.applySQLCheck(column, column.getQuotedName(dialect) + ">=" + min);
            }
        }
    }

    private static void applyMax(Property property, ConstraintDescriptor<?> descriptor, Dialect dialect) {
        if (Max.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> maxConstraint = descriptor;
            long max = ((Max)maxConstraint.getAnnotation()).value();
            for (Selectable selectable : property.getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                TypeSafeActivator.applySQLCheck(column, column.getQuotedName(dialect) + "<=" + max);
            }
        }
    }

    private static void applySQLCheck(Column column, String checkConstraint) {
        for (CheckConstraint constraint : column.getCheckConstraints()) {
            if (!constraint.getConstraint().equalsIgnoreCase(checkConstraint)) continue;
            return;
        }
        column.addCheckConstraint(new CheckConstraint(checkConstraint));
    }

    private static boolean applyNotNull(Property property, ConstraintDescriptor<?> descriptor) {
        boolean hasNotNull = false;
        Class<? extends Annotation> annotationType = descriptor.getAnnotation().annotationType();
        if (NotNull.class.equals(annotationType) || NotEmpty.class.equals(annotationType) || NotBlank.class.equals(annotationType)) {
            if (!(property.getPersistentClass() instanceof SingleTableSubclass) && !property.isComposite()) {
                for (Selectable selectable : property.getSelectables()) {
                    if (selectable instanceof Column) {
                        Column column = (Column)selectable;
                        column.setNullable(false);
                        continue;
                    }
                    LOG.debugf("@NotNull was applied to attribute [%s] which is defined (at least partially) by formula(s); formula portions will be skipped", property.getName());
                }
            }
            hasNotNull = true;
        }
        property.setOptional(!hasNotNull);
        return hasNotNull;
    }

    private static void applyDigits(Property property, ConstraintDescriptor<?> descriptor) {
        if (Digits.class.equals(descriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> digitsConstraint = descriptor;
            int integerDigits = ((Digits)digitsConstraint.getAnnotation()).integer();
            int fractionalDigits = ((Digits)digitsConstraint.getAnnotation()).fraction();
            for (Selectable selectable : property.getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                column.setPrecision(integerDigits + fractionalDigits);
                column.setScale(fractionalDigits);
            }
        }
    }

    private static void applySize(Property property, ConstraintDescriptor<?> descriptor, PropertyDescriptor propertyDescriptor) {
        if (Size.class.equals(descriptor.getAnnotation().annotationType()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            ConstraintDescriptor<?> sizeConstraint = descriptor;
            int max = ((Size)sizeConstraint.getAnnotation()).max();
            for (Column col : property.getColumns()) {
                if (max >= Integer.MAX_VALUE) continue;
                col.setLength(max);
            }
        }
    }

    private static void applyLength(Property property, ConstraintDescriptor<?> descriptor, PropertyDescriptor propertyDescriptor) {
        if (TypeSafeActivator.isValidatorLengthAnnotation(descriptor) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            int max = (Integer)descriptor.getAttributes().get("max");
            for (Selectable selectable : property.getSelectables()) {
                if (!(selectable instanceof Column)) continue;
                Column column = (Column)selectable;
                if (max >= Integer.MAX_VALUE) continue;
                column.setLength(max);
            }
        }
    }

    private static boolean isValidatorLengthAnnotation(ConstraintDescriptor<?> descriptor) {
        return "org.hibernate.validator.constraints.Length".equals(descriptor.getAnnotation().annotationType().getName());
    }

    private static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (StringHelper.isEmpty(propertyName) || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer tokens = new StringTokenizer(propertyName, ".", false);
                while (tokens.hasMoreTokens()) {
                    String element = tokens.nextToken();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer tokens = new StringTokenizer(propertyName, ".", false);
                while (tokens.hasMoreTokens()) {
                    String element = tokens.nextToken();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    private static ValidatorFactory getValidatorFactory(ActivationContext context) {
        ValidatorFactory providedFactory = TypeSafeActivator.resolveProvidedFactory(context.getSessionFactory().getSessionFactoryOptions());
        if (providedFactory != null) {
            return providedFactory;
        }
        ValidatorFactory configuredFactory = TypeSafeActivator.resolveProvidedFactory(context.getServiceRegistry().requireService(ConfigurationService.class));
        if (configuredFactory != null) {
            return configuredFactory;
        }
        try {
            return Validation.buildDefaultValidatorFactory();
        }
        catch (Exception e) {
            throw new IntegrationException("Unable to build the default ValidatorFactory", e);
        }
    }

    private static ValidatorFactory resolveProvidedFactory(SessionFactoryOptions options) {
        Object validatorFactoryReference = options.getValidatorFactoryReference();
        if (validatorFactoryReference == null) {
            return null;
        }
        if (validatorFactoryReference instanceof ValidatorFactory) {
            ValidatorFactory result = (ValidatorFactory)validatorFactoryReference;
            return result;
        }
        throw new IntegrationException(String.format(Locale.ENGLISH, "ValidatorFactory reference (provided via %s) was not castable to %s : %s", SessionFactoryOptions.class.getName(), ValidatorFactory.class.getName(), validatorFactoryReference.getClass().getName()));
    }

    private static ValidatorFactory resolveProvidedFactory(ConfigurationService cfgService) {
        return cfgService.getSetting("javax.persistence.validation.factory", value -> TypeSafeActivator.validatorFactory(value, "javax.persistence.validation.factory"), (ValidatorFactory)cfgService.getSetting("jakarta.persistence.validation.factory", value -> TypeSafeActivator.validatorFactory(value, "jakarta.persistence.validation.factory"), null));
    }

    private static ValidatorFactory validatorFactory(Object value, String setting) {
        if (value instanceof ValidatorFactory) {
            ValidatorFactory validatorFactory = (ValidatorFactory)value;
            return validatorFactory;
        }
        throw new IntegrationException(String.format(Locale.ENGLISH, "ValidatorFactory reference (provided via '%s' setting) was not an instance of '%s': %s", setting, ValidatorFactory.class.getName(), value.getClass().getName()));
    }
}

