/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.beanvalidation;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class HibernateTraversableResolver
implements TraversableResolver {
    private Set<String> associations;

    public HibernateTraversableResolver(EntityPersister persister, ConcurrentHashMap<EntityPersister, Set<String>> associationsPerEntityPersister, SessionFactoryImplementor factory) {
        this.associations = associationsPerEntityPersister.get(persister);
        if (this.associations == null) {
            this.associations = new HashSet<String>();
            this.addAssociationsToTheSetForAllProperties(persister.getPropertyNames(), persister.getPropertyTypes(), "", factory);
            associationsPerEntityPersister.put(persister, this.associations);
        }
    }

    private void addAssociationsToTheSetForAllProperties(String[] names, Type[] types, String prefix, SessionFactoryImplementor factory) {
        int length = names.length;
        for (int index = 0; index < length; ++index) {
            this.addAssociationsToTheSetForOneProperty(names[index], types[index], prefix, factory);
        }
    }

    private void addAssociationsToTheSetForOneProperty(String name, Type type, String prefix, SessionFactoryImplementor factory) {
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            this.addAssociationsToTheSetForOneProperty(name, collectionType.getElementType(factory), prefix, factory);
        } else if (type instanceof EntityType || type instanceof AnyType) {
            this.associations.add(prefix + name);
        } else if (type instanceof ComponentType) {
            ComponentType componentType = (ComponentType)type;
            this.addAssociationsToTheSetForAllProperties(componentType.getPropertyNames(), componentType.getSubtypes(), (String)(prefix.isEmpty() ? name : prefix + name) + ".", factory);
        }
    }

    private String getStringBasedPath(Path.Node traversableProperty, Path pathToTraversableObject) {
        StringBuilder path = new StringBuilder();
        for (Path.Node node : pathToTraversableObject) {
            if (node.getName() == null) continue;
            path.append(node.getName()).append('.');
        }
        if (traversableProperty.getName() == null) {
            throw new AssertionFailure("TraversableResolver being passed a traversableProperty with null name. pathToTraversableObject: " + path);
        }
        path.append(traversableProperty.getName());
        return path.toString();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return Hibernate.isInitialized(traversableObject) && Hibernate.isPropertyInitialized(traversableObject, traversableProperty.getName());
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return !this.associations.contains(this.getStringBasedPath(traversableProperty, pathToTraversableObject));
    }
}

