/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.FindOption;
import jakarta.persistence.LockModeType;
import jakarta.persistence.RefreshOption;
import java.util.Locale;
import org.hibernate.LockOptions;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;

public enum LockMode implements FindOption,
RefreshOption
{
    NONE,
    READ,
    OPTIMISTIC,
    OPTIMISTIC_FORCE_INCREMENT,
    WRITE,
    UPGRADE_NOWAIT,
    UPGRADE_SKIPLOCKED,
    PESSIMISTIC_READ,
    PESSIMISTIC_WRITE,
    PESSIMISTIC_FORCE_INCREMENT;


    public static LockMode fromJpaLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    public static LockModeType toJpaLockMode(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    public LockModeType toJpaLockMode() {
        return LockModeTypeHelper.getLockModeType(this);
    }

    public boolean greaterThan(LockMode mode) {
        return this.level() > mode.level();
    }

    public boolean lessThan(LockMode mode) {
        return this.level() < mode.level();
    }

    public boolean requiresVersion() {
        return this == OPTIMISTIC || this == OPTIMISTIC_FORCE_INCREMENT || this == PESSIMISTIC_FORCE_INCREMENT;
    }

    public String toExternalForm() {
        String externalForm = this.toString().toLowerCase(Locale.ROOT);
        return this == UPGRADE_NOWAIT || this == UPGRADE_SKIPLOCKED ? externalForm.replace('_', '-') : externalForm;
    }

    private int level() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> 0;
            case READ -> 1;
            case OPTIMISTIC -> 2;
            case OPTIMISTIC_FORCE_INCREMENT -> 3;
            case PESSIMISTIC_READ -> 4;
            case UPGRADE_NOWAIT, UPGRADE_SKIPLOCKED, PESSIMISTIC_WRITE -> 5;
            case PESSIMISTIC_FORCE_INCREMENT, WRITE -> 6;
        };
    }

    public static LockMode fromExternalForm(String externalForm) {
        if (externalForm == null) {
            return NONE;
        }
        for (LockMode lockMode : LockMode.values()) {
            if (!lockMode.toExternalForm().equalsIgnoreCase(externalForm)) continue;
            return lockMode;
        }
        if (externalForm.equalsIgnoreCase("upgrade")) {
            return PESSIMISTIC_WRITE;
        }
        throw new IllegalArgumentException("Unable to interpret LockMode reference from incoming external form: " + externalForm);
    }

    public LockOptions toLockOptions() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> LockOptions.NONE;
            case READ -> LockOptions.READ;
            case OPTIMISTIC -> LockOptions.OPTIMISTIC;
            case OPTIMISTIC_FORCE_INCREMENT -> LockOptions.OPTIMISTIC_FORCE_INCREMENT;
            case UPGRADE_NOWAIT -> LockOptions.UPGRADE_NOWAIT;
            case UPGRADE_SKIPLOCKED -> LockOptions.UPGRADE_SKIPLOCKED;
            case PESSIMISTIC_READ -> LockOptions.PESSIMISTIC_READ;
            case PESSIMISTIC_WRITE -> LockOptions.PESSIMISTIC_WRITE;
            case PESSIMISTIC_FORCE_INCREMENT -> LockOptions.PESSIMISTIC_FORCE_INCREMENT;
            case WRITE -> throw new UnsupportedOperationException("WRITE is not a valid LockMode as an argument");
        };
    }
}

