/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.hibernate.internal.util.StringHelper;

public enum ConnectionAcquisitionMode {
    IMMEDIATELY,
    AS_NEEDED;


    public static ConnectionAcquisitionMode interpret(String value) {
        return "immediate".equalsIgnoreCase(value) || "immediately".equalsIgnoreCase(value) ? IMMEDIATELY : AS_NEEDED;
    }

    public static ConnectionAcquisitionMode interpret(Object setting) {
        if (setting == null) {
            return null;
        }
        if (setting instanceof ConnectionAcquisitionMode) {
            ConnectionAcquisitionMode mode = (ConnectionAcquisitionMode)((Object)setting);
            return mode;
        }
        String value = setting.toString();
        if (StringHelper.isEmpty(value)) {
            return null;
        }
        return ConnectionAcquisitionMode.interpret(value);
    }
}

