/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.hesperides.core.domain.security.AuthenticationProvider;
import org.hesperides.core.infrastructure.security.LdapConfiguration;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LdapAuthenticationProvider
extends AbstractLdapAuthenticationProvider
implements AuthenticationProvider {
    private LdapConfiguration ldapConfiguration;

    public LdapAuthenticationProvider(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    protected DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken auth) {
        String username = auth.getName();
        String password = (String)auth.getCredentials();
        DirContext ctx = this.buildSearchContext(username, password);
        return this.searchUser(ctx, username);
    }

    private DirContext buildSearchContext(String username, String password) {
        InitialLdapContext context;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapConfiguration.getUrl());
        env.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        env.put("com.sun.jndi.ldap.connect.timeout", this.ldapConfiguration.getConnectTimeout());
        env.put("com.sun.jndi.ldap.read.timeout", this.ldapConfiguration.getReadTimeout());
        env.put("java.naming.security.principal", String.format("%s\\%s", this.ldapConfiguration.getDomain(), username));
        env.put("java.naming.security.credentials", password);
        try {
            context = new InitialLdapContext(env, null);
        }
        catch (AuthenticationException | OperationNotSupportedException e) {
            throw this.badCredentials(e);
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException((NamingException)e);
        }
        return context;
    }

    private DirContextOperations searchUser(DirContext ctx, String username) {
        DirContextOperations dirContextOperations;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String searchFilter = String.format("(%s=%s)", this.ldapConfiguration.getUsernameAttribute(), username);
            dirContextOperations = SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)ctx, (SearchControls)searchControls, (String)this.ldapConfiguration.getUserSearchBase(), (String)searchFilter, (Object[])new Object[]{username});
        }
        catch (NamingException e) {
            throw this.badCredentials(e);
        }
        finally {
            LdapUtils.closeContext((DirContext)ctx);
        }
        return dirContextOperations;
    }

    private BadCredentialsException badCredentials(Throwable cause) {
        return (BadCredentialsException)this.badCredentials().initCause(cause);
    }

    private BadCredentialsException badCredentials() {
        return new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        String[] groups = userData.getStringAttributes("memberOf");
        if (this.hasGroup(groups, this.ldapConfiguration.getProdGroupName())) {
            authorities.add(new SimpleGrantedAuthority("ROLE_PROD"));
        }
        if (this.hasGroup(groups, this.ldapConfiguration.getTechGroupName())) {
            authorities.add(new SimpleGrantedAuthority("ROLE_TECH"));
        }
        return authorities;
    }

    private boolean hasGroup(String[] groups, String groupName) {
        boolean hasRole = false;
        if (groups != null && StringUtils.hasText((String)groupName)) {
            for (String group : groups) {
                String commonName = this.getCommonName(group);
                if (!groupName.equalsIgnoreCase(commonName)) continue;
                hasRole = true;
                break;
            }
        }
        return hasRole;
    }

    private String getCommonName(String distinguishedName) {
        String commonName = null;
        LdapName ldapName = LdapUtils.newLdapName((String)distinguishedName);
        Rdn rdn = LdapUtils.getRdn((Name)ldapName, (String)"cn");
        if (rdn != null && rdn.getValue() != null) {
            commonName = rdn.getValue().toString();
        }
        return commonName;
    }
}

