/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.templatecontainers;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.templatecontainers.entities.Template;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.TemplateView;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class TemplateDocument {
    private String name;
    private String filename;
    private String location;
    private String content;
    private RightsDocument rights;
    private Long versionId;

    public TemplateDocument(Template template) {
        this.name = template.getName();
        this.filename = template.getFilename();
        this.location = template.getLocation();
        this.content = template.getContent();
        this.rights = RightsDocument.fromDomainInstance(template.getRights());
        this.versionId = template.getVersionId();
    }

    public static List<TemplateDocument> fromDomainInstances(List<Template> templates) {
        return Optional.ofNullable(templates).orElse(Collections.emptyList()).stream().map(TemplateDocument::new).collect(Collectors.toList());
    }

    public static List<TemplateView> toTemplateViews(List<TemplateDocument> templateDocuments, TemplateContainer.Key key) {
        return Optional.ofNullable(templateDocuments).orElse(Collections.emptyList()).stream().map(templateDocument -> templateDocument.toTemplateView(key)).collect(Collectors.toList());
    }

    public static List<Template> toDomainInstances(List<TemplateDocument> templateDocuments, TemplateContainer.Key key) {
        return Optional.ofNullable(templateDocuments).orElse(Collections.emptyList()).stream().map(templateDocument -> templateDocument.toDomainInstance(key)).collect(Collectors.toList());
    }

    private Template toDomainInstance(TemplateContainer.Key key) {
        return new Template(this.name, this.filename, this.location, this.content, RightsDocument.toDomainInstance(this.rights), this.versionId, key);
    }

    public TemplateView toTemplateView(TemplateContainer.Key key) {
        return new TemplateView(this.name, key.getNamespaceWithPrefix(), this.filename, this.location, this.content, RightsDocument.toRightsView(this.rights), this.versionId);
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContent() {
        return this.content;
    }

    public RightsDocument getRights() {
        return this.rights;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setRights(RightsDocument rights) {
        this.rights = rights;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateDocument)) {
            return false;
        }
        TemplateDocument other = (TemplateDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        RightsDocument this$rights = this.getRights();
        RightsDocument other$rights = other.getRights();
        if (this$rights == null ? other$rights != null : !((Object)this$rights).equals(other$rights)) {
            return false;
        }
        Long this$versionId = this.getVersionId();
        Long other$versionId = other.getVersionId();
        return !(this$versionId == null ? other$versionId != null : !((Object)this$versionId).equals(other$versionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        RightsDocument $rights = this.getRights();
        result = result * 59 + ($rights == null ? 43 : ((Object)$rights).hashCode());
        Long $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : ((Object)$versionId).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateDocument(name=" + this.getName() + ", filename=" + this.getFilename() + ", location=" + this.getLocation() + ", content=" + this.getContent() + ", rights=" + this.getRights() + ", versionId=" + this.getVersionId() + ")";
    }

    public TemplateDocument() {
    }

    public static class FileRightsDocument {
        private Boolean read;
        private Boolean write;
        private Boolean execute;

        public static FileRightsDocument fromDomainInstance(Template.FileRights fileRights) {
            FileRightsDocument fileRightsDocument = null;
            if (fileRights != null) {
                fileRightsDocument = new FileRightsDocument();
                fileRightsDocument.setRead(fileRights.getRead());
                fileRightsDocument.setWrite(fileRights.getWrite());
                fileRightsDocument.setExecute(fileRights.getExecute());
            }
            return fileRightsDocument;
        }

        public static TemplateView.FileRightsView toFileRightsView(FileRightsDocument fileRightsDocument) {
            TemplateView.FileRightsView fileRightsView = null;
            if (fileRightsDocument != null) {
                fileRightsView = new TemplateView.FileRightsView(fileRightsDocument.read, fileRightsDocument.write, fileRightsDocument.execute);
            }
            return fileRightsView;
        }

        public static Template.FileRights toDomainInstance(FileRightsDocument fileRightsDocument) {
            Template.FileRights fileRights = null;
            if (fileRightsDocument != null) {
                fileRights = new Template.FileRights(fileRightsDocument.read, fileRightsDocument.write, fileRightsDocument.execute);
            }
            return fileRights;
        }

        public Boolean getRead() {
            return this.read;
        }

        public Boolean getWrite() {
            return this.write;
        }

        public Boolean getExecute() {
            return this.execute;
        }

        public void setRead(Boolean read) {
            this.read = read;
        }

        public void setWrite(Boolean write) {
            this.write = write;
        }

        public void setExecute(Boolean execute) {
            this.execute = execute;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileRightsDocument)) {
                return false;
            }
            FileRightsDocument other = (FileRightsDocument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$read = this.getRead();
            Boolean other$read = other.getRead();
            if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
                return false;
            }
            Boolean this$write = this.getWrite();
            Boolean other$write = other.getWrite();
            if (this$write == null ? other$write != null : !((Object)this$write).equals(other$write)) {
                return false;
            }
            Boolean this$execute = this.getExecute();
            Boolean other$execute = other.getExecute();
            return !(this$execute == null ? other$execute != null : !((Object)this$execute).equals(other$execute));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileRightsDocument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $read = this.getRead();
            result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
            Boolean $write = this.getWrite();
            result = result * 59 + ($write == null ? 43 : ((Object)$write).hashCode());
            Boolean $execute = this.getExecute();
            result = result * 59 + ($execute == null ? 43 : ((Object)$execute).hashCode());
            return result;
        }

        public String toString() {
            return "TemplateDocument.FileRightsDocument(read=" + this.getRead() + ", write=" + this.getWrite() + ", execute=" + this.getExecute() + ")";
        }
    }

    public static class RightsDocument {
        private FileRightsDocument user;
        private FileRightsDocument group;
        private FileRightsDocument other;

        public static RightsDocument fromDomainInstance(Template.Rights rights) {
            RightsDocument rightsDocument = null;
            if (rights != null) {
                rightsDocument = new RightsDocument();
                rightsDocument.setUser(FileRightsDocument.fromDomainInstance(rights.getUser()));
                rightsDocument.setGroup(FileRightsDocument.fromDomainInstance(rights.getGroup()));
                rightsDocument.setOther(FileRightsDocument.fromDomainInstance(rights.getOther()));
            }
            return rightsDocument;
        }

        public static TemplateView.RightsView toRightsView(RightsDocument rightsDocument) {
            TemplateView.RightsView rightsView = null;
            if (rightsDocument != null) {
                rightsView = new TemplateView.RightsView(FileRightsDocument.toFileRightsView(rightsDocument.user), FileRightsDocument.toFileRightsView(rightsDocument.group), FileRightsDocument.toFileRightsView(rightsDocument.other));
            }
            return rightsView;
        }

        public static Template.Rights toDomainInstance(RightsDocument rightsDocument) {
            Template.Rights rights = null;
            if (rightsDocument != null) {
                rights = new Template.Rights(FileRightsDocument.toDomainInstance(rightsDocument.user), FileRightsDocument.toDomainInstance(rightsDocument.group), FileRightsDocument.toDomainInstance(rightsDocument.other));
            }
            return rights;
        }

        public FileRightsDocument getUser() {
            return this.user;
        }

        public FileRightsDocument getGroup() {
            return this.group;
        }

        public FileRightsDocument getOther() {
            return this.other;
        }

        public void setUser(FileRightsDocument user) {
            this.user = user;
        }

        public void setGroup(FileRightsDocument group) {
            this.group = group;
        }

        public void setOther(FileRightsDocument other) {
            this.other = other;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RightsDocument)) {
                return false;
            }
            RightsDocument other = (RightsDocument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FileRightsDocument this$user = this.getUser();
            FileRightsDocument other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            FileRightsDocument this$group = this.getGroup();
            FileRightsDocument other$group = other.getGroup();
            if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
                return false;
            }
            FileRightsDocument this$other = this.getOther();
            FileRightsDocument other$other = other.getOther();
            return !(this$other == null ? other$other != null : !((Object)this$other).equals(other$other));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RightsDocument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FileRightsDocument $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            FileRightsDocument $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
            FileRightsDocument $other = this.getOther();
            result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
            return result;
        }

        public String toString() {
            return "TemplateDocument.RightsDocument(user=" + this.getUser() + ", group=" + this.getGroup() + ", other=" + this.getOther() + ")";
        }
    }
}

