/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.templatecontainers;

import org.hesperides.core.domain.templatecontainers.entities.Property;
import org.hesperides.core.domain.templatecontainers.queries.PropertyView;
import org.hesperides.core.infrastructure.mongo.templatecontainers.AbstractPropertyDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class PropertyDocument
extends AbstractPropertyDocument {
    private boolean isRequired;
    private String comment;
    private String defaultValue;
    private String pattern;
    private boolean isPassword;

    public PropertyDocument(Property property) {
        this.name = property.getName();
        this.isRequired = property.isRequired();
        this.comment = property.getComment();
        this.defaultValue = property.getDefaultValue();
        this.pattern = property.getPattern();
        this.isPassword = property.isPassword();
    }

    public PropertyView toPropertyView() {
        return new PropertyView(this.getName(), this.isRequired, this.comment, this.defaultValue, this.pattern, this.isPassword);
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setPassword(boolean isPassword) {
        this.isPassword = isPassword;
    }

    @Override
    public String toString() {
        return "PropertyDocument(isRequired=" + this.isRequired() + ", comment=" + this.getComment() + ", defaultValue=" + this.getDefaultValue() + ", pattern=" + this.getPattern() + ", isPassword=" + this.isPassword() + ")";
    }

    public PropertyDocument() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyDocument)) {
            return false;
        }
        PropertyDocument other = (PropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        return this.isPassword() == other.isPassword();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PropertyDocument;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        result = result * 59 + (this.isPassword() ? 79 : 97);
        return result;
    }
}

