/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.templatecontainers;

import java.util.List;
import org.hesperides.core.domain.templatecontainers.entities.IterableProperty;
import org.hesperides.core.domain.templatecontainers.queries.IterablePropertyView;
import org.hesperides.core.infrastructure.mongo.templatecontainers.AbstractPropertyDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class IterablePropertyDocument
extends AbstractPropertyDocument {
    private List<AbstractPropertyDocument> properties;

    public IterablePropertyDocument(IterableProperty iterableProperty) {
        this.name = iterableProperty.getName();
        this.properties = AbstractPropertyDocument.fromDomainInstances(iterableProperty.getProperties());
    }

    public IterablePropertyView toIterableProperyView() {
        return new IterablePropertyView(this.getName(), AbstractPropertyDocument.toAbstractPropertyViews(this.properties));
    }

    public List<AbstractPropertyDocument> getProperties() {
        return this.properties;
    }

    public void setProperties(List<AbstractPropertyDocument> properties) {
        this.properties = properties;
    }

    @Override
    public String toString() {
        return "IterablePropertyDocument(properties=" + this.getProperties() + ")";
    }

    public IterablePropertyDocument() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IterablePropertyDocument)) {
            return false;
        }
        IterablePropertyDocument other = (IterablePropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<AbstractPropertyDocument> this$properties = this.getProperties();
        List<AbstractPropertyDocument> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IterablePropertyDocument;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<AbstractPropertyDocument> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

