/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.templatecontainers;

import java.util.ArrayList;
import java.util.List;
import org.hesperides.core.domain.templatecontainers.entities.AbstractProperty;
import org.hesperides.core.domain.templatecontainers.entities.IterableProperty;
import org.hesperides.core.domain.templatecontainers.entities.Property;
import org.hesperides.core.domain.templatecontainers.queries.AbstractPropertyView;
import org.hesperides.core.domain.templatecontainers.queries.IterablePropertyView;
import org.hesperides.core.domain.templatecontainers.queries.PropertyView;
import org.hesperides.core.infrastructure.mongo.templatecontainers.IterablePropertyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.PropertyDocument;

public abstract class AbstractPropertyDocument {
    protected String name;

    public static List<AbstractPropertyDocument> fromDomainInstances(List<AbstractProperty> abstractProperties) {
        ArrayList<AbstractPropertyDocument> abstractPropertyDocuments = new ArrayList<AbstractPropertyDocument>();
        if (abstractProperties != null) {
            for (AbstractProperty abstractProperty : abstractProperties) {
                if (abstractProperty instanceof Property) {
                    Property property = (Property)abstractProperty;
                    PropertyDocument propertyDocument = new PropertyDocument(property);
                    abstractPropertyDocuments.add(propertyDocument);
                    continue;
                }
                if (!(abstractProperty instanceof IterableProperty)) continue;
                IterableProperty iterableProperty = (IterableProperty)abstractProperty;
                IterablePropertyDocument iterablePropertyDocument = new IterablePropertyDocument(iterableProperty);
                abstractPropertyDocuments.add(iterablePropertyDocument);
            }
        }
        return abstractPropertyDocuments;
    }

    public static List<AbstractPropertyView> toAbstractPropertyViews(List<AbstractPropertyDocument> abstractPropertyDocuments) {
        ArrayList<AbstractPropertyView> abstractPropertyViews = new ArrayList<AbstractPropertyView>();
        if (abstractPropertyDocuments != null) {
            for (AbstractPropertyDocument abstractPropertyDocument : abstractPropertyDocuments) {
                if (abstractPropertyDocument instanceof PropertyDocument) {
                    PropertyDocument propertyDocument = (PropertyDocument)abstractPropertyDocument;
                    PropertyView propertyView = propertyDocument.toPropertyView();
                    abstractPropertyViews.add((AbstractPropertyView)propertyView);
                    continue;
                }
                if (!(abstractPropertyDocument instanceof IterablePropertyDocument)) continue;
                IterablePropertyDocument iterablePropertyDocument = (IterablePropertyDocument)abstractPropertyDocument;
                IterablePropertyView iterablePropertyView = iterablePropertyDocument.toIterableProperyView();
                abstractPropertyViews.add((AbstractPropertyView)iterablePropertyView);
            }
        }
        return abstractPropertyViews;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPropertyDocument)) {
            return false;
        }
        AbstractPropertyDocument other = (AbstractPropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractPropertyDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractPropertyDocument(name=" + this.getName() + ")";
    }
}

