/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.technos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.technos.entities.Techno;
import org.hesperides.core.domain.technos.queries.TechnoView;
import org.hesperides.core.domain.templatecontainers.entities.AbstractProperty;
import org.hesperides.core.domain.templatecontainers.entities.Template;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.infrastructure.mongo.technos.MongoTechnoRepository;
import org.hesperides.core.infrastructure.mongo.templatecontainers.AbstractPropertyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.KeyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.TemplateDocument;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="techno")
public class TechnoDocument {
    @Id
    private String id;
    @Indexed
    private KeyDocument key;
    private List<TemplateDocument> templates;
    private List<AbstractPropertyDocument> properties;

    public TechnoDocument(String id, Techno techno) {
        this.id = id;
        this.key = new KeyDocument(techno.getKey());
        this.templates = TemplateDocument.fromDomainInstances(techno.getTemplates());
    }

    public static List<TechnoView> toTechnoViews(List<TechnoDocument> technos) {
        return Optional.ofNullable(technos).orElse(Collections.emptyList()).stream().map(TechnoDocument::toTechnoView).collect(Collectors.toList());
    }

    public static List<Techno> toDomainInstances(List<TechnoDocument> technoDocuments) {
        return Optional.ofNullable(technoDocuments).orElse(Collections.emptyList()).stream().map(TechnoDocument::toDomainInstance).collect(Collectors.toList());
    }

    public Techno toDomainInstance() {
        TemplateContainer.Key technoKey = this.getDomainKey();
        return new Techno(technoKey, TemplateDocument.toDomainInstances(this.templates, technoKey));
    }

    public TechnoView toTechnoView() {
        TemplateContainer.Key technoKey = this.getDomainKey();
        return new TechnoView(this.key.getName(), this.key.getVersion(), this.key.isWorkingCopy(), TemplateDocument.toTemplateViews(this.templates, technoKey));
    }

    public void addTemplate(TemplateDocument templateDocument) {
        if (this.templates == null) {
            this.templates = new ArrayList<TemplateDocument>();
        }
        this.templates.add(templateDocument);
    }

    public void updateTemplate(TemplateDocument updatedTemplateDocument) {
        this.removeTemplate(updatedTemplateDocument.getName());
        this.addTemplate(updatedTemplateDocument);
    }

    public void removeTemplate(String templateName) {
        this.templates.removeIf(templateDocument -> templateDocument.getName().equalsIgnoreCase(templateName));
    }

    public void extractPropertiesAndSave(MongoTechnoRepository technoRepository) {
        this.setProperties(this.extractPropertiesFromTemplates());
        technoRepository.save(this);
    }

    private List<AbstractPropertyDocument> extractPropertiesFromTemplates() {
        TemplateContainer.Key technoKey = this.getDomainKey();
        List<Template> templates = TemplateDocument.toDomainInstances(this.templates, technoKey);
        List abstractProperties = AbstractProperty.extractPropertiesFromTemplates(templates);
        List<AbstractPropertyDocument> abstractPropertyDocuments = AbstractPropertyDocument.fromDomainInstances(abstractProperties);
        return abstractPropertyDocuments;
    }

    private TemplateContainer.Key getDomainKey() {
        return new Techno.Key(this.key.getName(), this.key.getVersion(), TemplateContainer.getVersionType((boolean)this.key.isWorkingCopy()));
    }

    public String getId() {
        return this.id;
    }

    public KeyDocument getKey() {
        return this.key;
    }

    public List<TemplateDocument> getTemplates() {
        return this.templates;
    }

    public List<AbstractPropertyDocument> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKey(KeyDocument key) {
        this.key = key;
    }

    public void setTemplates(List<TemplateDocument> templates) {
        this.templates = templates;
    }

    public void setProperties(List<AbstractPropertyDocument> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TechnoDocument)) {
            return false;
        }
        TechnoDocument other = (TechnoDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        KeyDocument this$key = this.getKey();
        KeyDocument other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        List<TemplateDocument> this$templates = this.getTemplates();
        List<TemplateDocument> other$templates = other.getTemplates();
        if (this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates)) {
            return false;
        }
        List<AbstractPropertyDocument> this$properties = this.getProperties();
        List<AbstractPropertyDocument> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TechnoDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        KeyDocument $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        List<TemplateDocument> $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        List<AbstractPropertyDocument> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "TechnoDocument(id=" + this.getId() + ", key=" + this.getKey() + ", templates=" + this.getTemplates() + ", properties=" + this.getProperties() + ")";
    }

    public TechnoDocument() {
    }
}

