/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.technos;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.queryhandling.QueryHandler;
import org.hesperides.core.domain.technos.GetTechnoIdFromKeyQuery;
import org.hesperides.core.domain.technos.GetTechnoPropertiesQuery;
import org.hesperides.core.domain.technos.GetTechnoQuery;
import org.hesperides.core.domain.technos.GetTemplateQuery;
import org.hesperides.core.domain.technos.GetTemplatesQuery;
import org.hesperides.core.domain.technos.SearchTechnosQuery;
import org.hesperides.core.domain.technos.TechnoCreatedEvent;
import org.hesperides.core.domain.technos.TechnoDeletedEvent;
import org.hesperides.core.domain.technos.TechnoExistsQuery;
import org.hesperides.core.domain.technos.TechnoProjectionRepository;
import org.hesperides.core.domain.technos.TechnoTemplateDeletedEvent;
import org.hesperides.core.domain.technos.TechnoTemplateUpdatedEvent;
import org.hesperides.core.domain.technos.TemplateAddedToTechnoEvent;
import org.hesperides.core.domain.technos.entities.Techno;
import org.hesperides.core.domain.technos.queries.TechnoView;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.AbstractPropertyView;
import org.hesperides.core.domain.templatecontainers.queries.TemplateView;
import org.hesperides.core.infrastructure.mongo.modules.ModuleDocument;
import org.hesperides.core.infrastructure.mongo.modules.MongoModuleRepository;
import org.hesperides.core.infrastructure.mongo.technos.MongoTechnoRepository;
import org.hesperides.core.infrastructure.mongo.technos.TechnoDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.AbstractPropertyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.KeyDocument;
import org.hesperides.core.infrastructure.mongo.templatecontainers.TemplateDocument;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Profile(value={"mongo", "fake_mongo"})
@Repository
public class MongoTechnoProjectionRepository
implements TechnoProjectionRepository {
    private final MongoTechnoRepository technoRepository;
    private final MongoModuleRepository moduleRepository;

    @Autowired
    public MongoTechnoProjectionRepository(MongoTechnoRepository technoRepository, MongoModuleRepository moduleRepository) {
        this.technoRepository = technoRepository;
        this.moduleRepository = moduleRepository;
    }

    @EventHandler
    public void onTechnoCreatedEvent(TechnoCreatedEvent event) {
        TechnoDocument technoDocument = new TechnoDocument(event.getTechnoId(), event.getTechno());
        technoDocument.extractPropertiesAndSave(this.technoRepository);
    }

    public void onTechnoDeletedEvent(TechnoDeletedEvent event) {
        this.removeReferencesAndUpdateProperties(event.getTechnoId());
        this.technoRepository.deleteById(event.getTechnoId());
    }

    private void removeReferencesAndUpdateProperties(String technoId) {
        List<ModuleDocument> moduleDocuments = this.moduleRepository.findAllByTechnoId(technoId);
        moduleDocuments.forEach(moduleDocument -> {
            moduleDocument.setTechnos(moduleDocument.getTechnos().stream().filter(technoDocument -> !technoDocument.getId().equals(technoId)).collect(Collectors.toList()));
            moduleDocument.extractPropertiesAndSave(this.moduleRepository);
        });
    }

    @EventHandler
    public void onTemplateAddedToTechnoEvent(TemplateAddedToTechnoEvent event) {
        TechnoDocument technoDocument = (TechnoDocument)this.technoRepository.findById(event.getTechnoId()).get();
        TemplateDocument templateDocument = new TemplateDocument(event.getTemplate());
        technoDocument.addTemplate(templateDocument);
        technoDocument.extractPropertiesAndSave(this.technoRepository);
        this.updateModelUsingTechno(event.getTechnoId());
    }

    @EventHandler
    public void onTechnoTemplateUpdatedEvent(TechnoTemplateUpdatedEvent event) {
        TechnoDocument technoDocument = (TechnoDocument)this.technoRepository.findById(event.getTechnoId()).get();
        TemplateDocument templateDocument = new TemplateDocument(event.getTemplate());
        technoDocument.updateTemplate(templateDocument);
        technoDocument.extractPropertiesAndSave(this.technoRepository);
        this.updateModelUsingTechno(event.getTechnoId());
    }

    @EventHandler
    public void onTechnoTemplateDeletedEvent(TechnoTemplateDeletedEvent event) {
        TechnoDocument technoDocument = (TechnoDocument)this.technoRepository.findById(event.getTechnoId()).get();
        technoDocument.removeTemplate(event.getTemplateName());
        technoDocument.extractPropertiesAndSave(this.technoRepository);
        this.updateModelUsingTechno(event.getTechnoId());
    }

    private void updateModelUsingTechno(String id) {
        List<ModuleDocument> moduleDocuments = this.moduleRepository.findAllByTechnoId(id);
        moduleDocuments.forEach(moduleDocument -> moduleDocument.extractPropertiesAndSave(this.moduleRepository));
    }

    @QueryHandler
    public Optional<String> onGetTechnoIdFromKeyQuery(GetTechnoIdFromKeyQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getTechnoKey());
        return this.technoRepository.findOptionalIdByKey(keyDocument).map(TechnoDocument::getId);
    }

    @QueryHandler
    public Boolean onTechnoExistsQuery(TechnoExistsQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getTechnoKey());
        return this.technoRepository.existsByKey(keyDocument);
    }

    @QueryHandler
    public Optional<TemplateView> onGetTemplateQuery(GetTemplateQuery query) {
        TemplateContainer.Key technoKey = query.getTechnoKey();
        return this.technoRepository.findOptionalByKeyAndTemplatesName(new KeyDocument(technoKey), query.getTemplateName()).map(technoDocument -> technoDocument.getTemplates().stream().filter(templateDocument -> templateDocument.getName().equalsIgnoreCase(query.getTemplateName())).findFirst().map(templateDocument -> templateDocument.toTemplateView(technoKey))).orElse(Optional.empty());
    }

    @QueryHandler
    public List<TemplateView> onGetTemplatesQuery(GetTemplatesQuery query) {
        TemplateContainer.Key technoKey = query.getTechnoKey();
        return this.technoRepository.findOptionalByKey(new KeyDocument(technoKey)).map(technoDocument -> technoDocument.getTemplates().stream().map(templateDocument -> templateDocument.toTemplateView(technoKey)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @QueryHandler
    public Optional<TechnoView> onGetTechnoQuery(GetTechnoQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getTechnoKey());
        return this.technoRepository.findOptionalByKey(keyDocument).map(TechnoDocument::toTechnoView);
    }

    @QueryHandler
    public List<TechnoView> onSearchTechnosQuery(SearchTechnosQuery query) {
        String[] values = query.getInput().split(" ");
        String name = values.length >= 1 ? values[0] : "";
        String version = values.length >= 2 ? values[1] : "";
        PageRequest pageable = PageRequest.of((int)0, (int)10);
        return this.technoRepository.findAllByKeyNameLikeAndKeyVersionLike(name, version, (Pageable)pageable).stream().map(TechnoDocument::toTechnoView).collect(Collectors.toList());
    }

    @QueryHandler
    public List<AbstractPropertyView> onGetTechnoPropertiesQuery(GetTechnoPropertiesQuery query) {
        KeyDocument keyDocument = new KeyDocument(query.getTechnoKey());
        TechnoDocument technoDocument = this.technoRepository.findByKey(keyDocument);
        return AbstractPropertyDocument.toAbstractPropertyViews(technoDocument.getProperties());
    }

    public List<TechnoDocument> getTechnoDocumentsFromDomainInstances(List<Techno> technos) {
        return this.technoRepository.findAllByKeyIn(Optional.ofNullable(technos).orElse(Collections.emptyList()).stream().map(techno -> new KeyDocument(techno.getKey())).collect(Collectors.toList()));
    }
}

