/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.properties.ValuedProperty;
import org.hesperides.core.domain.platforms.queries.views.properties.ValuedPropertyView;
import org.hesperides.core.infrastructure.mongo.platforms.documents.AbstractValuedPropertyDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class ValuedPropertyDocument
extends AbstractValuedPropertyDocument {
    private String value;

    public ValuedPropertyDocument(ValuedProperty valuedProperty) {
        this.name = valuedProperty.getName();
        this.value = valuedProperty.getValue();
    }

    public static ValuedProperty toDomainInstance(ValuedPropertyDocument valuedPropertyDocument) {
        return new ValuedProperty(valuedPropertyDocument.name, valuedPropertyDocument.value);
    }

    public static List<ValuedProperty> toDomainInstances(List<ValuedPropertyDocument> valuedPropertyDocuments) {
        return Optional.ofNullable(valuedPropertyDocuments).orElse(Collections.emptyList()).stream().map(ValuedPropertyDocument::toDomainInstance).collect(Collectors.toList());
    }

    public ValuedPropertyView toValuedPropertyView() {
        return new ValuedPropertyView(this.getName(), this.value);
    }

    public static List<ValuedPropertyDocument> fromDomainInstances(List<ValuedProperty> valuedProperties) {
        return Optional.ofNullable(valuedProperties).orElse(Collections.emptyList()).stream().map(ValuedPropertyDocument::new).collect(Collectors.toList());
    }

    public static List<ValuedPropertyView> toValuedPropertyViews(List<ValuedPropertyDocument> valuedPropertyDocuments) {
        return Optional.ofNullable(valuedPropertyDocuments).orElse(Collections.emptyList()).stream().map(ValuedPropertyDocument::toValuedPropertyView).collect(Collectors.toList());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "ValuedPropertyDocument(value=" + this.getValue() + ")";
    }

    public ValuedPropertyDocument() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValuedPropertyDocument)) {
            return false;
        }
        ValuedPropertyDocument other = (ValuedPropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ValuedPropertyDocument;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

