/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.Platform;
import org.hesperides.core.domain.platforms.queries.views.ApplicationView;
import org.hesperides.core.domain.platforms.queries.views.ModulePlatformView;
import org.hesperides.core.domain.platforms.queries.views.PlatformView;
import org.hesperides.core.domain.platforms.queries.views.SearchApplicationResultView;
import org.hesperides.core.domain.platforms.queries.views.SearchPlatformResultView;
import org.hesperides.core.infrastructure.mongo.platforms.MongoPlatformRepository;
import org.hesperides.core.infrastructure.mongo.platforms.documents.DeployedModuleDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.PlatformKeyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.ValuedPropertyDocument;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="platform")
public class PlatformDocument {
    @Id
    private String id;
    @Indexed
    private PlatformKeyDocument key;
    private String version;
    private boolean isProductionPlatform;
    private Long versionId;
    private List<DeployedModuleDocument> deployedModules;
    private List<ValuedPropertyDocument> valuedProperties;

    public PlatformDocument(String id, Platform platform) {
        this.id = id;
        this.key = new PlatformKeyDocument(platform.getKey());
        this.version = platform.getVersion();
        this.isProductionPlatform = platform.isProductionPlatform();
        this.versionId = platform.getVersionId();
        this.deployedModules = DeployedModuleDocument.fromDomainInstances(platform.getDeployedModules());
    }

    public PlatformView toPlatformView() {
        return new PlatformView(this.key.getPlatformName(), this.key.getApplicationName(), this.version, this.isProductionPlatform, DeployedModuleDocument.toDeployedModuleViews(this.deployedModules), this.versionId, ValuedPropertyDocument.toValuedPropertyViews(this.valuedProperties));
    }

    public ModulePlatformView toModulePlatformView() {
        return new ModulePlatformView(this.key.getApplicationName(), this.key.getPlatformName());
    }

    public SearchApplicationResultView toSearchApplicationResultView() {
        return new SearchApplicationResultView(this.key.getApplicationName());
    }

    public SearchPlatformResultView toSearchPlatformResultView() {
        return new SearchPlatformResultView(this.key.getPlatformName());
    }

    public static ApplicationView toApplicationView(String applicationName, List<PlatformDocument> platformDocuments) {
        return new ApplicationView(applicationName, platformDocuments.stream().map(PlatformDocument::toPlatformView).collect(Collectors.toList()));
    }

    public void extractInstancePropertiesAndSave(MongoPlatformRepository platformRepository) {
        this.deployedModules = Optional.ofNullable(this.deployedModules).orElse(Collections.emptyList()).stream().map(deployedModule -> deployedModule.toDomainInstance()).map(deployedModule -> deployedModule.extractAndSetInstanceProperties(ValuedPropertyDocument.toDomainInstances(this.valuedProperties))).map(DeployedModuleDocument::new).collect(Collectors.toList());
        platformRepository.save(this);
    }

    public String getId() {
        return this.id;
    }

    public PlatformKeyDocument getKey() {
        return this.key;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isProductionPlatform() {
        return this.isProductionPlatform;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public List<DeployedModuleDocument> getDeployedModules() {
        return this.deployedModules;
    }

    public List<ValuedPropertyDocument> getValuedProperties() {
        return this.valuedProperties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKey(PlatformKeyDocument key) {
        this.key = key;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setProductionPlatform(boolean isProductionPlatform) {
        this.isProductionPlatform = isProductionPlatform;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public void setDeployedModules(List<DeployedModuleDocument> deployedModules) {
        this.deployedModules = deployedModules;
    }

    public void setValuedProperties(List<ValuedPropertyDocument> valuedProperties) {
        this.valuedProperties = valuedProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformDocument)) {
            return false;
        }
        PlatformDocument other = (PlatformDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PlatformKeyDocument this$key = this.getKey();
        PlatformKeyDocument other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (this.isProductionPlatform() != other.isProductionPlatform()) {
            return false;
        }
        Long this$versionId = this.getVersionId();
        Long other$versionId = other.getVersionId();
        if (this$versionId == null ? other$versionId != null : !((Object)this$versionId).equals(other$versionId)) {
            return false;
        }
        List<DeployedModuleDocument> this$deployedModules = this.getDeployedModules();
        List<DeployedModuleDocument> other$deployedModules = other.getDeployedModules();
        if (this$deployedModules == null ? other$deployedModules != null : !((Object)this$deployedModules).equals(other$deployedModules)) {
            return false;
        }
        List<ValuedPropertyDocument> this$valuedProperties = this.getValuedProperties();
        List<ValuedPropertyDocument> other$valuedProperties = other.getValuedProperties();
        return !(this$valuedProperties == null ? other$valuedProperties != null : !((Object)this$valuedProperties).equals(other$valuedProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlatformDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PlatformKeyDocument $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + (this.isProductionPlatform() ? 79 : 97);
        Long $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : ((Object)$versionId).hashCode());
        List<DeployedModuleDocument> $deployedModules = this.getDeployedModules();
        result = result * 59 + ($deployedModules == null ? 43 : ((Object)$deployedModules).hashCode());
        List<ValuedPropertyDocument> $valuedProperties = this.getValuedProperties();
        result = result * 59 + ($valuedProperties == null ? 43 : ((Object)$valuedProperties).hashCode());
        return result;
    }

    public String toString() {
        return "PlatformDocument(id=" + this.getId() + ", key=" + this.getKey() + ", version=" + this.getVersion() + ", isProductionPlatform=" + this.isProductionPlatform() + ", versionId=" + this.getVersionId() + ", deployedModules=" + this.getDeployedModules() + ", valuedProperties=" + this.getValuedProperties() + ")";
    }

    public PlatformDocument() {
    }
}

