/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.properties.IterableValuedProperty;
import org.hesperides.core.domain.platforms.queries.views.properties.IterableValuedPropertyView;
import org.hesperides.core.infrastructure.mongo.platforms.documents.AbstractValuedPropertyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.IterablePropertyItemDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class IterableValuedPropertyDocument
extends AbstractValuedPropertyDocument {
    private List<IterablePropertyItemDocument> iterablePropertyItems;

    public IterableValuedPropertyDocument(IterableValuedProperty iterableValuedProperty) {
        this.name = iterableValuedProperty.getName();
        this.iterablePropertyItems = IterablePropertyItemDocument.fromDomainInstances(iterableValuedProperty.getItems());
    }

    public static IterableValuedProperty toDomainInstance(IterableValuedPropertyDocument iterableValuedPropertyDocument) {
        return new IterableValuedProperty(iterableValuedPropertyDocument.name, IterablePropertyItemDocument.toDomainInstances(iterableValuedPropertyDocument.iterablePropertyItems));
    }

    public IterableValuedPropertyView toIterableValuedPropertyView() {
        return new IterableValuedPropertyView(this.getName(), IterablePropertyItemDocument.toIterablePropertyItemViews(this.iterablePropertyItems));
    }

    public static List<IterableValuedPropertyView> toIterableValuedPropertyViews(List<IterableValuedPropertyDocument> iterableValuedPropertyDocuments) {
        return Optional.ofNullable(iterableValuedPropertyDocuments).orElse(Collections.emptyList()).stream().map(IterableValuedPropertyDocument::toIterableValuedPropertyView).collect(Collectors.toList());
    }

    public List<IterablePropertyItemDocument> getIterablePropertyItems() {
        return this.iterablePropertyItems;
    }

    public void setIterablePropertyItems(List<IterablePropertyItemDocument> iterablePropertyItems) {
        this.iterablePropertyItems = iterablePropertyItems;
    }

    @Override
    public String toString() {
        return "IterableValuedPropertyDocument(iterablePropertyItems=" + this.getIterablePropertyItems() + ")";
    }

    public IterableValuedPropertyDocument() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IterableValuedPropertyDocument)) {
            return false;
        }
        IterableValuedPropertyDocument other = (IterableValuedPropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<IterablePropertyItemDocument> this$iterablePropertyItems = this.getIterablePropertyItems();
        List<IterablePropertyItemDocument> other$iterablePropertyItems = other.getIterablePropertyItems();
        return !(this$iterablePropertyItems == null ? other$iterablePropertyItems != null : !((Object)this$iterablePropertyItems).equals(other$iterablePropertyItems));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IterableValuedPropertyDocument;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<IterablePropertyItemDocument> $iterablePropertyItems = this.getIterablePropertyItems();
        result = result * 59 + ($iterablePropertyItems == null ? 43 : ((Object)$iterablePropertyItems).hashCode());
        return result;
    }
}

