/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.properties.IterablePropertyItem;
import org.hesperides.core.domain.platforms.queries.views.properties.IterablePropertyItemView;
import org.hesperides.core.infrastructure.mongo.platforms.documents.AbstractValuedPropertyDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class IterablePropertyItemDocument {
    String title;
    private List<AbstractValuedPropertyDocument> iterableValuedProperties;

    public IterablePropertyItemDocument(IterablePropertyItem iterablePropertyItem) {
        this.title = iterablePropertyItem.getTitle();
        this.iterableValuedProperties = AbstractValuedPropertyDocument.fromAbstractDomainInstances(iterablePropertyItem.getAbstractValuedProperties());
    }

    public static List<IterablePropertyItemView> toIterablePropertyItemViews(List<IterablePropertyItemDocument> iterablePropertyItems) {
        return Optional.ofNullable(iterablePropertyItems).orElse(Collections.emptyList()).stream().map(IterablePropertyItemDocument::toIterablePropertyItemView).collect(Collectors.toList());
    }

    public static IterablePropertyItemView toIterablePropertyItemView(IterablePropertyItemDocument iterablePropertyItemDocument) {
        return new IterablePropertyItemView(iterablePropertyItemDocument.getTitle(), AbstractValuedPropertyDocument.toAbstractValuedPropertyViews(iterablePropertyItemDocument.getIterableValuedProperties()));
    }

    public static List<IterablePropertyItem> toDomainInstances(List<IterablePropertyItemDocument> iterablePropertyItemDocuments) {
        return Optional.ofNullable(iterablePropertyItemDocuments).orElse(Collections.emptyList()).stream().map(IterablePropertyItemDocument::toDomainInstance).collect(Collectors.toList());
    }

    public static IterablePropertyItem toDomainInstance(IterablePropertyItemDocument iterablePropertyItemDocument) {
        return new IterablePropertyItem(iterablePropertyItemDocument.title, AbstractValuedPropertyDocument.toAbstractDomainInstances(iterablePropertyItemDocument.iterableValuedProperties));
    }

    public static List<IterablePropertyItemDocument> fromDomainInstances(List<IterablePropertyItem> items) {
        return Optional.ofNullable(items).orElse(Collections.emptyList()).stream().map(IterablePropertyItemDocument::new).collect(Collectors.toList());
    }

    public String getTitle() {
        return this.title;
    }

    public List<AbstractValuedPropertyDocument> getIterableValuedProperties() {
        return this.iterableValuedProperties;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setIterableValuedProperties(List<AbstractValuedPropertyDocument> iterableValuedProperties) {
        this.iterableValuedProperties = iterableValuedProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IterablePropertyItemDocument)) {
            return false;
        }
        IterablePropertyItemDocument other = (IterablePropertyItemDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<AbstractValuedPropertyDocument> this$iterableValuedProperties = this.getIterableValuedProperties();
        List<AbstractValuedPropertyDocument> other$iterableValuedProperties = other.getIterableValuedProperties();
        return !(this$iterableValuedProperties == null ? other$iterableValuedProperties != null : !((Object)this$iterableValuedProperties).equals(other$iterableValuedProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IterablePropertyItemDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<AbstractValuedPropertyDocument> $iterableValuedProperties = this.getIterableValuedProperties();
        result = result * 59 + ($iterableValuedProperties == null ? 43 : ((Object)$iterableValuedProperties).hashCode());
        return result;
    }

    public String toString() {
        return "IterablePropertyItemDocument(title=" + this.getTitle() + ", iterableValuedProperties=" + this.getIterableValuedProperties() + ")";
    }

    public IterablePropertyItemDocument() {
    }
}

