/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.InstanceProperty;
import org.hesperides.core.domain.platforms.queries.views.InstancePropertyView;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class InstancePropertyDocument {
    private String name;

    public InstancePropertyDocument(InstanceProperty instanceProperty) {
        this.name = instanceProperty.getName();
    }

    public static List<InstancePropertyDocument> fromDomainInstances(List<InstanceProperty> instanceProperties) {
        return Optional.ofNullable(instanceProperties).orElse(Collections.emptyList()).stream().map(InstancePropertyDocument::new).collect(Collectors.toList());
    }

    public static List<InstanceProperty> toDomainInstances(List<InstancePropertyDocument> instancePropertyDocuments) {
        return Optional.ofNullable(instancePropertyDocuments).orElse(Collections.emptyList()).stream().map(InstancePropertyDocument::toDomainInstance).collect(Collectors.toList());
    }

    public static InstanceProperty toDomainInstance(InstancePropertyDocument instancePropertyDocument) {
        return new InstanceProperty(instancePropertyDocument.name);
    }

    public InstancePropertyView toInstancePropertyView() {
        return new InstancePropertyView(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstancePropertyDocument)) {
            return false;
        }
        InstancePropertyDocument other = (InstancePropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstancePropertyDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "InstancePropertyDocument(name=" + this.getName() + ")";
    }

    public InstancePropertyDocument() {
    }
}

