/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.Instance;
import org.hesperides.core.domain.platforms.queries.views.InstanceView;
import org.hesperides.core.infrastructure.mongo.platforms.documents.ValuedPropertyDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class InstanceDocument {
    private String name;
    List<ValuedPropertyDocument> valuedProperties;

    public InstanceDocument(Instance instance) {
        this.name = instance.getName();
        this.valuedProperties = ValuedPropertyDocument.fromDomainInstances(instance.getValuedProperties());
    }

    public static List<Instance> toDomainInstances(List<InstanceDocument> instanceDocuments) {
        return Optional.ofNullable(instanceDocuments).orElse(Collections.emptyList()).stream().map(InstanceDocument::toDomainInstance).collect(Collectors.toList());
    }

    private static Instance toDomainInstance(InstanceDocument instanceDocument) {
        return new Instance(instanceDocument.name, ValuedPropertyDocument.toDomainInstances(instanceDocument.valuedProperties));
    }

    public InstanceView toInstanceView() {
        return new InstanceView(this.name, ValuedPropertyDocument.toValuedPropertyViews(this.valuedProperties));
    }

    public static List<InstanceDocument> fromDomainInstances(List<Instance> instances) {
        return Optional.ofNullable(instances).orElse(Collections.emptyList()).stream().map(InstanceDocument::new).collect(Collectors.toList());
    }

    public static List<InstanceView> toInstanceViews(List<InstanceDocument> instances) {
        return Optional.ofNullable(instances).orElse(Collections.emptyList()).stream().map(InstanceDocument::toInstanceView).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public List<ValuedPropertyDocument> getValuedProperties() {
        return this.valuedProperties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValuedProperties(List<ValuedPropertyDocument> valuedProperties) {
        this.valuedProperties = valuedProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceDocument)) {
            return false;
        }
        InstanceDocument other = (InstanceDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ValuedPropertyDocument> this$valuedProperties = this.getValuedProperties();
        List<ValuedPropertyDocument> other$valuedProperties = other.getValuedProperties();
        return !(this$valuedProperties == null ? other$valuedProperties != null : !((Object)this$valuedProperties).equals(other$valuedProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstanceDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ValuedPropertyDocument> $valuedProperties = this.getValuedProperties();
        result = result * 59 + ($valuedProperties == null ? 43 : ((Object)$valuedProperties).hashCode());
        return result;
    }

    public String toString() {
        return "InstanceDocument(name=" + this.getName() + ", valuedProperties=" + this.getValuedProperties() + ")";
    }

    public InstanceDocument() {
    }
}

