/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.DeployedModule;
import org.hesperides.core.domain.platforms.queries.views.DeployedModuleView;
import org.hesperides.core.infrastructure.mongo.platforms.documents.AbstractValuedPropertyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.InstanceDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.InstancePropertyDocument;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class DeployedModuleDocument {
    private Long id;
    private String name;
    private String version;
    private boolean isWorkingCopy;
    private String path;
    private String propertiesPath;
    private List<AbstractValuedPropertyDocument> valuedProperties;
    private List<InstanceDocument> instances;
    private List<InstancePropertyDocument> instanceProperties;

    public DeployedModuleDocument(DeployedModule deployedModule) {
        this.id = deployedModule.getId();
        this.name = deployedModule.getName();
        this.version = deployedModule.getVersion();
        this.isWorkingCopy = deployedModule.isWorkingCopy();
        this.path = deployedModule.getPath();
        this.propertiesPath = deployedModule.getPropertiesPath();
        this.valuedProperties = AbstractValuedPropertyDocument.fromAbstractDomainInstances(deployedModule.getValuedProperties());
        this.instances = InstanceDocument.fromDomainInstances(deployedModule.getInstances());
        this.instanceProperties = InstancePropertyDocument.fromDomainInstances(deployedModule.getInstancesProperties());
    }

    public DeployedModuleView toDeployedModuleView() {
        return new DeployedModuleView(this.id, this.name, this.version, this.isWorkingCopy, this.path, this.propertiesPath, InstanceDocument.toInstanceViews(this.instances), AbstractValuedPropertyDocument.toAbstractValuedPropertyViews(this.valuedProperties));
    }

    public static List<DeployedModuleDocument> fromDomainInstances(List<DeployedModule> deployedModules) {
        return Optional.ofNullable(deployedModules).orElse(Collections.emptyList()).stream().map(DeployedModuleDocument::new).collect(Collectors.toList());
    }

    public static List<DeployedModuleView> toDeployedModuleViews(List<DeployedModuleDocument> deployedModules) {
        return Optional.ofNullable(deployedModules).orElse(Collections.emptyList()).stream().map(DeployedModuleDocument::toDeployedModuleView).collect(Collectors.toList());
    }

    public DeployedModule toDomainInstance() {
        return new DeployedModule(this.id, this.name, this.version, this.isWorkingCopy, this.path, AbstractValuedPropertyDocument.toAbstractDomainInstances(this.valuedProperties), InstanceDocument.toDomainInstances(this.instances), InstancePropertyDocument.toDomainInstances(this.instanceProperties));
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isWorkingCopy() {
        return this.isWorkingCopy;
    }

    public String getPath() {
        return this.path;
    }

    public String getPropertiesPath() {
        return this.propertiesPath;
    }

    public List<AbstractValuedPropertyDocument> getValuedProperties() {
        return this.valuedProperties;
    }

    public List<InstanceDocument> getInstances() {
        return this.instances;
    }

    public List<InstancePropertyDocument> getInstanceProperties() {
        return this.instanceProperties;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setWorkingCopy(boolean isWorkingCopy) {
        this.isWorkingCopy = isWorkingCopy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPropertiesPath(String propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    public void setValuedProperties(List<AbstractValuedPropertyDocument> valuedProperties) {
        this.valuedProperties = valuedProperties;
    }

    public void setInstances(List<InstanceDocument> instances) {
        this.instances = instances;
    }

    public void setInstanceProperties(List<InstancePropertyDocument> instanceProperties) {
        this.instanceProperties = instanceProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployedModuleDocument)) {
            return false;
        }
        DeployedModuleDocument other = (DeployedModuleDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (this.isWorkingCopy() != other.isWorkingCopy()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$propertiesPath = this.getPropertiesPath();
        String other$propertiesPath = other.getPropertiesPath();
        if (this$propertiesPath == null ? other$propertiesPath != null : !this$propertiesPath.equals(other$propertiesPath)) {
            return false;
        }
        List<AbstractValuedPropertyDocument> this$valuedProperties = this.getValuedProperties();
        List<AbstractValuedPropertyDocument> other$valuedProperties = other.getValuedProperties();
        if (this$valuedProperties == null ? other$valuedProperties != null : !((Object)this$valuedProperties).equals(other$valuedProperties)) {
            return false;
        }
        List<InstanceDocument> this$instances = this.getInstances();
        List<InstanceDocument> other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        List<InstancePropertyDocument> this$instanceProperties = this.getInstanceProperties();
        List<InstancePropertyDocument> other$instanceProperties = other.getInstanceProperties();
        return !(this$instanceProperties == null ? other$instanceProperties != null : !((Object)this$instanceProperties).equals(other$instanceProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeployedModuleDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + (this.isWorkingCopy() ? 79 : 97);
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $propertiesPath = this.getPropertiesPath();
        result = result * 59 + ($propertiesPath == null ? 43 : $propertiesPath.hashCode());
        List<AbstractValuedPropertyDocument> $valuedProperties = this.getValuedProperties();
        result = result * 59 + ($valuedProperties == null ? 43 : ((Object)$valuedProperties).hashCode());
        List<InstanceDocument> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        List<InstancePropertyDocument> $instanceProperties = this.getInstanceProperties();
        result = result * 59 + ($instanceProperties == null ? 43 : ((Object)$instanceProperties).hashCode());
        return result;
    }

    public String toString() {
        return "DeployedModuleDocument(id=" + this.getId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", isWorkingCopy=" + this.isWorkingCopy() + ", path=" + this.getPath() + ", propertiesPath=" + this.getPropertiesPath() + ", valuedProperties=" + this.getValuedProperties() + ", instances=" + this.getInstances() + ", instanceProperties=" + this.getInstanceProperties() + ")";
    }

    public DeployedModuleDocument() {
    }
}

