/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.infrastructure.mongo.platforms.documents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hesperides.core.domain.platforms.entities.properties.AbstractValuedProperty;
import org.hesperides.core.domain.platforms.entities.properties.IterableValuedProperty;
import org.hesperides.core.domain.platforms.entities.properties.ValuedProperty;
import org.hesperides.core.domain.platforms.queries.views.properties.AbstractValuedPropertyView;
import org.hesperides.core.domain.platforms.queries.views.properties.IterableValuedPropertyView;
import org.hesperides.core.domain.platforms.queries.views.properties.ValuedPropertyView;
import org.hesperides.core.infrastructure.mongo.platforms.documents.IterableValuedPropertyDocument;
import org.hesperides.core.infrastructure.mongo.platforms.documents.ValuedPropertyDocument;

public abstract class AbstractValuedPropertyDocument {
    protected String name;

    public static List<AbstractValuedPropertyView> toAbstractValuedPropertyViews(List<AbstractValuedPropertyDocument> properties) {
        List<ValuedPropertyDocument> valuedPropertyDocuments = AbstractValuedPropertyDocument.getAbstractValuedPropertyDocumentWithType(properties, ValuedPropertyDocument.class);
        List<ValuedPropertyView> valuedPropertyViews = ValuedPropertyDocument.toValuedPropertyViews(valuedPropertyDocuments);
        List<IterableValuedPropertyDocument> iterableValuedPropertyDocuments = AbstractValuedPropertyDocument.getAbstractValuedPropertyDocumentWithType(properties, IterableValuedPropertyDocument.class);
        List<IterableValuedPropertyView> iterableValuedPropertyViews = IterableValuedPropertyDocument.toIterableValuedPropertyViews(iterableValuedPropertyDocuments);
        ArrayList<ValuedPropertyView> abstractValuedPropertyViews = new ArrayList<ValuedPropertyView>(valuedPropertyViews);
        abstractValuedPropertyViews.addAll(iterableValuedPropertyViews);
        return abstractValuedPropertyViews;
    }

    private static <T extends AbstractValuedPropertyDocument> List<T> getAbstractValuedPropertyDocumentWithType(List<AbstractValuedPropertyDocument> properties, Class<T> clazz) {
        return Optional.ofNullable(properties).orElse(Collections.emptyList()).stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public static List<AbstractValuedPropertyDocument> fromAbstractDomainInstances(List<AbstractValuedProperty> abstractValuedProperties) {
        return Optional.ofNullable(abstractValuedProperties).orElse(Collections.emptyList()).stream().map(abstractValuedProperty -> abstractValuedProperty instanceof ValuedProperty ? new ValuedPropertyDocument((ValuedProperty)abstractValuedProperty) : new IterableValuedPropertyDocument((IterableValuedProperty)abstractValuedProperty)).collect(Collectors.toList());
    }

    public static List<AbstractValuedProperty> toAbstractDomainInstances(List<AbstractValuedPropertyDocument> abstractValuedPropertyDocuments) {
        return Optional.ofNullable(abstractValuedPropertyDocuments).orElse(Collections.emptyList()).stream().map(document -> document instanceof ValuedPropertyDocument ? ValuedPropertyDocument.toDomainInstance((ValuedPropertyDocument)document) : IterableValuedPropertyDocument.toDomainInstance((IterableValuedPropertyDocument)document)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractValuedPropertyDocument)) {
            return false;
        }
        AbstractValuedPropertyDocument other = (AbstractValuedPropertyDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractValuedPropertyDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractValuedPropertyDocument(name=" + this.getName() + ")";
    }
}

